% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history.R
\name{get_history}
\alias{get_history}
\title{Get historical market data for a ticker}
\usage{
get_history(
  ticker,
  period = "1mo",
  interval = "1d",
  start = NULL,
  end = NULL,
  prepost = FALSE,
  auto_adjust = TRUE,
  back_adjust = TRUE,
  repair = TRUE,
  proxy = NULL,
  output = c("tibble", "response", "request")
)
}
\arguments{
\item{ticker}{A ticker name or ticker object created with \code{get_tickers()}.}

\item{period}{The period to download data for (default "1mo").
Valid values are "1d", "5d", "1mo", "3mo", "6mo", "1y", "2y", "5y", "10y", "ytd", "max". Ignored if \code{start} and \code{end} are provided.}

\item{interval}{The interval between data points (default "1d").
Valid values are "1m", "2m", "5m", "15m", "30m", "60m", "90m", "1h", "1d", "5d", "1wk", "1mo", "3mo".}

\item{start}{Start time for query expressed as a date, datetime, or string in YYYY-MM-DD HH:MM:SS format.}

\item{end}{End time for query expressed as a date, datetime, or string in YYYY-MM-DD HH:MM:SS format.}

\item{prepost}{Include pre and post market data (default FALSE)}

\item{auto_adjust}{Adjust all OHLC automatically (default TRUE)}

\item{back_adjust}{Adjust data to reflect splits and dividends (default TRUE)}

\item{repair}{Repair missing data (default TRUE)}

\item{proxy}{Optional proxy settings}

\item{output}{Object to return. Can be "tibble", "response", or "request" (default "tibble")}
}
\value{
Either a tibble with historical market data, an httr2 response object, or an httr2 request object
depending on the value of the output argument.
}
\description{
Retrieves historical price data from Yahoo Finance for a specified ticker symbol.
}
\examples{
\dontrun{
apple <- get_tickers("AAPL")
# Get 1 month of daily data
apple_history <- get_history(apple)
# Get 1 year of daily data
apple_history_1y <- get_history(apple, period = "1y")
# Get custom date range
apple_history_custom <- get_history(
  apple,
  start = "2022-01-01",
  end = "2022-12-31"
)
}
}
