% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tickers.R
\name{get_tickers_history}
\alias{get_tickers_history}
\title{Get historical data for multiple tickers}
\usage{
get_tickers_history(
  tickers_obj,
  period = "1mo",
  interval = "1d",
  start = NULL,
  end = NULL,
  prepost = FALSE,
  auto_adjust = TRUE,
  back_adjust = TRUE,
  repair = TRUE,
  output = c("tibble", "response", "request"),
  proxy = NULL
)
}
\arguments{
\item{tickers_obj}{A tickers object created with get_tickers()}

\item{period}{The period to download data for (default "1mo").
Valid values are "1d", "5d", "1mo", "3mo", "6mo", "1y", "2y", "5y", "10y", "ytd", "max". Ignored if \code{start} and \code{end} are provided.}

\item{interval}{The interval between data points (default "1d").
Valid values are "1m", "2m", "5m", "15m", "30m", "60m", "90m", "1h", "1d", "5d", "1wk", "1mo", "3mo".}

\item{start}{Start time for query expressed as a date, datetime, or string in YYYY-MM-DD HH:MM:SS format.}

\item{end}{End time for query expressed as a date, datetime, or string in YYYY-MM-DD HH:MM:SS format.}

\item{prepost}{Include pre and post market data (default FALSE)}

\item{auto_adjust}{Adjust all OHLC automatically (default TRUE)}

\item{back_adjust}{Adjust data to reflect splits and dividends (default TRUE)}

\item{repair}{Repair missing data (default TRUE)}

\item{output}{Object to return. Can be "tibble", "response", or "request" (default "tibble")}

\item{proxy}{Optional proxy settings}
}
\value{
A list of tibbles with historical market data for each ticker
}
\description{
Retrieves historical market data from Yahoo Finance for multiple specified ticker symbols.
}
\details{
See \code{get_history} for more details on the historical market data.
}
\examples{
\dontrun{
tech_tickers <- get_tickers(c("AAPL", "MSFT", "GOOG"))
tech_history <- get_tickers_history(tech_tickers, period = "1y")
}
}
