% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{valid_modules}
\alias{valid_modules}
\title{Data file containing possible Yahoo Finance API modules}
\format{
A character vector containing 33 possible API modules with descriptions
}
\source{
Yahoo Finance API
}
\usage{
valid_modules
}
\description{
A dataset containing the possible modules that can be requested from the Yahoo Finance API.
Each module represents a specific type of financial data that can be retrieved for a ticker.
}
\details{
The modules include:
\itemize{
\item assetProfile - Summary profile and company officers
\item balanceSheetHistory - Annual balance sheet data
\item balanceSheetHistoryQuarterly - Quarterly balance sheet data
\item calendarEvents - Future earnings dates
\item cashFlowStatementHistory - Annual cash flow statement data
\item cashFlowStatementHistoryQuarterly - Quarterly cash flow statement data
\item defaultKeyStatistics - Key performance indicators (PE, enterprise value, EPS, etc.)
\item earnings - Earnings history
\item earningsHistory - Historical earnings data
\item earningsTrend - Earnings trend data
\item esgScores - Environmental, social, and governance scores
\item financialData - Financial KPIs (revenue, margins, cash flow, etc.)
\item institutionOwnership - Institutional ownership data
\item insiderHolders - Insider holdings data
\item insiderTransactions - Insider transaction data
\item and more...
}
}
\examples{
# View all possible modules
data(valid_modules)
head(valid_modules)

# Check if a specific module exists
"financialData" \%in\% valid_modules

}
\keyword{datasets}
