% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_label.R
\name{zi_label}
\alias{zi_label}
\title{Label ZIP Codes with Contextual Data}
\usage{
zi_label(.data, input_var, label_source = "UDS", source_var,
    type = "zip5", include_scf = FALSE, vintage = 2022)
}
\arguments{
\item{.data}{An "input object" that is data.frame or tibble that contains
ZIP Codes to be crosswalked.}

\item{input_var}{The column in the input data that contains five-digit ZIP
Codes. If the input is numeric, it will be transformed to character data
and leading zeros will be added.}

\item{label_source}{Required character scalar or data frame; specifies the
source of the label data. This could be either \code{'UDS'} (default) or
\code{'USPS'}, or a data frame containing a custom dictionary.}

\item{source_var}{Character scalar, required when \code{label_source} is a
data frame containing a custom dictionary; specifies the column name in
the dictionary object that contains ZIP Codes.}

\item{type}{Character scalar, required when \code{label_source} is either
\code{label_source} is \code{'UDS'} or \code{'USPS'}; one of either
\code{'zip3'} or \code{'zip5'}. The  \code{'zip3'} type is only available
from the \code{'USPS'} source, while the \code{'zip5'} type is available
from \code{'UDS'}.}

\item{include_scf}{A logical scalar required when \code{label_source = 'USPS'} and
\code{type = 'zip3'}; specifying whether to include the SCF (Sectional
Center Facility) ID in the output. The default is \code{FALSE}.}

\item{vintage}{Character or numeric scalar, required when \code{label_source}
is either \code{label_source} is \code{'UDS'} or \code{'USPS'}; specifying
the date for \code{label_source = 'USPS'} or the year of the data for
\code{label_source = 'UDS'}. The \code{zip_load_labels_list()} function
can be used to see available date values for \code{label_source = 'USPS'}.}
}
\value{
A tibble containing the original data with additional columns from the
    selected label data set appended.
}
\description{
This function appends information about the city (for five-digit
   ZIP Codes) or area (for three-digit ZIP Codes) to a data frame containing
   these values. State is returned for both types of ZIP Codes. The function
   also optionally returns data on Sectional Center Facilities (SCFs) for
   three-digit ZIP Codes.
}
\details{
Labels are approximations of the actual location of a ZIP Code. For
    five-digit ZIP Codes, the city and state may or may not correspond to
    an individuals' mailing address city (since multiple cities may be
    accepted as valid by USPS for a particular ZIP Code) or state (since ZIP
    Codes may cross state lines).

    For three-digit ZIP Codes, the area and state may or may not correspond to
    an individuals' mailing address state (since SCFs cover multiple states).
    For example, the three digit ZIP Code \code{010} covers Western Massachusetts
    in practice, but is assigned to the state of Connecticut.
}
\examples{
# create sample data
df <- data.frame(
  id = c(1:3),
  zip5 = c("63005", "63139", "63636"),
  zip3 = c("630", "631", "636")
)

# UDS crosswalk
\donttest{
  zi_label(df, input_var = zip5, label_source = "UDS", vintage = 2022)
}

# USPS crosswalk
\donttest{
  zi_label(df, input_var = zip3, label_source = "USPS", type = "zip3",
    vintage = 202408)
}

# custom dictionary
## load sample ZIP3 label data to simulate custom dictionary
mo_label <- zi_mo_usps

## label
zi_label(df, input_var = zip3, label_source = mo_label, source_var = zip3,
  type = "zip3")

}
