% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_mo_zcta3.R
\docType{data}
\name{zi_mo_zcta3}
\alias{zi_mo_zcta3}
\title{Missouri Three-digit ZCTAs, 2022}
\format{
A data frame with 31 rows and 2 variables:
\describe{
  \item{ZCTA3}{three-digit ZCTA value}
  \item{geometry}{simple features geometry}
  }
}
\source{
U.S. Census Bureau's TIGER/Line database
}
\usage{
data(zi_mo_zcta3)
}
\description{
A simple features data set containing the geometric data
    for Missouri's three-digit ZIP Code Tabulation Areas (ZCTAs) for 2022,
    derived from the U.S. Census Bureau's 2022 TIGER/Line shapefiles.
}
\details{
The data included in \code{zi_mo_zcta3} can be replicated with the
  following code: \code{zi_get_geometry(year = 2022, style = "zcta3",
  state = "MO", method = "intersect")}.
}
\examples{
utils::str(zi_mo_zcta3)
utils::head(zi_mo_zcta3)

}
\keyword{datasets}
