% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notate.R
\name{notate}
\alias{notate}
\title{Embed factor levels and value labels in values.}
\usage{
notate(x)
}
\arguments{
\item{x}{The object (either vector or \code{date.frame} of vectors), that one
desires to annotate and/or view.}
}
\value{
The processed \code{data.frame}, suitable for viewing, in particular
through the \code{View()} function.
}
\description{
This function adds level/label information as an annotation to either factors
or \code{labelled} variables. This function is called \code{notate()} rather than
\code{annotate()} to avoid conflict with \code{ggplot2::annotate()}. It is a generic that
can operate either on individual vectors or on a \code{data.frame}.

When printing \code{labelled} variables from a \code{tibble} in a console, both the
numeric value and the text label are shown, but no variable labels. When
using the \code{View()} function, only variable labels are shown but no value
labels. For factors, there is no way to view the integer levels and values at
the same time.

In order to allow the viewing of both variable and value labels at the same
time, this function converts both \code{factor} and \code{labelled} variables to
\code{character}, including both numeric levels (\code{labelled} values) and character
values (\code{labelled} labels) in the output.
}
\examples{
d <- data.frame(
  chr = letters[1:4],
  fct = factor(c("alpha", "bravo", "chrly", "delta")),
  lbl = ll_labelled(c(1, 2, 3, NA),
                    labels = c(one=1, two=2),
                    label = "A labelled vector")
)
dn <- notate(d)
dn
# View(dn)

}
