% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job.R
\name{job_info}
\alias{job_info}
\title{Get a job's information}
\usage{
job_info(zoltar_connection, job_url)
}
\arguments{
\item{zoltar_connection}{A \code{ZoltarConnection} object as returned by \code{\link[=new_connection]{new_connection()}}}

\item{job_url}{URL of a valid job in zoltar_connection}
}
\value{
A \code{list} of job information for the passed job_url. it has these names:
id, url, status, user, created_at, updated_at, failure_message, input_json, output_json
}
\description{
Gets a job's information that can be used to track the job's progress. Jobs represent long-running
asynchronous activities like uploading a file (e.g., a forecast or truth) or running a query.
}
\examples{
\dontrun{
  the_job_info <- job_info(conn, "http://example.com/api/job/2/")
}
}
