% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThesaurusManagement.R
\name{ThesaurusManagement}
\alias{ThesaurusManagement}
\alias{NewThesaurus}
\alias{AddToThesaurus}
\alias{RemoveRepeatedNames}
\alias{ThesaurusAmbiguity}
\title{Thesaurus Management}
\usage{
NewThesaurus(
  caseSensitive = FALSE,
  accentSensitive = FALSE,
  punctuationSensitive = FALSE
)

AddToThesaurus(thesaurus, newName, category)

RemoveRepeatedNames(thesaurus)

ThesaurusAmbiguity(thesaurus)
}
\arguments{
\item{caseSensitive, accentSensitive, punctuationSensitive}{Logical. They set
the case, accent, and punctuation sensitivity (\code{FALSE} by default) of
the thesaurus.}

\item{thesaurus}{A thesaurus object.}

\item{newName}{Character vector with new names to be added to the thesaurus.}

\item{category}{Character vector identifying the classes where the
new names should be included.}
}
\value{
\code{NewThesaurus} returns an empty thesaurus. This can then be
populated by \code{AddToThesaurus}.

\code{AddToThesaurus} returns the input thesaurus complemented with new
names in the categories identified. If any of the categories is not present
in the input thesaurus, new categories are added as required.

\code{RemoveRepeatedNames} returns the input thesaurus pruned of redundant
names in each category. The redundancy is evaluated in agreement with the
case and accent sensitivity of the thesaurus.

\code{ThesaurusAmbiguity} returns FALSE if no ambiguity is present. When any
ambiguity is found, it returns TRUE with an attribute \code{errmessage}
including the names present in more than one category and the
the involved categories. This is internally used by
\code{\link{ReadThesaurus}} and \code{\link{AddToThesaurus}} to generate an
error in case they attempt to read or generate an ambiguous thesaurus.
}
\description{
Functions to modify and check thesauri.
}
\examples{
## Load an example thesaurus:
thesaurus <- ReadThesaurus(system.file("extdata", "taxonThesaurus.csv",
                                       package="zoolog"))
## with categories
names(thesaurus) #  "bos taurus"  "ovis aries"  "sus domesticus"
## Add names to several categories:
thesaurusExtended <- AddToThesaurus(thesaurus,
                                    c("Kuh", "Schwein"),
                                    c("bos taurus","sus domesticus"))
## This adds the name "Kuh" to the category "bos taurus" and
## the name "Schwein" to the category "sus domesticus".

## Generate a new thesaurus and populate it with two categories
## ("red" and "blue"):
thesaurusNew <- NewThesaurus()
thesaurusNew <- AddToThesaurus(thesaurusNew,
                               c("scarlet", "vermilion", "ruby", "cherry",
                                 "carmine", "wine"),
                               "red")
thesaurusNew
thesaurusNew <- AddToThesaurus(thesaurusNew,
                                c("sky blue", "azure", "sapphire", "cerulean",
                                 "navy", "lapis lazuli", "indigo", "cyan"),
                               "blue")
thesaurusNew

## Attempt to generate an ambiguous thesaurus
try(AddToThesaurus(thesaurusNew, "scarlet", "blue"))

## Remove repeated names in the same category:
thesaurusWithRepetitions <- AddToThesaurus(thesaurusNew,
                                           c("scarlet", "ruby"), "red")
thesaurusWithRepetitions
RemoveRepeatedNames(thesaurusWithRepetitions)

}
\seealso{
\code{\link{zoologThesaurus}} for a description of the thesaurus and
thesaurus set structure,

\code{\link{ReadThesaurus}}, \code{\link{WriteThesaurus}},
\code{\link{StandardizeNomenclature}}
}
