% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sample_chat_sentiment_aws}
\alias{sample_chat_sentiment_aws}
\title{Parsed chat file in a 'Zoom' meeting with sentiment analysis using AWS}
\format{
A data frame with 10 rows of 14 variables:
\describe{
\item{batchMeetingId}{a character meeting identification variable}
\item{messageId}{an incremented numeric identifier for a marked chat message}
\item{userName}{'Zoom' display name attached to the messager}
\item{messageSeconds}{when the message was posted as the number of seconds from the start of the recording}
\item{messageTime}{timestamp for message}
\item{message}{text of the message}
\item{messageLanguage}{language code of the message}
\item{userEmail}{character email address}
\item{userId}{numeric id of each speaker}
\item{aws_sentClass}{character giving the sentiment classification of this text}
\item{aws_positive}{probability that this text is mixed emotion}
\item{aws_negative}{probability that this text is negative}
\item{aws_neutral}{probability that this text is neutral}
\item{aws_mixed}{probability that this text is positive}
}
}
\source{
\url{http://zoomgroupstats.org/}
}
\usage{
sample_chat_sentiment_aws
}
\description{
Parsed chat file in a 'Zoom' meeting with sentiment analysis using AWS
}
\keyword{datasets}
