























































#[allow(non_snake_case)]
mod R;
mod call;
mod dataframe;
mod extendr_conversion;
mod extendr_function;
mod extendr_impl;
mod extendr_module;
mod extendr_options;
mod list;
mod list_struct;
mod pairlist;
mod pairs;
mod wrappers;

use proc_macro::TokenStream;
use quote::quote;
use syn::{parse_macro_input, Item};












#[proc_macro_attribute]
pub fn extendr(attr: TokenStream, item: TokenStream) -> TokenStream {
    let mut opts = extendr_options::ExtendrOptions::default();

    let extendr_opts_parser = syn::meta::parser(|meta| opts.parse(meta));
    parse_macro_input!(attr with extendr_opts_parser);

    match parse_macro_input!(item as Item) {
        Item::Struct(str) => extendr_conversion::extendr_type_conversion(Item::Struct(str), &opts),
        Item::Enum(enm) => extendr_conversion::extendr_type_conversion(Item::Enum(enm), &opts),
        Item::Fn(func) => extendr_function::extendr_function(func, &opts),
        Item::Impl(item_impl) => match extendr_impl::extendr_impl(item_impl, &opts) {
            Ok(result) => result,
            Err(e) => e.into_compile_error().into(),
        },
        other_item => TokenStream::from(quote! {#other_item}),
    }
}






















#[proc_macro]
pub fn extendr_module(item: TokenStream) -> TokenStream {
    extendr_module::extendr_module(item)
}





#[proc_macro]
pub fn pairlist(item: TokenStream) -> TokenStream {
    pairlist::pairlist(item)
}





#[proc_macro]
pub fn list(item: TokenStream) -> TokenStream {
    list::list(item)
}









#[proc_macro]
pub fn call(item: TokenStream) -> TokenStream {
    call::call(item)
}










#[proc_macro]
#[allow(non_snake_case)]
pub fn R(item: TokenStream) -> TokenStream {
    R::R(item.into(), true).into()
}













#[proc_macro]
#[allow(non_snake_case)]
pub fn Rraw(item: TokenStream) -> TokenStream {
    R::R(item.into(), false).into()
}































#[proc_macro_derive(TryFromRobj)]
pub fn derive_try_from_robj(item: TokenStream) -> TokenStream {
    match list_struct::derive_try_from_robj(item) {
        Ok(result) => result,
        Err(e) => e.into_compile_error().into(),
    }
}








































#[proc_macro_derive(IntoRobj)]
pub fn derive_into_robj(item: TokenStream) -> TokenStream {
    match list_struct::derive_into_robj(item) {
        Ok(result) => result,
        Err(e) => e.into_compile_error().into(),
    }
}





















#[proc_macro_derive(IntoDataFrameRow)]
pub fn derive_into_dataframe(item: TokenStream) -> TokenStream {
    dataframe::derive_into_dataframe(item)
}

#[proc_macro]
pub fn impl_try_from_robj_tuples(input: TokenStream) -> TokenStream {
    let range = parse_macro_input!(input as syn::ExprTuple);
    let start = match &range.elems[0] {
        syn::Expr::Lit(syn::ExprLit {
            lit: syn::Lit::Int(lit),
            ..
        }) => lit.base10_parse::<usize>().unwrap(),
        _ => {
            return TokenStream::from(quote!(compile_error!(
                "Expected integer literal for `start`"
            )))
        }
    };
    let end = match &range.elems[1] {
        syn::Expr::Lit(syn::ExprLit {
            lit: syn::Lit::Int(lit),
            ..
        }) => lit.base10_parse::<usize>().unwrap(),
        _ => {
            return TokenStream::from(quote!(compile_error!("Expected integer literal for `end`")))
        }
    };

    TokenStream::from_iter((start..=end).map(|n| {
        let types: Vec<_> = (0..n).map(|i| quote::format_ident!("T{}", i)).collect();
        let indices = 0..n;
        let element_extraction = indices.map(|idx| {
            quote! {
                (&list.elt(#idx)?).try_into()?
            }
        });

        TokenStream::from(quote! {
            impl<#(#types),*> TryFrom<&Robj> for (#(#types,)*)
            where
                #(#types: for<'a> TryFrom<&'a Robj, Error = extendr_api::Error>),*
            {
                type Error = Error;

                fn try_from(robj: &Robj) -> extendr_api::Result<Self> {
                    let list: List = robj.try_into()?;
                    if list.len() != #n {
                        return Err(Error::ExpectedLength(#n));
                    }
                    Ok((
                        #(#element_extraction),*
                    ))
                }
            }




            impl<#(#types),*> TryFrom<Robj> for (#(#types,)*)
            where
                #(#types: for<'a> TryFrom<&'a Robj, Error = extendr_api::Error>),* {
                type Error = Error;

                fn try_from(robj: Robj) -> extendr_api::Result<Self> {
                    Self::try_from(&robj)
                }
            }

            impl<#(#types),*> TryFrom<&Robj> for Option<(#(#types,)*)>
            where
            #(#types: for<'a> TryFrom<&'a Robj, Error = extendr_api::Error>),*{
                type Error = Error;

                fn try_from(robj: &Robj) -> extendr_api::Result<Self> {
                    if robj.is_null() || robj.is_na() {
                        Ok(None)
                    } else {
                        Ok(Some(<(#(#types,)*)>::try_from(robj)?))
                    }
                }
            }

            impl<#(#types),*> TryFrom<Robj> for Option<(#(#types,)*)>
            where
            #(#types: for<'a> TryFrom<&'a Robj, Error = extendr_api::Error>),*{
                type Error = Error;

                fn try_from(robj: Robj) -> extendr_api::Result<Self> {
                    Self::try_from(&robj)
                }
            }
        })
    }))
}
