













use crate::{util_libc::last_os_error, Error};
use core::mem::MaybeUninit;

const MAX_BYTES: usize = 1024;

pub fn getrandom_inner(dest: &mut [MaybeUninit<u8>]) -> Result<(), Error> {
    for chunk in dest.chunks_mut(MAX_BYTES) {
        let ptr = chunk.as_mut_ptr() as *mut libc::c_void;
        let ret = unsafe { libc::getrandom(ptr, chunk.len(), libc::GRND_RANDOM) };

        if ret <= 0 {
            return Err(last_os_error());
        }

        if (ret as usize) != chunk.len() {
            return Err(Error::UNEXPECTED);
        }
    }
    Ok(())
}
