

/*
Refs:
- Xtensa Instruction Set Architecture (ISA) Summary for all Xtensa LX Processors
  https://www.cadence.com/content/dam/cadence-www/global/en_US/documents/tools/silicon-solutions/compute-ip/isa-summary.pdf
- Linux kernel's Xtensa atomic implementation
  https://github.com/torvalds/linux/blob/v6.13/arch/xtensa/include/asm/atomic.h
*/

use core::arch::asm;

pub(super) use core::sync::atomic;

pub(super) type State = u32;


#[inline(always)]
pub(super) fn disable() -> State {
    let ps: State;


    unsafe {



        asm!("rsil {0}, 15", out(reg) ps, options(nostack));
    }
    ps
}






#[inline(always)]
pub(super) unsafe fn restore(ps: State) {


    unsafe {


        asm!(
            "wsr.ps {0}",
            "rsync",
            in(reg) ps,
            options(nostack),
        );
    }
}
