// protected_main_1.cc -- a test case for gold

// Copyright (C) 2008-2025 Free Software Foundation, Inc.
// Written by Ian Lance Taylor <iant@google.com>.

// This file is part of gold.

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
// MA 02110-1301, USA.

#include <cassert>

// This function in the shared library will call the protected version
// of f1 in the shared library.

extern bool t1();
extern bool t2();

extern "C" int f2();
extern int (*get_f2_addr()) ();

int
main()
{
  assert(t1());
  assert(t2());
  assert(&f2 == get_f2_addr());
}
