=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::ThreeDFormat;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::Camera;
use AsposeSlidesCloud::Object::LightRig;
use AsposeSlidesCloud::Object::ShapeBevel;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#ThreeDFormat
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'ThreeDFormat',
                                  class => 'ThreeDFormat',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'bevel_bottom' => {
    	datatype => 'ShapeBevel',
    	base_name => 'BevelBottom',
    	description => 'Type of a bottom 3D bevel.             ',
    	format => '',
    	read_only => '',
    		},
    'bevel_top' => {
    	datatype => 'ShapeBevel',
    	base_name => 'BevelTop',
    	description => 'Type of a top 3D bevel.             ',
    	format => '',
    	read_only => '',
    		},
    'camera' => {
    	datatype => 'Camera',
    	base_name => 'Camera',
    	description => 'Camera',
    	format => '',
    	read_only => '',
    		},
    'contour_color' => {
    	datatype => 'string',
    	base_name => 'ContourColor',
    	description => 'Contour color',
    	format => '',
    	read_only => '',
    		},
    'contour_width' => {
    	datatype => 'double',
    	base_name => 'ContourWidth',
    	description => 'Contour width',
    	format => '',
    	read_only => '',
    		},
    'depth' => {
    	datatype => 'double',
    	base_name => 'Depth',
    	description => 'Depth',
    	format => '',
    	read_only => '',
    		},
    'extrusion_color' => {
    	datatype => 'string',
    	base_name => 'ExtrusionColor',
    	description => 'Extrusion color',
    	format => '',
    	read_only => '',
    		},
    'extrusion_height' => {
    	datatype => 'double',
    	base_name => 'ExtrusionHeight',
    	description => 'Extrusion height',
    	format => '',
    	read_only => '',
    		},
    'light_rig' => {
    	datatype => 'LightRig',
    	base_name => 'LightRig',
    	description => 'Light rig',
    	format => '',
    	read_only => '',
    		},
    'material' => {
    	datatype => 'string',
    	base_name => 'Material',
    	description => 'Material',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'bevel_bottom' => 'ShapeBevel',
    'bevel_top' => 'ShapeBevel',
    'camera' => 'Camera',
    'contour_color' => 'string',
    'contour_width' => 'double',
    'depth' => 'double',
    'extrusion_color' => 'string',
    'extrusion_height' => 'double',
    'light_rig' => 'LightRig',
    'material' => 'string'
} );

__PACKAGE__->attribute_map( {
    'bevel_bottom' => 'BevelBottom',
    'bevel_top' => 'BevelTop',
    'camera' => 'Camera',
    'contour_color' => 'ContourColor',
    'contour_width' => 'ContourWidth',
    'depth' => 'Depth',
    'extrusion_color' => 'ExtrusionColor',
    'extrusion_height' => 'ExtrusionHeight',
    'light_rig' => 'LightRig',
    'material' => 'Material'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
