use strict;
use warnings;

package App::Embra::App::Command::collate;
$App::Embra::App::Command::collate::VERSION = '0.001'; # TRIAL
# ABSTRACT: collate your site

use App::Embra::App -command;


sub abstract { 'collate your site'; }



sub execute {
    my ( $self, $opt, $arg ) = @_;
    $self->embra->collate;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::App::Command::collate - collate your site

=head1 VERSION

version 0.001

=head1 SYNOPSIS

    embra collate

=head1 DESCRIPTION

This command is a very thin layer over L<App::Embra/collate>, which does all the things required to collate your site.

=head1 example

    $ embra collate

=head1 OPTIONS

No options.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
