package Net::Amazon::EMR::Step;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

subtype 'Net::Amazon::EMR::Type::Step::ActionOnFailure' => as 'Str' => where { m/^(?:TERMINATE_JOB_FLOW | TERMINATE_CLUSTER | CANCEL_AND_WAIT | CONTINUE)$/x };

has 'ActionOnFailure' => ( is => 'ro',
                           isa => 'Net::Amazon::EMR::Type::Step::ActionOnFailure',
                           coerce => 1,
                       );

has 'Config' => ( is => 'ro', 
                  isa => 'Net::Amazon::EMR::Type::HadoopStepConfig',
                  coerce => 1,
              );

has 'HadoopJarStep' => ( is => 'ro', 
                         isa => 'Net::Amazon::EMR::Type::HadoopJarStep',
                         coerce => 1,
    );


has 'Id' => ( is => 'ro', 
                  isa => 'Str' );

has 'Name' => ( is => 'ro', 
                  isa => 'Str' );

has 'Status' => ( is => 'ro', 
                  isa => 'Net::Amazon::EMR::Type::StepStatus',
                  coerce => 1,
              );

__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::Step

=head1 DESCRIPTION

Implements the Step data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_Step.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
