package Business::EDI::CodeList::ItemTypeIdentificationCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 7143;
my $usage       = 'C';

# *    7143  Item type identification code                           [C]
# Desc: Coded identification of an item type.
# Repr: an..3

my %code_hash = (
'AA' => [ 'Product version number',
    'Number assigned by manufacturer or seller to identify the release of a product.' ],
'AB' => [ 'Assembly',
    'The item number is that of an assembly.' ],
'AC' => [ 'HIBC (Health Industry Bar Code)',
    'Article identifier used within health sector to indicate data used conforms to HIBC.' ],
'AD' => [ 'Cold roll number',
    'Number assigned to a cold roll.' ],
'AE' => [ 'Hot roll number',
    'Number assigned to a hot roll.' ],
'AF' => [ 'Slab number',
    'Number assigned to a slab, which is produced in a particular production step.' ],
'AG' => [ 'Software revision number',
    'A number assigned to indicate a revision of software.' ],
'AH' => [ 'UPC (Universal Product Code) Consumer package code (1-5-5)',
    'An 11-digit code that uniquely identifies consumer packaging of a product; does not have a check digit.' ],
'AI' => [ 'UPC (Universal Product Code) Consumer package code (1-5-5-',
    '1) A 12-digit code that uniquely identifies the consumer packaging of a product, including a check digit.' ],
'AJ' => [ 'Sample number',
    'Number assigned to a sample.' ],
'AK' => [ 'Pack number',
    'Number assigned to a pack containing a stack of items put together (e.g. cold roll sheets (steel product)).' ],
'AL' => [ 'UPC (Universal Product Code) Shipping container code (1-2-',
    "5-5) A 13-digit code that uniquely identifies the manufacturer's shipping unit, including the packaging indicator." ],
'AM' => [ 'UPC (Universal Product Code)/EAN (European article number)',
    "Shipping container code (1-2-5-5-1) A 14-digit code that uniquely identifies the manufacturer's shipping unit, including the packaging indicator and the check digit." ],
'AN' => [ 'UPC (Universal Product Code) suffix',
    'A suffix used in conjunction with a higher level UPC (Universal product code) to define packing variations for a product.' ],
'AO' => [ 'State label code',
    "A code which specifies the codification of the state's labelling requirements." ],
'AP' => [ 'Heat number',
    'Number assigned to the heat (also known as the iron charge) for the production of steel products.' ],
'AQ' => [ 'Coupon number',
    'A number identifying a coupon.' ],
'AR' => [ 'Resource number',
    'A number to identify a resource.' ],
'AS' => [ 'Work task number',
    'A number to identify a work task.' ],
'AT' => [ 'Price look up number',
    'Identification number on a product allowing a quick electronic retrieval of price information for that product.' ],
'AU' => [ 'NSN (North Atlantic Treaty Organization Stock Number)',
    'Number assigned under the NATO (North Atlantic Treaty Organization) codification system to provide the identification of an approved item of supply.' ],
'AV' => [ 'Refined product code',
    'A code specifying the product refinement designation.' ],
'AW' => [ 'Exhibit',
    'A code indicating that the product is identified by an exhibit number.' ],
'AX' => [ 'End item',
    'A number specifying an end item.' ],
'AY' => [ 'Federal supply classification',
    "A code to specify a product's Federal supply classification." ],
'AZ' => [ 'Engineering data list',
    "A code specifying the product's engineering data list." ],
'BA' => [ 'Milestone event number',
    'A number to identify a milestone event.' ],
'BB' => [ 'Lot number',
    'A number indicating the lot number of a product.' ],
'BC' => [ 'National drug code 4-4-2 format',
    'A code identifying the product in national drug format 4-4-2.' ],
'BD' => [ 'National drug code 5-3-2 format',
    'A code identifying the product in national drug format 5-3-2.' ],
'BE' => [ 'National drug code 5-4-1 format',
    'A code identifying the product in national drug format 5-4-1.' ],
'BF' => [ 'National drug code 5-4-2 format',
    'A code identifying the product in national drug format 5-4-2.' ],
'BG' => [ 'National drug code',
    'A code specifying the national drug classification.' ],
'BH' => [ 'Part number',
    'A number indicating the part.' ],
'BI' => [ 'Local Stock Number (LSN)',
    'A local number assigned to an item of stock.' ],
'BJ' => [ 'Next higher assembly number',
    'A number specifying the next higher assembly or component into which the product is being incorporated.' ],
'BK' => [ 'Data category',
    'A code specifying a category of data.' ],
'BL' => [ 'Control number',
    'To specify the control number.' ],
'BM' => [ 'Special material identification code',
    'A number to identify the special material code.' ],
'BN' => [ 'Locally assigned control number',
    'A number assigned locally for control purposes.' ],
'BO' => [ "Buyer's colour",
    'Colour assigned by buyer.' ],
'BP' => [ "Buyer's part number",
    'Reference number assigned by the buyer to identify an article.' ],
'BQ' => [ 'Variable measure product code',
    'A code assigned to identify a variable measure item.' ],
'BR' => [ 'Financial phase',
    'To specify as an item, the financial phase.' ],
'BS' => [ 'Contract breakdown',
    'To specify as an item, the contract breakdown.' ],
'BT' => [ 'Technical phase',
    'To specify as an item, the technical phase.' ],
'BU' => [ 'Dye lot number',
    'Number identifying a dye lot.' ],
'BV' => [ 'Daily statement of activities',
    'A statement listing activities of one day.' ],
'BW' => [ 'Periodical statement of activities within a bilaterally',
    'agreed time period Periodical statement listing activities within a bilaterally agreed time period.' ],
'BX' => [ 'Calendar week statement of activities',
    'A statement listing activities of a calendar week.' ],
'BY' => [ 'Calendar month statement of activities',
    'A statement listing activities of a calendar month.' ],
'BZ' => [ 'Original equipment number',
    'Original equipment number allocated to spare parts by the manufacturer.' ],
'CC' => [ 'Industry commodity code',
    'The codes given to certain commodities by an industry.' ],
'CG' => [ 'Commodity grouping',
    'Code for a group of articles with common characteristics (e.g. used for statistical purposes).' ],
'CL' => [ 'Colour number',
    'Code for the colour of an article.' ],
'CR' => [ 'Contract number',
    'Reference number identifying a contract.' ],
'CV' => [ 'Customs article number',
    'Code defined by Customs authorities to an article or a group of articles for Customs purposes.' ],
'DR' => [ 'Drawing revision number',
    'Reference number indicating that a change or revision has been applied to a drawing.' ],
'DW' => [ 'Drawing',
    'Reference number identifying a drawing of an article.' ],
'EC' => [ 'Engineering change level',
    "Reference number indicating that a change or revision has been applied to an article's specification." ],
'EF' => [ 'Material code',
    "Code defining the material's type, surface, geometric form plus various classifying characteristics." ],
'EN' => [ 'International Article Numbering Association (EAN)',
    "Number assigned to a manufacturer's product according to the International Article Numbering Association." ],
'GB' => [ "Buyer's internal product group code",
    "Product group code used within a buyer's internal systems." ],
'GN' => [ 'National product group code',
    'National product group code. Administered by a national agency.' ],
'GS' => [ 'General specification number',
    'The item number is a general specification number.' ],
'HS' => [ 'Harmonised system',
    'The item number is part of, or is generated in the context of the Harmonised Commodity Description and Coding System (Harmonised System), as developed and maintained by the World Customs Organization (WCO).' ],
'IB' => [ 'ISBN (International Standard Book Number)',
    'A unique number identifying a book.' ],
'IN' => [ "Buyer's item number",
    'The item number has been allocated by the buyer.' ],
'IS' => [ 'ISSN (International Standard Serial Number)',
    'A unique number identifying a serial publication.' ],
'IT' => [ "Buyer's style number",
    'Number given by the buyer to a specific style or form of an article, especially used for garments.' ],
'IZ' => [ "Buyer's size code",
    'Code given by the buyer to designate the size of an article in textile and shoe industry.' ],
'MA' => [ 'Machine number',
    'The item number is a machine number.' ],
'MF' => [ "Manufacturer's (producer's) article number",
    'The number given to an article by its manufacturer.' ],
'MN' => [ 'Model number',
    'Reference number assigned by the manufacturer to differentiate variations in similar products in a class or group.' ],
'MP' => [ 'Product/service identification number',
    'Reference number identifying a product or service.' ],
'NB' => [ 'Batch number',
    'The item number is a batch number.' ],
'ON' => [ 'Customer order number',
    "Reference number of a customer's order." ],
'PD' => [ 'Part number description',
    'Reference number identifying a description associated with a number ultimately used to identify an article.' ],
'PL' => [ "Purchaser's order line number",
    "Reference number identifying a line entry in a customer's order for goods or services." ],
'PO' => [ 'Purchase order number',
    "Reference number identifying a customer's order." ],
'PV' => [ 'Promotional variant number',
    'The item number is a promotional variant number.' ],
'QS' => [ "Buyer's qualifier for size",
    'The item number qualifies the size of the buyer.' ],
'RC' => [ 'Returnable container number',
    'Reference number identifying a returnable container.' ],
'RN' => [ 'Release number',
    "Reference number identifying a release from a buyer's purchase order." ],
'RU' => [ 'Run number',
    'The item number identifies the production or manufacturing run or sequence in which the item was manufactured, processed or assembled.' ],
'RY' => [ 'Record keeping of model year',
    'The item number relates to the year in which the particular model was kept.' ],
'SA' => [ "Supplier's article number",
    'Number assigned to an article by the supplier of that article.' ],
'SG' => [ 'Standard group of products (mixed assortment)',
    'The item number relates to a standard group of other items (mixed) which are grouped together as a single item for identification purposes.' ],
'SK' => [ 'SKU (Stock keeping unit)',
    'Reference number of a stock keeping unit.' ],
'SN' => [ 'Serial number',
    'Identification number of an item which distinguishes this specific item out of a number of identical items.' ],
'SRS' => [ 'RSK number',
    'Plumbing and heating.' ],
'SRT' => [ 'IFLS (Institut Francais du Libre Service) 5 digit product',
    'classification code 5 digit code for product classification managed by the Institut Francais du Libre Service.' ],
'SRU' => [ 'IFLS (Institut Francais du Libre Service) 9 digit product',
    'classification code 9 digit code for product classification managed by the Institut Francais du Libre Service.' ],
'SRV' => [ 'EAN.UCC Global Trade Item Number',
    "A unique number, up to 14-digits, assigned according to the numbering structure of the EAN.UCC system. 'EAN' stands for the 'International Article Numbering Association', and 'UCC' for the 'Uniform Code Council'." ],
'SRW' => [ 'EDIS (Energy Data Identification System)',
    'European system for identification of meter data.' ],
'SRX' => [ 'Slaughter number',
    'Unique number given by a slaughterhouse to an animal or a group of animals of the same breed.' ],
'SRY' => [ 'Official animal number',
    'Unique number given by a national authority to identify an animal individually.' ],
'SRZ' => [ 'Harmonized tariff schedule',
    'The international Harmonized Tariff Schedule (HTS) to classify the article for customs, statistical and other purposes.' ],
'SS' => [ "Supplier's supplier article number",
    "Article number referring to a sales catalogue of supplier's supplier." ],
'SSA' => [ '46 Level DOT Code',
    'A US Department of Transportation (DOT) code to identify hazardous (dangerous) goods, managed by the Customs and Border Protection (CBP) agency.' ],
'SSB' => [ 'Airline Tariff 6D',
    'A US code agreed to by the airline industry to identify hazardous (dangerous) goods, managed by the Customs and Border Protection (CBP) agency.' ],
'SSC' => [ 'Title 49 Code of Federal Regulations',
    'A US Customs and Border Protection (CBP) code used to identify hazardous (dangerous) goods.' ],
'SSD' => [ 'International Civil Aviation Administration code',
    'A US Department of Transportation/Federal Aviation Administration code used to identify hazardous (dangerous) goods, managed by the Customs and Border Protection (CBP) agency.' ],
'SSE' => [ 'Hazardous Materials ID DOT',
    'A US Department of Transportation (DOT) code used to identify hazardous (dangerous) goods, managed by the Customs and Border Protection (CBP) agency.' ],
'SSF' => [ 'Endorsement',
    'A US Customs and Border Protection (CBP) code used to identify hazardous (dangerous) goods.' ],
'SSG' => [ 'Air Force Regulation 71-4',
    'A department of Defense/Air Force code used to identify hazardous (dangerous) goods, managed by the Customs and Border Protection (CBP) agency.' ],
'SSH' => [ 'Breed',
    'The breed of the item (e.g. plant or animal).' ],
'SSI' => [ 'Chemical Abstract Service (CAS) registry number',
    'A unique numerical identifier for for chemical compounds, polymers, biological sequences, mixtures and alloys.' ],
'SSJ' => [ 'Engine model designation',
    'A name or designation to identify an engine model.' ],
'SSK' => [ 'Institutional Meat Purchase Specifications (IMPS) Number',
    'A number assigned by agricultural authorities to identify and track meat and meat products.' ],
'SSL' => [ 'Price Look-Up code (PLU)',
    'Identification number affixed to produce in stores to retrieve price information.' ],
'SSM' => [ 'International Maritime Organization (IMO) Code',
    'An International Maritime Organization (IMO) code used to identify hazardous (dangerous) goods.' ],
'SSN' => [ 'Bureau of Explosives 600-A (rail)',
    'A Department of Transportation/Federal Railroad Administration code used to identify hazardous (dangerous) goods.' ],
'SSO' => [ 'United Nations Dangerous Goods List',
    'A UN code used to classify and identify dangerous goods.' ],
'SSP' => [ 'International Code of Botanical Nomenclature (ICBN)',
    'A code established by the International Code of Botanical Nomenclature (ICBN) used to classify and identify botanical articles and commodities.' ],
'SSQ' => [ 'International Code of Zoological Nomenclature (ICZN)',
    'A code established by the International Code of Zoological Nomenclature (ICZN) used to classify and identify animals.' ],
'SSR' => [ 'International Code of Nomenclature for Cultivated Plants',
    '(ICNCP) A code established by the International Code of Nomenclature for Cultivated Plants (ICNCP) used to classify and identify animals.' ],
'SSS' => [ 'Distributors article identifier',
    'Identifier assigned to an article by the distributor of that article.' ],
'SST' => [ 'Norwegian Classification system ENVA',
    'Product classification system used in the Norwegian market.' ],
'SSU' => [ 'Supplier assigned classification',
    'Product classification assigned by the supplier.' ],
'SSV' => [ 'Mexican classification system AMECE',
    'Product classification system used in the Mexican market.' ],
'SSW' => [ 'German classification system CCG',
    'Product classification system used in the German market.' ],
'SSX' => [ 'Finnish classification system EANFIN',
    'Product classification system used in the Finnish market.' ],
'SSY' => [ 'Canadian classification system ICC',
    'Product classification system used in the Canadian market.' ],
'SSZ' => [ 'French classification system IFLS5',
    'Product classification system used in the French market.' ],
'ST' => [ 'Style number',
    'Number given to a specific style or form of an article, especially used for garments.' ],
'STA' => [ 'Dutch classification system CBL',
    'Product classification system used in the Dutch market.' ],
'STB' => [ 'Japanese classification system JICFS',
    'Product classification system used in the Japanese market.' ],
'STC' => [ 'European Union dairy subsidy eligibility classification',
    'Category of product eligible for EU subsidy (applies for certain dairy products with specific level of fat content).' ],
'STD' => [ 'GS1 Spain classification system',
    'Product classification system used in the Spanish market.' ],
'STE' => [ 'GS1 Poland classification system',
    'Product classification system used in the Polish market.' ],
'STF' => [ 'Federal Agency on Technical Regulating and Metrology of the',
    'Russian Federation A Russian government agency that serves as a national standardization body of the Russian Federation.' ],
'STG' => [ 'Efficient Consumer Response (ECR) Austria classification',
    'system Product classification system used in the Austrian market.' ],
'STH' => [ 'GS1 Italy classification system',
    'Product classification system used in the Italian market.' ],
'STI' => [ 'CPV (Common Procurement Vocabulary)',
    'Official classification system for public procurement in the European Union.' ],
'STJ' => [ 'IFDA (International Foodservice Distributors Association)',
    'International Foodservice Distributors Association (IFDA).' ],
'STK' => [ 'AHFS (American Hospital Formulary Service) pharmacologic -',
    'therapeutic classification Pharmacologic - therapeutic classification maintained by the American Hospital Formulary Service (AHFS).' ],
'STL' => [ 'ATC (Anatomical Therapeutic Chemical) classification system',
    'Anatomical Therapeutic Chemical classification system maintained by the World Health Organisation (WHO).' ],
'STM' => [ 'CLADIMED (Classification des Dispositifs Mdicaux)',
    'A five level classification system for medical decvices maintained by the CLADIMED organisation used in the French market.' ],
'STN' => [ 'CMDR (Canadian Medical Device Regulations) classification',
    'system Classification system related to the Canadian Medical Device Regulations maintained by Health Canada.' ],
'STO' => [ 'CNDM (Classificazione Nazionale dei Dispositivi Medici)',
    'A classification system for medical devices used in the Italian market.' ],
'STP' => [ 'UK DM&D (Dictionary of Medicines & Devices) standard coding',
    'scheme A classification system for medicines and devices used in the UK market.' ],
'STQ' => [ 'eCl@ss',
    'Standardized material and service classification and dictionary maintained by eClass e.V.' ],
'STR' => [ 'EDMA (European Diagnostic Manufacturers Association)',
    'Products Classification Classification for in vitro diagnostics medical devices maintained by the European Diagnostic Manufacturers Association.' ],
'STS' => [ 'EGAR (European Generic Article Register)',
    'A classification system for medical devices.' ],
'STT' => [ 'GMDN (Global Medical Devices Nomenclature)',
    'Nomenclature system for identification of medical devices officially apprroved by the European Union.' ],
'STU' => [ 'GPI (Generic Product Identifier)',
    'A drug classification system managed by Medi-Span.' ],
'STV' => [ 'HCPCS (Healthcare Common Procedure Coding System)',
    'A classification system used with US healthcare insurance programs.' ],
'STW' => [ 'ICPS (International Classification for Patient Safety)',
    'A patient safety taxonomy maintained by the World Health Organisation.' ],
'STX' => [ 'MedDRA (Medical Dictionary for Regulatory Activities)',
    'A medical dictionary maintained by the International Federation of Pharmaceutical Manufacturers and Associations (IFPMA).' ],
'STY' => [ 'Medical Columbus',
    'Medical product classification system used in the German market.' ],
'STZ' => [ 'NAPCS (North American Product Classification System)',
    'Product classification system used in the North American market.' ],
'SUA' => [ 'NHS (National Health Services) eClass',
    'Product and Service classification system used in United Kingdom market.' ],
'SUB' => [ 'US FDA (Food and Drug Administration) Product Code',
    'Classification Database US FDA Product Code Classification Database contains medical device names and associated information developed by the Center for Devices and Radiological Health (CDRH).' ],
'SUC' => [ 'SNOMED CT (Systematized Nomenclature of Medicine-Clinical',
    'Terms) A medical nomenclature system developed between the NHS and the College of American Pathologists.' ],
'SUD' => [ 'UMDNS (Universal Medical Device Nomenclature System)',
    'A standard international nomenclature and computer coding system for medical devices maintained by the Emergency Care Research Institute (ECRI).' ],
'TG' => [ 'Transport group number',
    '(8012) Additional number to form article groups for packing and/or transportation purposes.' ],
'UA' => [ "Ultimate customer's article number",
    'Number assigned by ultimate customer to identify relevant article.' ],
'UP' => [ 'UPC (Universal product code)',
    "Number assigned to a manufacturer's product by the Product Code Council." ],
'VN' => [ 'Vendor item number',
    'Reference number assigned by a vendor/seller identifying a product/service/article.' ],
'VP' => [ "Vendor's (seller's) part number",
    'Reference number assigned by a vendor/seller identifying an article.' ],
'VS' => [ "Vendor's supplemental item number",
    "The item number is a specified by the vendor as a supplemental number for the vendor's purposes." ],
'VX' => [ 'Vendor specification number',
    'The item number has been allocated by the vendor as a specification number.' ],
'ZZZ' => [ 'Mutually defined',
    'Item type identification mutually agreed between interchanging parties.' ],
);
sub get_codes { return \%code_hash; }

1;
