.TH xtexcad "1" "2000-October-01" "Contributed Software" "TeX Manual"
.SH NAME
xtexcad \- drawing utility that produces LaTeX \\picture environments
.SH SYNOPSIS
.B xtexcad
.RI [- toolkitoption "...] [-" option "...] [" file ]
.SH DESCRIPTION
The
.I xtexcad
utility is for drawing graphics which is intended to be included into a
LaTeX document. For this purpose the graphics is saved as a LaTeX
\\picture environment.
.PP
In order to produce correct input to LaTeX, the slopes of lines and the
diameters of circles are restricted to those that LaTeX supports.

.SH THE FILE MENU

The following commands are available under the
.B File
menu:

.TP 8
.B New
Erase the current graphics completely and start a new drawing.

.TP 8
.B Load
Load graphics from a file. This pops up a file selector and lets you
choose a file. See
.B FILE FORMAT
on how the input file must be structured. A file which was saved by
.I xtexcad
can be read in again.

.TP 8
.B Save
Save the graphics under the current file name, which is displayed in
the title bar of the main window. If the graphics has not been saved in
a file yet, the function is the same as
.BR "Save As" .
An already existing file is backed-up by renaming it. The suffix
.I .old
is appended to the name of the backup file. The suffix can be
changed with the resource 
.BR backupSuffix .

.TP 8
.B Save As
Save the current graphics under a new file name. This pops up a file selector
which lets you choose a file or specify a new file name. From now on,
.B Save
will save the graphics to the new file name.

.TP 8
.B Quit
Exit from
.IR xtexcad .

.SH THE EDIT MENU

The following commands are available under the
.B Edit
menu:

.TP 8
.B Copy
This creates a copy of the currently selected item.

.TP 8
.B Delete
This deletes the currently selected item.

.TP 8
.B Edit Text
If the currently selected item is a text, a framed box text or a dashed box
text, this pops up a dialog in which the text can be edited.

.TP 8
.B Refresh
This refreshes the drawing area.

.SH DRAWING GRAPHICS and the DRAW MENU

The
.B Draw
menu allows to select the drawing mode. The currently selected mode is indicated
by a check mark.
.PP
The first entry,
.BR Pick ,
switches to the pick mode. This allows that already drawn items can
be selected and modified. To select an item move the pointer over it and
press the left mouse button. Currently, an item can be selected when the
pointer is over its rectangular bounding box. Press the left mouse button
repeatedly to cycle through the possible items for the current pointer
position. (NOTE: To select a text you must carefully point at the anchor
point of the text.)
.PP
When an item is selected, it can be modified by placing the pointer over
the grips. To move the item, press the middle mouse button and drag the item
to the desired new location. To change the size or direction of an object,
press the left mouse button and drag the grip to the desired new location.
.PP
When drawing a
.B Line
or
.BR Vector ,
press the left mouse button to place the starting point of the line or vector.
Then press the left mouse button again to place the end point. This is now
the starting point of a new line. To finish the line, press the middle or
right mouse button.
.PP
For a
.B Bezier
first place the starting point, then the end point, then the curvature of the
curve using the left mouse button. Then start with the next bezier.
.PP
For the
.B Framed Box Text
and the
.B Dashed Box Text
place two opposite corners of the box. Then a popup appears where the text
can be typed in and the alignment of the text within the box and the
shadow style of the box can be selected.
After pressing
.BR Ok " or " Cancel ,
draw the next box.
.PP
For a
.B Text
simply choose the location. Then a popup appears where the text can be entered
and the alignment can be specified.
.PP
For a
.B Circle Outline
and a
.B Filled Circle
first specify the center, then the size.
.PP
For a
.B Filled Rectangle
and a
.B Rounded Rectangle
specify two opposite corners.

.SH THE OPTIONS POPUP

Pressing the
.B Options
button pops up a window containing several toggle buttons. With these, some
features can be switched on and off (these features can also be
controlled with X Resources):

.TP 8
.B Enable Grid
displays a grid when pressed. The distance between the grid points can be
specified in the text entry below in units of \\unitlength. The
initial value of this text field can be controlled with the resource
.BR initGridDistance .
Whether the grid is initially on is controlled by the resource
.BR initGrid .

.TP 8
.B Snap to Grid
When this option is enabled and the option
.B Enable Grid
is also selected, only restricted positions in the drawing area
can be selected (only the grid points). See also the resource 
.BR initGrid .

.TP 8
.BR "Unlimited Slopes" " and " "Unlimited Diameters"
When these options are switched on, unlimited slopes for lines and vectors
and unlimited diameters for discs and circles are allowed.
Note, that output files produced with these options enabled will not be
accepted by plain LaTeX. Normally, circles, discs, lines and vectors
are precisely restricted to those available with usual LaTeX fonts.
See also the resources
.BR initUnlimitedSlopes " and " initUnlimitedCircles .

.TP 8
.B Ruler
switches on a ruler along the top and left edges of the drawing area
with labels in multiples of \\unitlength.
See also the resource 
.BR initRuler .

.TP 8
.B Cross Hair
switches on a cross hair which follows the pointer.
See also the resource 
.BR initCross .

.TP 8
.B Minimum Length
When this option is enabled,
.I xtexcad
obeys that a minimum length is required for slanted lines and vectors.
The corresponding resource is 
.BR initUnlimitedLengths .

.SH THE SHIFT POPUP

When the
.B Shift
button is pressed, a window pops up with which the drawing can be shifted
in the drawing area. There are 4 buttons with arrows for the 4 directions
and a small button between them which centers the drawing.
The amount how far to shift the drawing can be specified in the text entry
field below the arrow buttons. The inital value in this field can be
controlled by the resource
.BR initOffset
where the value is understood in units of \\unitlength.

.SH THE ZOOM POPUP

When the
.B Zoom
button is pressed, a window pops up where the current zoom factor (as a
percent value) can be specified. The factor is limited to the range
25 through 400.
The inital zoom value can be controlled by the resource
.BR initZoomFactor .
The button shows the current zoom factor.
(The center button of the
.B Shift 
popup is useful to place the drawing in the middle of the drawing area
again.)

.SH OPTIONS and X RESOURCES

This program uses the X Toolkit and Athena widgets.
The class name for the application is
.BR XTeXcad .
It understands all of the core resource names and
classes and all of the standard X Toolkit command line options.
The following standard X Toolkit command line arguments are commonly used with 
.IR xtexcad :
.TP 8
.BI "\-fn " font
This option specifies the font to be used for displaying text in buttons and
menu entries as well as the text in the drawing area.
The font used in the drawing area can selectivly be chosen with the
application resource
.BR .font " (class " .Font ).
.TP 8
.BI "\-fg " color ", -bg " color
This specifies the foreground and background colors of all of
.IR xtexcad s
windows. The foreground color of the drawing area can selectivly be chosen
with the application resource
.BR .foreground " (class " .Foreground ).
.TP 8
.BI "\-geometry " geometry
This option specifies the prefered size and position of the application window.
.TP 8
.BI \-display " host" : display
This option specifies the X server to contact.

.PP
In addition, the following application specific resources can be used to
customize
.IR xtexcad :

.TP 8
.BR .initOffset ", class " .InitOffset
specifies the initial value by which the image is shifted by the buttons in the
.B Shift
popup. Default is 
.IR 10.0 .

.TP 8
.BR .initZoomFactor ", class " .InitZoomFactor
specifies the inital zoom factor. This value is restricted to the range
25 to 400). Default is 
.IR 100 .

.TP 8
.BR .initGridDistance ", class " .InitGridDistance
specifies the initial distance of the grid points. Default is 
.IR 10.0 .

.TP 8
.BR .rulerFont ", class " .Font
This resource specifies the font which will be used to draw the units on
the ruler if it is displayed.

.TP 8
.BR .defaultUnitLength ", class " .DefaultUnitLength
This specifies the default TeX dimension for the \\unitlength of the saved
picture. The value must be a floating point number, followed by one of the
two-letter units of dimension as understood by TeX (regardless of the case):
.BR pt ,
.BR cm ,
.BR mm ,
.BR pc ,
.BR in ,
.BR bp ,
.BR dd ,
.BR cc ,
.BR sp ,
.BR em 
(font-relative unit, roughly 10pt).
It is highly recommended to chose sensible multiples of 
.BR pt
as default (for example 10pt, 2pt, or 0.5em) because all units are
internally translated to 
.BR pt 
and 1pt corresponds approximately to 1 screen pixel at zoom 100 (see also the
.B BUGS 
section). Default is 
.IR 1.0pt .

.TP 8
.BR .backupSuffix ", class " .BackupSuffix
This string is appended to the name of backup files. Default is 
.IR .old .

.TP 8
.BR *filter ", class " *Filter
This resource gives the initial value for the file filter in the
file selector widget used by the 
.B Load, Save 
and 
.B Save As
commands. Default is 
.IR * .

.TP 8
.BR .initSnapGrid ", class " .InitSnapGrid
This resource specifies whether only selected points on the grid can
be chosen. Default is
.IR off .

.TP 8
.BR .initRuler ", class " .InitRuler
This resource specifies whether the ruler is initially drawn.
Default is 
.IR off .

.TP 8
.BR .initGrid ", class " .InitRuler
This resource specifies whether the grid is initially drawn.
Default is 
.IR off .

.TP 8
.BR .initCross ", class " .InitRuler
This resource specifies whether the cross is initially drawn.
Default is
.IR off .

.TP 8
.BR .initUnlimitedSlopes ", class " .InitUnlimited
This resource specifies whether lines and vectors with arbitrary slopes
can be drawn. Default is
.IR false .

.TP 8
.BR .initUnlimitedCircles ", class " .InitUnlimited
This resource specifies whether circles with arbitrary diameters
can be drawn. Default is 
.IR false .

.TP 8
.BR .initUnlimitedLengths ", class " .InitUnlimited
This resource specifies whether very short lines and vectors can be drawn.
Default is 
.IR false .

.SH FILE FORMAT

.I xtexcad
can read not only files saved by itself but also by other means, for example
hand written files. For a file to be understood by
.I xtexcad
it must contain the following: 
Optionally, a \fB\\unitlength=\fP\fITeX dimension\fP
command, a \fB\\begin{picture}\fP
phrase (without white space after \\begin) with or without the optional
argument, zero or more \fB\\put\fP, \fB\\qbezier\fP, or \fB\\bezier\fP
commands, and an \fB\\end{picture}\fP
phrase (without white space after \\end). Everything before
\fB\\begin{picture}\fP (except \fB\\unitlength\fP) and after
\fB\\end{picture}\fP is ignored.
The \fB\\qbezier\fP command can come with or without the optional argument.
Its value, however, is ignored and will not be written to the file any more
when the file is saved.

A file created by
.I xtexcad
always assigns a value to \fB\\unitlength\fP. The whole file is inside a
group (curly braces) so that this assignment is local.
For a newly created file, the value of \\unitlength will be taken from the
resource
.B defaultUnitLength
whose default is 1.0pt.
If a file is loaded in, which assigns a value to \\unitlength, this value will
be preserved. This means that if you find that the picture is too large or too
small for the LaTeX document, you can manually scale it by editing
the \\unitlength in the resulting file. If you later edit the file with
.IR xtexcad ,
it will not destroy this change, and the picture will appear scaled
accordingly in the drawing area of
.IR xtexcad ,
since 1pt corresponds to 1 screen pixel (at zoom 100).

.SH "SEE ALSO"

Leslie Lamport:
.IR "LaTeX: A Document Preparation System" ,
Goossens \fIet al.\fP:
.IR "The LaTeX companion" .

.SH BUGS

Modifying objects lacks some features like cross hair. It is also very
unfriendly with servers that do not support backingstore.
The grips should be transparent.
.PP
The shadow style is currently ignored.
.PP
Some aspects (the shadow-part of the text placement popup) may not
work when linked with X11R4 libraries because the Toggle widget changed
its behavior from R4 to R5.
.PP
The optional argument of the \fB\\qbezier\fP command is ignored and does not
get saved to the file when a picture is loaded and saved later.
.PP
Redrawing after modifying an item is worse than bad.
.PP
Internally, all units are translated to TeX points (pt), and 1
screen pixel (at zoom 100) is taken to be approximately 1pt. However,
this may result in rounding and positioning errors if \\unitlength is
not a proper multiple of 1pt.
.PP
Sometimes, especially when drawing very short lines, it is possible to
produce unsupported LaTeX-slopes of lines and vectors. Working with a
large zoom factor helps. Also, for some \\unitlengths the minimum line
length computed is too short.

.SH COPYRIGHT

Copyright 1991 by Klaus Zitzmann, 1993-1996 by Johannes Sixt.
The file selection widget is copyrighted by J.K.Wight
<J.K.Wight@newcastle.ac.uk> which itself uses code written by Byron Rakitzis
<byron@netapp.com> (the regexp package).

.SH AUTHORS
Klaus Zitzmann <zitzmann@infko.uni-koblenz.de> wrote TeXcad 1.2.
.PP
Johannes Sixt <Johannes.Sixt@telecom.at> rewrote much of that
version and produced this version of XTeXcad.
Most of the changes from 2.3 to 2.4 are due to Notker Amann
<amann@isr.uni-stuttgart.de>.
