/*
 * Based on koi2tex.c
 * Helpful suggestions to Simon Hawkin: cema@cs.umd.edu
 *
*/

#include <stdio.h>

/*
 * Translator: Cyrillic LaTeX to regular LaTeX.
 * Acts as a filter.
 *
 * After you apply this to the source file, you will need to LaTeX it.
 * The following files are used: cyrillic.sty, cyracc.def.
 * Also, the Cyrillic TeX fonts are required (see cyrillic.sty).
 *
 */

char *ltot[] = {
    " j2",       " a",  " b",     "c",   "d",    "e", " f",  " g",
    " h",        "i",  " \\u\\i ","k",   "l",    " m", "n",  " o",
    "p",        " j1", " r",      "s",   "t",    " u", " zh", " v",
    " \\cprime ","y",  "z",      " x",   " \\`e", " w", " q",  " \\cdprime ",

    " J2",       " A",  " B",      "C",   "D",    "E", " F",  " G",
    " H",        "I",  " \\u I",  "K",   "L",    " M", "N",  " O",
    "P",        " J1", " R",      "S",   "T",    " U", " Zh", " V",
    " \\Cprime ","Y",  "Z",      " X",   " \\`E", " W", " Q",  " \\Cdprime "
};

main ()
{
    int c, cyrillic;

    /*
     * Insert "cyrillic" in the documentstyle header.
     * (Assume that double "cyrillic" will not hurt.)
     *
     * The loop is ugly. However, I need it in C for portability.
     *
     */
    cyrillic = 1;
    while ( (c = getchar ()) != EOF ) {
	
	switch (cyrillic) {

	case 1:  if ( c == '\\' ) cyrillic = 2;  else cyrillic = 1; break;
	case 2:  if ( c == 'd' )  cyrillic = 3;  else cyrillic = 1; break;
	case 3:  if ( c == 'o' )  cyrillic = 4;  else cyrillic = 1; break;
	case 4:  if ( c == 'c' )  cyrillic = 5;  else cyrillic = 1; break;
	case 5:  if ( c == 'u' )  cyrillic = 6;  else cyrillic = 1; break;
	case 6:  if ( c == 'm' )  cyrillic = 7;  else cyrillic = 1; break;
	case 7:  if ( c == 'e' )  cyrillic = 8;  else cyrillic = 1; break;
	case 8:  if ( c == 'n' )  cyrillic = 9;  else cyrillic = 1; break;
	case 9:  if ( c == 't' )  cyrillic = 10; else cyrillic = 1; break;
	case 10: if ( c == 's' )  cyrillic = 11; else cyrillic = 1; break;
	case 11: if ( c == 't' )  cyrillic = 12; else cyrillic = 1; break;
	case 12: if ( c == 'y' )  cyrillic = 13; else cyrillic = 1; break;
	case 13: if ( c == 'l' )  cyrillic = 14; else cyrillic = 1; break;
	case 14: if ( c == 'e' )  cyrillic = 15; else cyrillic = 1; break;

	case 15:
	    if ( c == ' ' || c == '\n' || c == '\t' )
		break;
	    else if ( c == '[' ) {
		printf ("[cyrillic,");
		goto break_while; /* C is missing this. Too bad. */
	    }else {
		printf ("[cyrillic]%c", c );
		goto break_while; /* Like I said, too bad. */
	    }

	default:
	    break;

	} /* switch */

	if ( cyrillic == 0 && c == '\n' ) {
	    cyrillic = 1;
	}
	putchar (c);
	continue;
	
      break_while:
	break;
    } /* while */

    while ( (c = getchar ()) != EOF ) {

	if ( c >= 0x80 + '@' ) { /* Cyrillic */
	    printf (
		"{\\cyr\\cydot %s}",
		ltot [c - '@' - 0x80 ]
		);
	}else { /* not Cyrillic */
	    putchar (c);
	}

    } /* while */

} /* main */
