/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : ifeature.cc
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/

#include "ifeature.h" 
#include "script.h"
#include "stem.h"
#include "init.h"
#include "mpp.h"

FeatureList featureList;


#ifndef NO_RUNTIME
#define FEATURES_RUNTIME
#endif

#ifdef FEATURES_RUNTIME


#include "textdata.h"

#define SCRIPT_INIT "script.ini"

NESTED_IN( Feature )Type char2FeatureType( const char* s )
{
    String type( s );
    if ( type == "ACCENT" )
        return Feature::ACCENT;
//    else if ( type == "STAFF" )
//        return Feature::STAFF;
    else if ( type == "TEXT" )
        return Feature::TEXT;
    else
        return Feature::STAFF;
}

NESTED_IN( Token )Orientation char2TokenOrientation( const char* s )
{
    String orientation( s );
    if ( orientation == "UP" )
        return Token::UP;
//    else if ( orientation == "DOWN" )
//        return Token::DOWN;
    else if ( orientation == "UNDEFINED" )
        return Token::UNDEFINED;
    else
        return Token::DOWN;
}

void initFeatureList()
{
//    TextDataFile scripts( SCRIPT_INIT );

    String initName = execPrefix;
    initName += SCRIPT_INIT;
    TextDataFile scripts( initName );

    while ( scripts )
        {
        ;// cout << "<" << endl;
        TextRecord& script = scripts++;
#if 0 // take no risk // ndef COMMA_RIGHT_TO_LEFT
        featureList.put( *new Script( script++, script++, char2FeatureType( script++ ), char2TokenOrientation( script++ ) ) );
#else
        const char* name = script++;
        const char* substitute = script++;
        NESTED_IN( Feature )Type type = char2FeatureType( script++ );
        NESTED_IN( Token )Orientation orientation = char2TokenOrientation( script++ );
        featureList.put( *new Script( name, substitute, type, orientation ) );
#endif        
        ;// cout << ">" << endl;
        }

    featureList.put( *new Script( " ", "gobble", Feature::SPACE ) );
    featureList.put( *new Script( "(#)", "csh", Feature::ACCENT ) );
    featureList.put( *new Script( "xplet", "xplet", Feature::TEXT, Token::UNDEFINED, 1 ) );
   
    #include "feature.ini"
}

#else // not FEATURES_RUNTIME //

void initFeatureList()
{
    ;// monitor << "initFeatureList" << endl;
    #include "feature.ini"
    #include "scriptcc.ini"
}  

#endif // not FEATURES_RUNTIME //
