## -*-Tcl-*-
 # ###################################################################
 #  AlphaTk - the ultimate editor
 # 
 #  FILE: "alpha_dialogs.tcl"
 #                                    created: 04/11/98 {17:32:52 PM} 
 #                                last update: 1999-09-06T20:52:28Z 
 #  Author: Vince Darley
 #  E-mail: vince@santafe.edu
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501
 #     www: http://www.santafe.edu/~vince
 #  
 # Copyright (c) 1998-1999  Vince Darley
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 #  Description: 
 # 
 #  History
 # 
 #  modified by  rev reason
 #  -------- --- --- -----------
 #  04/11/98 VMD 1.0 original
 # ###################################################################
 ##

#  Dialogs  #

# alertnote message_string
#  This command will display message_string in a standard Macintosh alert box.
proc alertnote {message} {tk_messageBox -message $message}
# colorTriple [<prompt>] [<red> <green> <blue>] - Prompts user to choose 
#  color. If specified, the input RGB value is used as the initial color on 
#  the colorpicker.
proc colorTriple {{prompt ""} args} {
    if {[llength $args] == 0} {
	set init 000
    } elseif {[llength $args] == 3} {
	set init [join $args ""]
    } else {
	error "Bad args to colorTriple"
    }
    if {$prompt != ""} {
	set res [tk_chooseColor -title $prompt -initialcolor "#${init}"]
    } else {
	set res [tk_chooseColor -initialcolor "#${init}"]
    }
    regsub -all {[0-9][0-9]} [string range $res 1 end] "& " res
    return $res
}

# findFile [<path>] - open a file in a new window. An optional path parameter
#  specifies a default directory or file.
proc findFile {{default ""}} {
    if {$default == ""} { set default [file dirname [win::Current]]}
    if {[file isdirectory $default]} {
	edit [tk_getOpenFile -initialdir $default -filetypes [findFileTypes]]
    } else {
	edit [tk_getOpenFile -initialfile $default -filetypes [findFileTypes]]
    }
    
}

proc findFileTypes {} {
    global tcl_platform openAllFiles
    if {$tcl_platform(platform) == "macintosh"} {
	if {$openAllFiles} {
	    return ""
	} else {
	    return [list [list "Text files" "" "TEXT"]]
	}
    } else {
	lappend filetypes [list "All Files" "*.*"]
	global filepats
	foreach m [lsort -dictionary [array names filepats]] {
	    if {$filepats($m) != ""} {
		lappend filetypes [list "$m files" $filepats($m)]
	    }
	}
	return $filetypes
    }
}

# getChar - waits for a keystroke, returns ascii.
# This implementation is a bit complex, since I just copied it from
# the more general status::prompt procedure and made it return after
# one key.
bind KeyCapture <KeyPress>  {set alphaPriv(key) [list 1 %A %K %N]}
bind KeyCapture <KeyRelease>  {set alphaPriv(key) [list 0 %A %K %N]}

proc getChar {{representation "key"}} {
    global alphaPriv alpha::modifiers alpha::mods
    set alphaPriv(status) ""
    set oldFocus [focus]
    set oldGrab [grab current .status]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab -global .status
    catch {destroy .status.e}
    entry .status.e -textvariable alphaPriv(status)
    pack .status.e -side left
    trace variable alphaPriv(status) w status::_helper
    # have problem in that the bindings below trigger and screw us
    # Not sure why the keycapture binding prevents alphaPriv(done)
    # from being set to 1
    bind .status.e <Return> "set alphaPriv(done) 1 ; set alphaPriv(key) {}; break"
    bindtags .status.e [concat .status.e KeyCapture [bindtags .status.e]]
    focus .status.e
    set alphaPriv(mods) 0
    catch {unset alphaPriv(done)}
    while 1 {
	vwait alphaPriv(key)
	set statuscontents $alphaPriv(status)
	#echo "$alphaPriv(key)"
	if {[info exists alphaPriv(done)]} {
	    # real key press
	    if {$alphaPriv(done) == 1} {
		trace vdelete alphaPriv(status) w status::_helper
		break;
	    }
	    unset alphaPriv(done)
	} else {
	    regsub -all -- {_[LR]} [set keycode [lindex $alphaPriv(key) 2]] "" keycode
	    if {[info exists alpha::mods($keycode)]} {
		if {[lindex $alphaPriv(key) 0]} {
		    # pressed so add to list of mods
		    set alphaPriv(mods) [expr {$alphaPriv(mods) | $alpha::mods($keycode)}]
		} else {
		    # released so remove
		    set alphaPriv(mods) [expr {($alphaPriv(mods) | $alpha::mods($keycode)) ^ $alpha::mods($keycode)}]
		}
		unset alphaPriv(key)
		continue
	    } else {
		# it was a real key
		if {$representation == "anything" && [lindex $alphaPriv(key) 0]} {
		    append statuscontents $keycode
		} else {
		    unset alphaPriv(key)
		    continue
		}
		
	    }
	}
	set first ""
	set last ""
	regexp -- {^(.*)(.)$} $statuscontents "" first last
	break
	
	
    }
    catch {unset alphaPriv(done)}
    catch {unset alphaPriv(key)}
    catch {destroy .status.e}
    catch {grab release .status}
    catch {focus $oldFocus}
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    switch -- $representation {
	"key" {
	    return $last
	}
	default {
	    error "No other representations supported"
	}
    }	

}

namespace eval status {}

proc status::prompt {prompt {func ""} {add "key"}} {
    global alphaPriv alpha::modifiers alpha::mods
    set alphaPriv(status) ""
    set oldFocus [focus]
    set oldGrab [grab current .status]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    message $prompt
    catch {destroy .status.e}
    entry .status.e -textvariable alphaPriv(status)
    pack .status.e -side left
    grab .status.e
    trace variable alphaPriv(status) w status::_helper

    # have problem in that the bindings below trigger and screw us
    # Not sure why the keycapture binding prevents alphaPriv(done)
    # from being set to 1
    bind .status.e <Return> "set alphaPriv(done) 1 ; set alphaPriv(key) {}; break"
    bindtags .status.e [concat .status.e KeyCapture [bindtags .status.e]]
    focus .status.e
    set alphaPriv(mods) 0
    catch {unset alphaPriv(done)}
    while 1 {
	vwait alphaPriv(key)
	set statuscontents $alphaPriv(status)
	if {[info exists alphaPriv(done)]} {
	    # real key press
	    if {$alphaPriv(done) == 1} {
		trace vdelete alphaPriv(status) w status::_helper
		break;
	    }
	    unset alphaPriv(done)
	} else {
	    regsub -all -- {_[LR]} [set keycode [lindex $alphaPriv(key) 2]] "" keycode
	    if {[info exists alpha::mods($keycode)]} {
		if {[lindex $alphaPriv(key) 0]} {
		    # pressed so add to list of mods
		    set alphaPriv(mods) [expr {$alphaPriv(mods) | $alpha::mods($keycode)}]
		} else {
		    # released so remove
		    set alphaPriv(mods) [expr {($alphaPriv(mods) | $alpha::mods($keycode)) ^ $alpha::mods($keycode)}]
		}
		unset alphaPriv(key)
		continue
	    } else {
		# it was a real key
		if {$add == "anything" && [lindex $alphaPriv(key) 0]} {
		    append statuscontents $keycode
		} else {
		    unset alphaPriv(key)
		    continue
		}
		
	    }
	}
	set first ""
	set last ""
	regexp -- {^(.*)(.)$} $statuscontents "" first last
	switch -- $add {
	    "key" {
		if {[catch [list uplevel 1 $func [list $first $last]] res]} {
		    trace vdelete alphaPriv(status) w status::_helper
		    break;
		}
	    }
	    "modifiers" -
	    "anything" {
		if {[catch [list uplevel 1 $func [list $first $last $alphaPriv(mods)]] res]} {
		    trace vdelete alphaPriv(status) w status::_helper
		    break;
		}
	    }
	}	
	if {[info exists alphaPriv(key)]} {
	    unset alphaPriv(key)
	}
	
    }
    catch {unset alphaPriv(done)}
    catch {unset alphaPriv(key)}
    catch {destroy .status.e}
    catch {grab release .status.e}
    catch {focus $oldFocus}
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    return $alphaPriv(status)
}

# statusPrompt <prompt> [<func>] - Prompt in the status window. If 'func' 
#  is present, call this routine at each key-press with the current 
#  contents of the status line and the key, insert into statusline 
#  whatever is returned by the func. Command-v pastes the current (<80 
#  char) clipboard contents on the status line.
proc statusPrompt {prompt {func ""}} {
    global alphaPriv
    set alphaPriv(status) ""
    set oldFocus [focus]
    set oldGrab [grab current .status]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    message $prompt
    catch {destroy .status.e}
    entry .status.e -textvariable alphaPriv(status)
    pack .status.e -side left
    grab .status.e
    trace variable alphaPriv(status) w status::_helper
    bind .status.e <Return> "set alphaPriv(done) 1"
    focus .status.e

    while 1 {
	vwait alphaPriv(done)
	if {$alphaPriv(done) == 1} {
	    trace vdelete alphaPriv(status) w status::_helper
	    break;
	}
	set first ""
	set last ""
	regexp -- {^(.*)(.)$} $alphaPriv(status) "" first last
	if {$func != ""} {
	    if {[catch [list uplevel 1 $func [list $first $last]] res]} {
		trace vdelete alphaPriv(status) w status::_helper
		break;
	    }
	}
	unset alphaPriv(done)
    }
    catch {unset alphaPriv(done)}
    catch {destroy .status.e}
    catch {grab release .status.e}
    catch {focus $oldFocus}
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    return $alphaPriv(status)
}

proc status::_helper {args} {
    global alphaPriv
    if {![info exists alphaPriv(done)]} {
	set alphaPriv(done) 0
    }
    
}

# askyesno [-c] prompt
#  This command will display a Macintosh alert box with 'prompt' displayed
#  with the push buttons Yes and No. The command will return the 
#  string "yes" or "no". The '-c' flag specifies that a cancel button be 
#  used as well.
proc askyesno {text {other ""}} {
    set buttons {yes no}
    if {$other != ""} {
	if {$text == "-c"} {
	    lappend buttons "cancel"
	    set text $other
	} else {
	    error "bad args"
	}
    }
    global tcl_platform
    if {$tcl_platform(platform) == "macintosh"} {
	set i [eval [list tk_dialog .f "" $text stop 0] $buttons]
    } else {
	set i [eval [list tk_dialog .f "" $text "" 0] $buttons]
    }
    return [lindex $buttons $i]
}
# buttonAlert <prompt> [<button>] - Create a dialog w/ the specified 
#  buttons, returning the one selected.
proc buttonAlert {prompt args} {
    global tcl_platform 
    if {$tcl_platform(platform) == "macintosh"} {
	set i [eval [list tk_dialog .f "" $prompt stop 0] $args]
    } else {
	set i [eval [list tk_dialog .f "" $prompt "" 0] $args]
    }
    return [lindex $args $i]
}
# dialog [<-w width>|<-h height>|<-b title l t r b>|<-c title val l t r b>|
#			<-t text l t r b>|<-e text l t r b>|<-r text val l t r b>|
#			<-p l t r b>]+ 
#  Create and display a dialog.  '-w' and '-h' allow width and height of 
#  dialog window to be set.  '-b', '-c', '-r', '-t', '-e' and '-p' allow 
#  buttons, checkboxes, radio buttons, static text, editable text and gray 
#  outlines to be created, respectively.  All control types (except gray 
#  outlines) require specification of a title or text, together with left, 
#  top, right, and bottom coordinates.  Checkboxes and radioboxes have an 
#  additional parameter, the default value.  At least one button must be 
#  specified.  The return value is a list containing resulting values for 
#  all buttons, radioboxes, checkboxes, and editable textboxes (static text 
#  is ignored).  Buttons have value '1' if chosen, '0' otherwise.  The 
#  dialog box exits at the first button press.
#
proc dialog {d1 d1d d2 d2d args} {
    global tcl_platform alphaPriv
    set w .dl
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w ""
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    # The following command means that the dialog won't be posted if
    # [winfo parent $w] is iconified, but it's really needed;  otherwise
    # the dialog can become obscured by other windows in the application,
    # even though its grab keeps the rest of the application from being used.

    wm transient $w [winfo toplevel [winfo parent $w]]
    if {$tcl_platform(platform) == "macintosh"} {
	unsupported1 style $w dBoxProc
    }

    # extract -w, -h
    set arg($d1) $d1d
    set arg($d2) $d2d
    set _w [expr {([winfo screenwidth $w] - $arg(-w))/2}]
    if {$_w < 0} { set _w 0}
    set _h [expr {([winfo screenheight $w] - $arg(-h))/2}]
    if {$_h < 0} { set _h 0}
    wm geometry $w $arg(-w)x$arg(-h)+${_w}+${_h}

    set i 0
    set j 0
    set val 0
    set havebutton ""
    set in $w
    
    set len [llength $args]
    if {[lindex $args [expr {$len -2}]] == "-help"} {
	set help [lindex $args end]
    }
    
    while 1 {
	switch -- [set type [lindex $args $i]] {
	    "-b" {
		set label [lindex $args [expr {$i +1}]]
		button $w.d$j -text \
		  [quote::MacToReadable $label] \
		  -command "set alphaPriv(button) $val"
		# first button is the default
		if {$havebutton == ""} {
		    bind $w <Return> "
			$w.d$j configure -state active -relief sunken
			update idletasks
			after 100
			set alphaPriv(button) $val
			break
		    "
		    set havebutton $j
		}
		if {$label == "Cancel"} {
		    bind $w <Escape> "
		    $w.d$j configure -state active -relief sunken
		    update idletasks
		    after 100
		    set alphaPriv(button) $val
		    break
		    "
		}
		
		incr val
		incr i 2
	    }
	    "-c" {
		set alphaPriv(var$val) [lindex $args [expr {$i+2}]]
		checkbutton $w.d$j -text \
		  [quote::MacToReadable [lindex $args [expr {$i +1}]]] \
		  -variable alphaPriv(var$val) -anchor w 
		incr val
		incr i 3
	    }
	    "-t" {
		set label [lindex $args [expr {$i +1}]]
		label $w.d$j -text [quote::MacToReadable $label] \
		  -anchor w -wraplength [expr {$arg(-w) -20}] -justify left
		incr i 2
	    }
	    "-e" {
		set enext [lindex $args [expr {$i+1}]]
		if {$enext == "-password"} {
		    set show "\u2022"
		    incr i
		} else {
		    set show ""
		    if {$enext == "--"} {
			incr i
		    }
		}
		set eheight [expr {[lindex $args [expr {$i +5}]] - \
		  [lindex $args [expr {$i + 3}]]}]
		global defaultFont fontSize 
		if {$eheight > 20} {
		    # multi-line; use text widget
		    text $w.d$j -wrap char -bg white -relief ridge \
		      -bd 0 -highlightthickness 2 -highlightcolor black \
		      -highlightbackground black -font "$defaultFont $fontSize"
		    $w.d$j insert end [lindex $args [expr {$i +1}]]
		    set isText($val) $w.d$j
		} else {
		    if {$eheight < 3} {
			set show "\u2022"
		    }
		    set alphaPriv(var$val) [lindex $args [expr {$i +1}]]
		    entry $w.d$j -textvariable alphaPriv(var$val) \
		      -font "$defaultFont $fontSize" -show $show
		}
		incr val
		incr i 2
	    }
	    "-mt" {
		set menutitle [lindex $args [expr {$i+1}]]
		incr i
		set items [lindex $args [expr {$i +1}]]
		set curr [lindex $items 0]
		set items [lrange $items 1 end]
		if {[lsearch -exact $items $curr] == -1} {
		    set curr [lindex $items 0]
		}
		set alphaPriv(var$val) $curr
		if {![llength $items]} { 
		    if {$curr == ""} {
			label $w.d$j -text "(no options available)"
		    } else {
			label $w.d$j -text "$curr"
		    }
		} else {
		    # Alpha's option-menus auto-shrink to the size of
		    # the largest item they contain, so we cheat
		    set auto_size 1
		    eval alpha_optionMenu $w.d$j alphaPriv(var$val) $items
		    
		    # to handle '-n' options
		    if {![info exists lastvar]} {
			set lastvar var$val
			set alphaPriv(allitems) $items
			bind $w <Down> "dialog_pane_change $w 1 var$val {}"
			bind $w <Up> "dialog_pane_change $w -1 var$val {}"
		    }
		}
		incr val
		incr i 2
	    }
	    "-m" {
		set items [lindex $args [expr {$i +1}]]
		set curr [lindex $items 0]
		set items [lrange $items 1 end]
		if {[lsearch -exact $items $curr] == -1} {
		    set curr [lindex $items 0]
		}
		
		set alphaPriv(var$val) $curr
		# hack to cope with null menus
		if {![llength $items]} { 
		    if {$curr == ""} {
			label $w.d$j -text "(no options available)"
		    } else {
			label $w.d$j -text "$curr"
		    }
		} else {
		    # Alpha's option-menus auto-shrink to the size of
		    # the largest item they contain, so we cheat
		    set auto_size 1
		    eval alpha_optionMenu $w.d$j alphaPriv(var$val) $items
		    
		    # to handle '-n' options
		    if {![info exists lastvar]} {
			set lastvar var$val
			set alphaPriv(allitems) $items
			bind $w <Down> "dialog_pane_change $w 1 var$val {}"
			bind $w <Up> "dialog_pane_change $w -1 var$val {}"
		    }
		}
		incr val
		incr i 2
	    }
	    "-copyto" {
		set to [lindex $args [expr {$i +1}]]
		set copyto([expr {$j -1}]) $to
		trace variable alphaPriv(var[expr {$val -1}]) w "dialog::copyTo $to"
		incr i 2
		continue
	    }
	    "-M" {
		incr i
		continue
	    }
	    "-v" {
		incr i
		continue
	    }
	    "-T" {
		set title [lindex $args [expr {$i +1}]]
		incr i 2
		continue
	    }
	    "-p" {
		#echo "dialog option -p ignored"
		incr i 5
		continue
	    }
	    "-n" {
		set f $w.subf[join [lindex $args [expr {$i +1}]] ""]
		frame $f
		if {$in == $w} {
		    trace variable alphaPriv($lastvar) w "dialog_pane_change $w"
		    #place $f -in $w -x 0 -y 0
		}
		set in $f
		incr i 2
		continue
	    }
	    "-help" {
		# we extracted the help in advance.
		#set help [lindex $args [expr {$i +1}]]
		incr i 2
		continue
	    }
	    "-r" -
	    default {
		echo "dialog $d1 $d1d $d2 $d2d $args"
		destroy $w
		error "dialog:argument [lindex $args $i] not handled"
	    }
	    "" {
		# Usually only reached if we have a multi-page dialog which ends
		# immediately after a new page, and isn't robustly constructed.
		break
	    }
	    
	}
	foreach {l t r b} [lrange $args $i [expr {$i+3}]] {}
	if {[info exists eheight] && ($show != "")} {
	    incr b 10
	}
	if {[info exists auto_size]} {
	    place $w.d$j -in $in -x $l -y $t -height [expr {$b -$t}]
	    unset auto_size
	    if {[info exists menutitle]} {
		label $w.dm$j -text $menutitle
		set lwidth [winfo reqwidth $w.dm$j]
		place $w.dm${j} -in $in -x [expr {$l - $lwidth}] -y $t -height [expr {$b - $t}]
		unset menutitle
	    }
	} else {
	    if {$r == $l} {
		incr r [winfo reqwidth $w.d$j]
	    }
	    place $w.d$j -in $in -x $l -y $t -width [expr {$r -$l}] -height \
	      [expr {$b - $t}]
	}
	incr i 4
	if {[info exists help]} {
	    if {$type != "-t" && $type != "-p"} {
		# add the first help index
		set helpitem [lindex $help 0]
		set help [lrange $help 1 end]
		if {[string length $helpitem]} {
		    balloon::help $w.d$j $helpitem
		}
	    }
	}
	incr j
	
	# reached end?
	if {[lindex $args $i] == ""} {break}
    }
    if {$havebutton == ""} {
	destroy $w
	error "Must have a button in the dialog!"
    }
    if {$in != $w} {
	# have to place the correct item
	set pane $w.subf[join $alphaPriv($lastvar) ""]
	if {[winfo exists $pane]} {
	    place $pane -in $w -x 0 -y 0
	}
    }
    
    # 5. Create a <Destroy> binding for the window that sets the
    # button variable to -1;  this is needed in case something happens
    # that destroys the window, such as its parent window being destroyed.

    bind $w <Destroy> {set alphaPriv(button) -1}
    
    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr {[winfo screenwidth $w]/2 - $arg(-w)/2 \
	    - [winfo vrootx [winfo parent $w]]}]
    set y [expr {[winfo screenheight $w]/2 - $arg(-h)/2 \
	    - [winfo vrooty [winfo parent $w]]}]
    wm geom $w +$x+$y
    if {[info exists title]} {
	wm title $w $title
    }
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w.d$havebutton

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable alphaPriv(button)
    #parray alphaPriv
    if {[info exists lastvar]} {
	catch {trace vdelete alphaPriv($lastvar) w "dialog_pane_change $w"}
	catch {unset alphaPriv(allitems)}
    }
    catch {focus $oldFocus}
    set res {}
    for {set k 0} {$k < $val} {incr k} {
	if {[info exists isText($k)]} {
	    lappend res [$isText($k) get 1.0 "end -1c"]
	} else {
	    if {[info exists alphaPriv(var$k)]} {
		#echo "alphaPriv(var$k) = [set alphaPriv(var$k)]"
		set tmpres $alphaPriv(var$k)
		if {[info exists alphaPriv(mapalphaPriv(var$k):$tmpres)]} {
		    set actual [set alphaPriv(mapalphaPriv(var$k):$tmpres)]
		    unset alphaPriv(mapalphaPriv(var$k):$tmpres)
		    set tmpres $actual
		}
		lappend res $tmpres
		unset alphaPriv(var$k)
	    } else {
		if {$alphaPriv(button) == $k} {
		    lappend res 1
		} else {
		    lappend res 0
		}
	    }
	} 
    }
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# alphaPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    # This is a hack to make sure our variables are unset.
    # Unfortunately, despite the fact that we unset them correctly
    # above, when we destroy the window, the tk_optionMenu items
    # may be set again....
    foreach v [array names alphaPriv] {
	if {[string match "var*" $v]} { unset alphaPriv($v) }
	if {[string match "map*" $v]} { unset alphaPriv($v) }
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    update idletasks
    return $res
}

namespace eval dialog {}

proc dialog::copyTo {item var elt op} {
    global alphaPriv isText
    if {[info exists isText($item)]} {
	set w $isText($item)
	$w delete 0 end
	$w insert 0 $alphaPriv($elt)
	$w select range 0 end    
    } elseif {[info exists alphaPriv(var$item)]} {
	set alphaPriv(var$item) $alphaPriv($elt)
    } else {
	alertnote "dialog::copyTo error"
    }
}

# Following proc modified from:
# optMenu.tcl --
#
# This file defines the procedure tk_optionMenu, which creates
# an option button and its associated menu.
#
# RCS: @(#) $Id$
#
# Copyright (c) 1994 The Regents of the University of California.
# Copyright (c) 1994 Sun Microsystems, Inc.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

# tk_optionMenu --
# This procedure creates an option button named $w and an associated
# menu.  Together they provide the functionality of Motif option menus:
# they can be used to select one of many values, and the current value
# appears in the global variable varName, as well as in the text of
# the option menubutton.  The name of the menu is returned as the
# procedure's result, so that the caller can use it to change configuration
# options on the menu or otherwise manipulate it.
#
# Arguments:
# w -			The name to use for the menubutton.
# varName -		Global variable to hold the currently selected value.
# firstValue -		First of legal values for option (must be >= 1).
# args -		Any number of additional values.

proc alpha_optionMenu {w varName firstValue args} {
    global alphaPriv
    upvar #0 $varName var

    if {![info exists var]} {
	set var $firstValue
    }
    menubutton $w -textvariable $varName -indicatoron 1 -menu $w.menu \
      -relief raised -bd 2 -highlightthickness 2 -anchor c \
      -direction flush
    menu $w.menu -tearoff 0
    $w.menu add radiobutton -label $firstValue -variable $varName
    foreach i $args {
	if {[string index $i 0] == "\(" || ($i == "-")} {
	    $w.menu add separator
	} else {
	    if {[regsub {$} $i "..." modlabel]} {
		set alphaPriv(map${varName}:$modlabel) $i
	    }
	    $w.menu add radiobutton -label $modlabel -variable $varName
	}
    }
    return $w.menu
}



proc dialog_pane_change {w dmy elt op} {
    global alphaPriv
    if {$op == ""} {
	# we used a cursor key
	set idx [lsearch -exact $alphaPriv(allitems) $alphaPriv($elt)]
	set len [llength $alphaPriv(allitems)]
	while {1} {
	    # we don't wrap around (else could use: ($idx + $dmy +$len)%$len )
	    incr idx $dmy
	    if {$idx < 0 || $idx >= $len} {
		return
	    }
	    # Don't stop on separators
	    if {![regexp {^(\(|-$)} [lindex $alphaPriv(allitems) $idx]]} {
		break
	    }
	}
	set alphaPriv($elt) [lindex $alphaPriv(allitems) $idx]
	return
    }
    foreach pane [info commands $w.subf*] {
	place forget $pane
    }
    set pane $w.subf[join $alphaPriv($elt) ""]
    if {[winfo exists $pane]} {
	place $pane -in $w -x 0 -y 0
    }
}

# get_directory [-p <prompt>]
#  This command will display a standard Macintosh file dialog and request the user 
#  select a folder. The command will return the selected folder's full path name, or an 
#  error if the Cancel button was selected.
proc get_directory {{start ""} {title "Pick a directory"} args} {
    if {$start == "-p"} {
	set start [lindex $args 0]
    }
    if {[llength [info commands tk_chooseDirectory]]} {
	if {[file exists $start]} {
	    set f [tk_chooseDirectory -title $title -initialdir $start]
	} else {
	    set f [tk_chooseDirectory -title $title]
	}
	if {$f != ""} {
	    return $f
	} else {
	    error "Cancelled"
	}
    } else {
	echo "You should install 'tk 8.1' to be able to choose a directory directly."
	if {$title == "Pick a directory"} {
	    set title "Pick a file in the directory you want"
	}
	set f [tk_getOpenFile -title $title -initialdir $start]
	if {$f != ""} {
	    return [file dirname $f]
	} else {
	    error "Cancelled"
	}
    }
}

namespace eval quote {}

proc quote::MacToReadable {label} {
    regsub {} $label "..." label
    regsub {} $label "f" label
    return $label
}

# getPathName - prompt the user with an SFGetFile dialog and return 
#  complete pathname.
proc getPathName {} {
    return [tk_getOpenFile]
}
# getfile [<prompt>] [<path>]
#  This command will display an SFGetFile() and return the full path name of the 
#  selected file, or an error if CANCEL button was selected.  An optional path 
#  parameter specifies a default directory or file.
proc getfile {{title "Find file"} {where ""}} {
    return [tk_getOpenFile -title $title -initialfile $where]
}
# putfile <prompt> <original>
#  This command will display an SFPutFile() and return the full path name of the 
#  selected file, or an empty string if CANCEL button was selected. Original is the 
#  default name displayed for the user.
proc putfile {{title "Enter save file"} {where ""}} {
    return [tk_getSaveFile -title $title -initialfile $where]
}

proc gotoLine {} {
    set y 80
    set res [eval dialog -w 250 -h 110 -t [list "Goto line:"] 10 10 245 30 \
      -e [list ""] 20 50 190 70 [dialog::okcancel 10 y]]
    if {[lindex $res 1]} {
	goto "[lindex $res 0].0"
    }
}

# prompt <prompt> <default> [<name> <menu item>*] - prompt dialog to 
#  the user with a prompt string and a default value. The prompt dialog can 
#  optionally include a popup menu specified by 'name' and the succeeding 
#  strings. Selection of the popup menu items inserts the item text into the 
#  editable dialog item. 'Prompt' returns the value of the editable item. 
#  If the 'Cancel' button is selected, the tcl returns an error and your 
#  script will be stopped unless you execute the command from 'catch'.
proc prompt {prompt default {name ""} args} {
    if {$name == ""} {
	set y 12
	eval lappend dialog [dialog::text $prompt 10 y 30] \
	  [dialog::edit $default 20 y 30] [dialog::okcancel 10 y]
	set res [eval dialog -w 250 -h 110 $dialog]
	if {[lindex $res 1]} {
	    return [lindex $res 0]
	} else {
	    error "Cancelled"
	}
    } else {
	set y 12
	global alphaPriv
	# gross hack to make popup menu change the edit item
	# (allows us to use the general 'dialog' code)
	#trace variable alphaPriv(var1) w _promptProc
	eval lappend dialog [dialog::text $prompt 10 y 30] \
	  [dialog::edit $default 20 y 20] [dialog::text $name 10 y] \
	  [dialog::menu 50 y $args [lindex $args 0]] -copyto 0 \
	  [dialog::okcancel 10 y]
	set res [eval dialog -w 250 -h $y $dialog]
	#trace vdelete alphaPriv(var1) w _promptProc
	if {[lindex $res 2]} {
	    return [lindex $res 0]
	} else {
	    error "Cancelled"
	}
    }
}

# setFontsTabs - bring up font and tab dialog
proc setFontsTabs {} {
    catch {text_cmd setFontsTabs}
}

proc chooseFontTab {font size tabsize} {
    set y 12
    eval lappend dialog \
      [dialog::text "Font:" 10 y] \
      [dialog::menu 50 y [flag::options defaultFont] $font] \
      [dialog::text "Size:" 10 y] \
      [dialog::menu 50 y [flag::options fontSize] $size] \
      [dialog::text "Tabsize:" 10 y] \
      [dialog::edit $tabsize 50 y 4] \
      [dialog::okcancel 10 y]
    set res [eval dialog -w 250 -h $y $dialog]
    if {[lindex $res 3]} {
	return [lrange $res 0 2]
    } else {
	error "Cancelled"
    }
    
}


# gross hack!
if {0} {
proc _promptProc {var elt op} {
    set i 1
    while {[winfo exists .dl.d$i]} {
	if {[winfo class .dl.d$i] == "Entry"} {
	    break
	}
	incr i
    }
    set j 1
    while {[winfo exists .dl.d$j]} {
	if {[winfo class .dl.d$j] == "Button"} {
	    break
	}
	incr j
    }
    # We check if the 'ok' button exists, and only insert our
    # value then.  Otherwise we'd override the default item
    # above when we create the option menu.
    if {[winfo exists .dl.d$j]} {
	global alphaPriv
	.dl.d$i delete 0 end
	.dl.d$i insert 0 $alphaPriv(var1)
    }
    .dl.d$i select range 0 end    
}
}

# getline <prompt> <default>
#  This command will display a Macintosh alert box with prompt displayed, a 
#  text edit field with default initially in the field, and with the push 
#  buttons OK, Cancel.. The command will return the text entered into the 
#  text edit field by the user, or an empty string if the user selected the 
#  Cancel button. 
proc getline {{prompt "Prompt"} {default ""}} {
    set y 80
    set res [eval dialog -w 200 -h 110 -t [list $prompt] 10 10 190 30 \
	    -e [list $default] 20 50 190 70 [dialog::okcancel 10 y]]
    if {[lindex $res 1]} {
	return [lindex $res 0]
    } else {
	return ""
    }
}

proc dialog::uplist {w} {
    if {[$w curselection] == ""} {
	$w selection set end
    } else {
	set last [lindex [$w curselection] 0]
	$w selection clear $last
	if {$last > 0} {incr last -1}
	#$w selection clear active
	$w selection set $last
    }
    $w see [lindex [$w curselection] 0]
}

proc dialog::downlist {w} {
    if {[$w curselection] == ""} {
	$w selection set 0
    } else {
	set last [lindex [$w curselection] 0]
	$w selection clear $last
	if {$last < [expr {[$w size] -1}]} {incr last}
	#$w selection clear active
	$w selection set $last
    }
    $w see [lindex [$w curselection] 0]
}

# listpick [-p <prompt>] [-l] [-L <def list>] <list>
#  This command will display a dialog with the list displayed in a List Manager 
#  list. If the user presses the Cancel button, an empty string is returned. If 
#  the user selects the Open button, or double clicks an item in the list, that 
#  item will be returned. If '-l' is specified, than the return is a list of 
#  items.
proc listpick {args} {
    global tcl_platform alphaPriv
    set w .dl
    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w ""
    wm iconname $w Dialog
    wm protocol $w WM_DELETE_WINDOW { }

    # The following command means that the dialog won't be posted if
    # [winfo parent $w] is iconified, but it's really needed;  otherwise
    # the dialog can become obscured by other windows in the application,
    # even though its grab keeps the rest of the application from being used.

    wm transient $w [winfo toplevel [winfo parent $w]]
    if {$tcl_platform(platform) == "macintosh"} {
	unsupported1 style $w dBoxProc
    }

    getOpts {-p -L}
    if {![info exists opts(-p)]} {
	set opts(-p) "Please pick one:"
    }
    
    label $w.msg -wraplength 4i -justify left \
      -text $opts(-p)
    pack $w.msg -side top
    
    frame $w.buttons
    pack $w.buttons -side bottom -fill x -pady 2m
    button $w.buttons.ok -text Ok -command "set alphaPriv(button) 1"
    bind $w <Return> "
    $w.buttons.ok configure -state active -relief sunken
    update idletasks
    after 100
    set alphaPriv(button) 1
    "
    
    button $w.buttons.cancel -text Cancel -command "set alphaPriv(button) 0"
    bind $w <Escape> "
    $w.buttons.cancel configure -state active -relief sunken
    update idletasks
    after 100
    set alphaPriv(button) 0
    "
    pack $w.buttons.ok $w.buttons.cancel -side left -expand 1
    
    frame $w.frame -borderwidth .5c
    pack $w.frame -side top -expand yes -fill y
    
    scrollbar $w.frame.scroll -command "$w.frame.list yview"
    if {[info exists opts(-l)]} {
	set selectmode "extended"
    } else {
	set selectmode "browse"
    }
    listbox $w.frame.list -yscroll "$w.frame.scroll set" \
      -setgrid 1 -height 12 -selectmode $selectmode
    
    pack $w.frame.scroll -side right -fill y
    pack $w.frame.list -side left -expand 1 -fill both

    bind $w.frame.list <Double-Button-1> {set alphaPriv(button) 1}
    bind $w <Down> "dialog::downlist $w.frame.list"
    bind $w <Up> "dialog::uplist $w.frame.list"
    bind $w <Next> "$w.frame.list yview scroll 1 pages"
    bind $w <Prior> "$w.frame.list yview scroll -1 pages"
    
    # args is a list of a list
    eval $w.frame.list insert 0 [lindex $args 0]
    if {[info exists opts(-L)]} {
	if {[info exists opts(-l)]} {
	    foreach itm $opts(-L) {
		set idx [lsearch -exact [lindex $args 0] $tm]
		if {$idx >= 0} { 
		    $w.frame.list selection set $idx
		}
	    }
	} else {
	    set idx [lsearch -exact [lindex $args 0] $opts(-L)]
	    if {$idx >= 0} { 
		$w.frame.list selection set $idx
	    }
	}
    }
    
    bind $w <Destroy> {set alphaPriv(button) -1}

    # 6. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr {[winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]}]
    set y [expr {[winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]}]
    wm geom $w +$x+$y
    update
    wm deiconify $w

    # 7. Set a grab and claim the focus too.

    set oldFocus [focus]
    set oldGrab [grab current $w]
    if {$oldGrab != ""} {
	set grabStatus [grab status $oldGrab]
    }
    grab $w
    focus $w.buttons.ok

    # 8. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.  Restore the focus
    # before deleting the window, since otherwise the window manager
    # may take the focus away so we can't redirect it.  Finally,
    # restore any grab that was in effect.

    tkwait variable alphaPriv(button)
    
    if {[info exists opts(-l)]} {
	set res [list]
	foreach itm [$w.frame.list curselection] {
	    lappend res [$w.frame.list get $itm]
	}
    } else {
	if {[$w.frame.list curselection] != ""} {
	    set res [$w.frame.list get [$w.frame.list curselection]]
	} else {
	    set res ""
	}
    }
    
    catch {focus $oldFocus}
    catch {
	# It's possible that the window has already been destroyed,
	# hence this "catch".  Delete the Destroy handler so that
	# alphaPriv(button) doesn't get reset by it.

	bind $w <Destroy> {}
	destroy $w
    }
    if {$oldGrab != ""} {
	if {$grabStatus == "global"} {
	    grab -global $oldGrab
	} else {
	    grab $oldGrab
	}
    }
    if {$alphaPriv(button) == 1} {
	return $res
    } else {
	error "Cancelled!"
    }
}
    
# message <string> - prints 'string' on the status line.
proc message {t} {
    .status.text configure -text [::msgcat::mc [quote::MacToReadable $t]]
    update idletasks
}
