## -*-Tcl-*- (install) (nowrap)
 # ###################################################################
 #	Vince's	Additions -	an extension package for Alpha
 # 
 #	FILE: "cMode.tcl"
 #					created: 19/4/96 {4:53:38 pm}	
 #				 last update: 06/01/1999 {14:03:08 PM}	
 #	Author:	Vince Darley
 #	E-mail:	<vince@santafe.edu>
 #	  mail:	317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #	   www:	<http://www.santafe.edu/~vince/>
 #	
 # ###################################################################
 ##

alpha::mode C 1.2.4 dummyC { *.r } \
  {electricReturn electricBraces electricSemicolon}
alpha::mode C++ 1.2.4 dummyC++ \
  {*.H *.c *.h *.cc *.cp *.cpp *.CPP *.C *.pch *.pch++ *.icc *.exp *.c++} \
  {electricReturn electricBraces electricSemicolon}

# not really sure this is required any more
# the CW menu registers are proc to call cw IDE.
hook::register saveHook modified "C" "C++"

proc dummyC {} {}
proc dummyC++ {} {}

newPref f elecColon {1} C
newPref v leftFillColumn {3} C
newPref v prefixString {//} C
newPref f elecElse {1} C
newPref f wordWrap {0} C
newPref v funcExpr {^[^ \t\(#\r/@].*\(.*\)$} C
newPref v parseExpr {\b([_:\w]+)\s*\(} C
newPref v wordBreak {[_\w]+} C
newPref v wordBreakPreface {[^_\w]} C
newPref f autoMark 0 C
newPref v stringColor green C
newPref v commentColor red C
newPref v funcColor yellow C
newPref v keywordColor blue C
newPref v CWCompSig CWIE C
newPref v CWDbgSig MWDB C
newPref v SymCompSig KAHL C
newPref v SymDbgSig {LSD} C
newPref f includeMenu {1} C
newPref f launchIDEifRequired {1} C
newPref v sourceSuffices { .c } C
newPref v headerSuffices { .h } C
newPref v indentComments "code 0" C
newPref v indentMacros "fixed 0" C
newPref v IDE 0 C "" [list "CodeWarrior" "Symantec" "none"] index
newPref f useFasterButWorseIndentation 0 C
set C::commentRegexp	{/\*(([^*]/)|[^*]|\r)*\*/}
set cPreRegexp		{^\#[\t ]*[a-z]*}
set cKeyWords {
    void break register short enum extern int for if while struct static 
    long continue switch case char unsigned double float return else 
    default goto do pascal Boolean typedef volatile union auto sizeof 
    size_t
}
if {[info exists Cwords]} {set cKeyWords [concat $cKeyWords $Cwords]}
regModeKeywords -e {//} -b {/*} {*/} -c $CmodeVars(commentColor) \
  -f $CmodeVars(funcColor) -k $CmodeVars(keywordColor) \
  -s $CmodeVars(stringColor) -m {#} C $cKeyWords

#================================================================================

newPref f elecColon {1} C++
newPref v leftFillColumn {3} C++
newPref v prefixString {//} C++
newPref v wordBreak {[\w_]+} C++
newPref v wordBreakPreface {[^_\w]} C++
newPref f elecElse {1} C++
newPref f wordWrap {0} C++
newPref v funcExpr {^([^ \t\(#[\r\n]/@].*[ \t]+)?\*?([A-Za-z0-9~_]+(<[^>]*>)?::[-A-Za-z0-9~_+= <>\|\*/]+|[A-Za-z0-9~_]+)[ \t\r\n]*\(} C++
newPref v parseExpr {\b([_:\w]+)\s*\(} C++
newPref f autoMark 0 C++
newPref v stringColor green C++
newPref v commentColor red C++
newPref v keywordColor blue C++
newPref v funcColor yellow C++
newPref v CWCompSig CWIE C++
newPref v CWDbgSig MWDB C++
newPref v SymCompSig KAHL C++
newPref v SymDbgSig {LSD} C++
newPref f includeMenu {1} C++
newPref f launchIDEifRequired {1} C++
newPref v sourceSuffices { .cc .cp .cpp .c .icc .C } C++
newPref v headerSuffices { .h .hh } C++
# These three are pairs:
newPref v indentComments "code 0" C++ "" indentationTypes varitem
newPref v indentC++Comments "code 0" C++ "" indentationTypes varitem
newPref v indentMacros "fixed 0" C++ "" indentationTypes varitem
newPref v IDE 0 C++ "" [list "CodeWarrior" "Symantec" "none"] index
newPref f useFasterButWorseIndentation 0 C++
newPref folder universalHeadersFolder "" C++

proc C++::openUniversalHeader {} {
    global universalHeadersFolder tabSize
    set filename [prompt::statusLineComplete "Open which header" \
      [list file::completeFromDir $universalHeadersFolder] -nocache \
      -tryuppercase]
    set old $tabSize
    set tabSize 4
    file::openQuietly [file join $universalHeadersFolder $filename]
    set tabSize $old
}

Bind 'q' <o> C++::openUniversalHeader C++

set C++::commentRegexp	{/\*(([^*]/)|[^*]|\r)*\*/}

set {c++KeyWords} {
    new delete explicit class friend protected private public template try 
    catch throw operator const mutable virtual asm inline this and and_eq 
    bitand bitor compl not or or_eq xor xor_eq not_eq wchar_t bool true 
    false bool inline mutable static_cast dynamic_cast reinterpret_cast 
    typeid using namespace inherited
}
if {[info exists {C++words}]} {
    set {c++KeyWords} [concat ${c++KeyWords} ${C++words} $cKeyWords]
} else {
    set {c++KeyWords} [concat ${c++KeyWords} $cKeyWords]
}

regModeKeywords -e {//} -b {/*} {*/} -c [set C++modeVars(commentColor)] \
  -f [set C++modeVars(funcColor)] -k [set C++modeVars(keywordColor)] \
  -s [set C++modeVars(stringColor)] -m {#} {C++} ${c++KeyWords}
unset cKeyWords
unset {c++KeyWords}

proc C++::DblClick {from to shift option control} {	
    if {[regexp {#include.*("|<)(.*)("|>)} [getText \
      [lineStart [getPos]] [nextLineStart [getPos]]] "" "" inc]} {
	return [file::tryAndOpen $inc]
    }
    
    select $from $to
    set text [getSelect]
    
    global tagFile
    set lines [grep "^$text'" $tagFile]
    if {[regexp {'(.*)'(.*[^\t])(\t)+} $lines "" one two]} {
	file::openQuietly $one
	set inds [search -s -f 1 -r 0 "$two" [minPos]]
	display [lindex $inds 0]
	eval select $inds
    } else {
	app::launchFore DanR
	AEBuild {'DanR'} DanR {REF } "----" "$text"
    }
}

proc C++::parseFuncs {} {
    global mode sortFuncsMenu funcExpr parseExpr
    
    set pos [minPos]
    set m {}
    while {[set res [search -s -f 1 -r 1 -i 0 -n $funcExpr $pos]] != ""} {
	if {[regexp -- $parseExpr [eval getText $res] "" word]} {
	    lappend m [list $word [lindex $res 0]]
	}
	set pos [lindex $res 1]
    }
    if {$sortFuncsMenu} {
	regsub -all "\[\{\}\]" [lsort -ignore $m] "" m
    } else {
	regsub -all "\[\{\}\]" $m "" m
    }	
    set files ""
    foreach f [getIncludeFiles] {
	lappend files $f -1
    }
    return [concat $files [list "(-" 0] $m]
}

# for C mode

proc C::DblClick {args} { eval C++::DblClick $args }

proc C::parseFuncs {} {
    return [C++::parseFuncs]
}


#############################################################################
#																			#
# Stuff above this point has only minor modifications from the original	    #
# "cMode.tcl", stuff below is largely or totally new.			    #
#																			#
#############################################################################

#  File marking  #

## 
 # -------------------------------------------------------------------------
 #	 
 # "C++::MarkFile" --
 #	
 #	Improved version which handles templates, operators	etc.
 #	Makes use of the new mark menu in Alpha	6.5 which can handle
 #	more weird characters.  Handles most 'operator =+-*...' functions
 #  for C++
 #  
 #  Better marking of templates recently added.
 # -------------------------------------------------------------------------
 ##
proc C++::MarkFile {} {
    if {[file extension [win::Current]] == ".exp"} { return }
    set pos [minPos]
    set markExpr "^(\[A-Za-z0-9~_\]+\[ \t\n\r\]*\\(|(\[^ \t\(#\n\r/@\*\].*\[ \t\]+\\*?)?(\[A-Za-z0-9~_\]+(<\[^>\]*>)?(::)?\[-A-Za-z0-9~_+= <>\|\\*/\]+|\[A-Za-z0-9~_\]+)\[ \n\t\r\]*\\()\[^(\]"
    while {![catch {search -s -f 1 -r 1 -m 0 -i 0 "$markExpr" $pos} res]} {
	if {[catch {search -s -f 0 -r 1 -m 0 -l [lindex $res 0] -i 0 \
	  {[ *][a-zA-Z]} [set pos [pos::math [lindex $res 1] + 1]]} start]} {
	    set start [lindex $res 0]
	    if {[regexp "^\[A-Za-z0-9~_\]+\[ \t\r\n\]*\\(" \
	      [getText $start [nextLineStart $start]] thistext]} {
		# nothing
	    } else {
		continue
	    }
	    
	} else {
	    set start [lindex $start 0]
	    set thistext [getText $start $pos]
	}
	#regexp doesn't like carriage returns or tabs
	#if the open paren was the last character on the line the selected text 
	#included the last carriage return as well
	#trim this off now that it is changed into a space
	regsub -all "\[\r\n\t\]" [string trimright $thistext] " " thistext
	if {[regexp "(\[A-Za-z0-9~_\]+(<\[^>\]*>)?(::)?\[-A-Za-z0-9~_+= <>\|\*/\]+|\[A-Za-z0-9~_\]+)\[ \t\]*\\(" $thistext dummy word]} {
	    if { [string first "::" $word] != -1 } {
		regsub {(<\w+>)?::} $word " " it
		set l [lindex $it 0]
		if { $l == [lindex $it 1] } {
		    set word "Construct '$l'"
		} elseif { "~$l" == [lindex $it 1] } {
		    set word "Destruct '$l'"
		}
	    }
	    set inds($word) [lineStart [pos::math $start - 1]]
	}
    }
    if {[info exists inds]} {
	foreach f [lsort -ignore [array names inds]] {
	    set next [nextLineStart $inds($f)]
	    set it $f
	    if {[string length $it] > 57} { set it "[string range $it 0 53]..." }
	    setNamedMark "${it}" "$inds($f)" $next $next
	}
    }
}

proc C::MarkFile {} { C++::MarkFile }


#  Indentation routines  #

proc C::indentLine {} {C++::indentLine}

 ## 
  # -------------------------------------------------------------------------
  #	 
  #	"C++indentLine" --
  #	
  #	 More sophisticated	version	of Pete's.	Handles	things like	'(...)'
  #	 expressions split over	multiple lines,	if/elseif/else both	with and
  #	 without curly braces, multiple	line stream	manipulation with '<<'
  #	 or	'>>', C and C++ style comments, ...  Assumes indentation is '4'
  #   but any tab-size may be used.
  #	 
  #	 Current bugs: multi-line ',' separated lists are poorly indented.
  #
  #  Problems:
  #   matchIt's limit doesn't seem to work, so if there is no match and we're
  #   in a large file, we wait up to seconds sometimes.  Alpha bug.
  #		   
  #	 Currently checking whether we're in a /*...*/ comment is quite
  #   time consuming.  It would be nice if Alpha supplied a hook to do
  #   this for us.
  #   
  #	Results:
  #	 Indents the current line correctly	;-)	for	C, C++ coding
  #	 
  # --Version--Author------------------Changes-------------------------------  
  #	  1.0	  Pete Keleher			  original
  #    2.0     <vince@santafe.edu> updated as described above.
  #    2.1     <vince@santafe.edu> faster, better, uses positions not strings
  #    2.2     <vince@santafe.edu> uses 'correctIndentation' sub proc
  # -------------------------------------------------------------------------
  ##
proc C++::indentLine {} {
    global gotoEol
    set gotoEol 0
    
    # preliminaries
    set beg [lineStart [getPos]]
    # are we in a C comment /*...*/ if so indent specially and return
    # we really need to work out how to put this in 'correctIndentation'
    if {![catch {C_inCComment $beg} comment]} {
	set fChar [search -s -f 1 -r 1 "\[^ \t\r\n\]" $beg]
	if { [lookAt [lindex $fChar 0]] == "*" } {
	    return [eval C_indentCommentLine [list $beg] $comment]
	}
    }
    set text [getText $beg [nextLineStart $beg]]
    if {[regexp "^\[ \t\]*" $text white]} {
	set len [string length $white]
	set rest [string range $text $len end]
    } else {
	set white ""
	set rest ""
	set len 0
    }
    # get indentation level	
    set lwhite [text::indentOf [C++::correctIndentation [getPos] [string trim $rest]]]
    if {$white != $lwhite} {
	replaceText $beg [pos::math $beg + $len] $lwhite
    }
    if {$gotoEol} {
	goto [pos::math [nextLineStart $beg] - 1]
    } else {
	goto [pos::math $beg + [string length $lwhite]] 
    }
    
}
proc C::correctIndentation {args} {eval C++::correctIndentation $args}
## 
 # -------------------------------------------------------------------------
 # 
 # "C++::correctIndentation" --
 # 
 #  Known bugs:
 #  
 #  Lines which contain a URL with :// embedded tend to be considered
 #  a ':' followed by a comment, and are indented as if they were
 #  part of a 'case://comment' statement which is wrong.
 # -------------------------------------------------------------------------
 ##
proc C++::correctIndentation {pos {nextword ""}} {
    global gotoEol
    # preliminaries
    set beg [lineStart $pos]
    set nextCh [string range $nextword 0 3]
    set nextC [string index $nextCh 0]
    set nextP [string range $nextCh 0 1]
    # check for forced indentation of C, C++ comments and '#' macros
    set ind "code 0"
    switch -- $nextC {
	"\#" {
	    global indentMacros
	    set ignore_trailers ""
	    set ind $indentMacros
	}
	"/" {
	    global indentComments indentC++Comments
	    set ignore_trailers ""
	    if {$nextP == "/*"} {set ind $indentComments}
	    if {$nextP == "//"} {set ind ${indentC++Comments}}
	}
    }
    if {[lindex $ind 0] == "fixed" } {
	# force indentation to given level
	return [lindex $ind 1]
    }
    
    # (1) first we get the indent of the last line:
    # this may involve looking back a fair way
    set lst [C_prevCodeIndent [pos::math $beg - 1]]
    
    if {[pos::compare [set pstart [lindex $lst 0]] == [minPos]]} {
	return 0
    }
    set lwhite [posX [pos::math [lindex $lst 1] - 1]]	
    # have we just finished an if-elseif-else with no '{}'?
    if {$nextCh == "else"} {set iselse 1} else { set iselse 0}
    if {![C_isLineNBI $pstart]} {
	incr lwhite [C_recurseNoBraceIndent $pstart 0 $iselse]
    }
    if { [set multi [C_isLineMulti $pstart]] != "-1" } {
	set lwhite $multi
    }
    
    # (2) now we indent this line accordingly
    
    set pbeg [prevLineStart $beg]
    set backpos [nextLineStart [lindex $lst 0]]
    # is there a comment at the end of the line? if so scan back to the character we want
    if {![catch {search -s -f 0 -r 1 -l $pbeg "//\[^\r\n\]*\[\n\r\]" $backpos} compos]} {
	set compos [lindex $compos 0]
	if {[pos::compare $compos > $pbeg]} {
	    set backpos [pos::math $compos + 1]
	}	
    }
    global indentationAmount
    if {[pos::compare [set backpos [pos::math $backpos - 2]] > [minPos]]} {
	set lst [search -s -f 0 -r 1 -m 0 "\[^ \t\r\n\]" $backpos]
	switch -- [lookAt [lindex $lst 0]] {
	    "\{" {
		incr lwhite $indentationAmount
	    } 
	    ":" {
		# expression is better for odd indentationAmounts
		incr lwhite [expr {$indentationAmount - $indentationAmount/2}]
	    } 
	    "\)" {
		# see if we're in a if-elseif-else with no '{}' and indent
		if {[C_isLineNBI $pstart]} {
		    incr lwhite $indentationAmount
		}
	    }
	    "e" {
		if { [getText [pos::math [lindex $lst 0] - 3] \
		  [pos::math [lindex $lst 0] + 1]] == "else" } {
		    if {[C_isLineNBI $pstart]} {
			incr lwhite $indentationAmount
		    }
		}
		
	    }
	}
    }
    
    switch -- $nextC {
	"\}" {
	    incr lwhite [expr -$indentationAmount]
	}
	"<" -
	">" {			
	    # indent for '<<' and '>>' in multi-line C++ stream manipulation
	    if {$nextP == "<<" || $nextP == ">>"} {
		set strm [search -s -f 1 -r 1 "^\[^${nextC}\]+${nextP}" $pbeg]
		set lwhite [posX [pos::math [lindex $strm 1] - 2]]
		set gotoEol 1
	    }
	}
    }
    # Check if we're in a multi-line '(.....)' if so align to start
    global useFasterButWorseIndentation
    if {!$useFasterButWorseIndentation && ![catch {matchIt ")" $beg 200} paren]} {
	set lwhite [posX [pos::math $paren + 1]]
	set gotoEol 1
    }

    if {[regexp "^(case\[ \t\].*|\[a-zA-Z\]+):(\[^:\]|\$)" $nextword] && $lwhite > 3 \
      && ![info exists ignore_trailers]} {
	incr lwhite [expr -$indentationAmount/2]
    }
    # get indentation level	
    return [incr lwhite [lindex $ind 1]]
}

## 
 # -------------------------------------------------------------------------
 # 
 # "C++::electricLeft" --
 # 
 #  For those who like to place left braces after 'for', 'else' etc. on 
 #  their own line, this will ensure the left brace is correctly placed.
 # -------------------------------------------------------------------------
 ##
proc C++::electricLeft {} {
    if {[string trim [getText [lineStart [getPos]] [getPos]]] == ""} {
	if {[C_isLineNBI [prevLineStart [getPos]]]} {
	    set p [lineStart [getPos]]
	    insertText "\{\r"
	    goto $p
	    shiftLeft
	    goto [nextLineStart $p]
	    bind::IndentLine
	    return
	}
    }
    ::electricLeft
}

proc C::electricLeft {} {C++::electricLeft}

## 
 # -------------------------------------------------------------------------
 #	 
 # "recurseNoBraceIndent" --
 #	
 # Scans back until we no longer have a 'no brace indent'.  A 'no brace
 # indent' is a 'for', 'if' etc which didn't use '{ ...  }'
 # -------------------------------------------------------------------------
 ##
proc C_recurseNoBraceIndent {pos offset {iselse 0}} {
    set pos [prevLineStart $pos]
    if {[C_isLineNBI $pos]} {
	global indentationAmount
	if {$iselse} {
	    set p [text::firstNonWsPos $pos]
	    set t [getText $p [pos::math $p + 10]]
	    if {[regexp  "(else\[ \t\]+)?if.*" $t]} {
		return [expr {$offset -$indentationAmount}]
	    }
	}
	return [C_recurseNoBraceIndent $pos [incr offset [expr -$indentationAmount]] $iselse]
    }
    return $offset
    
}

## 
 # -------------------------------------------------------------------------
 #	 
 # "isLineNBI" --
 #	
 #  Tests if the given line is a 'no brace indent'.  'pos' is the beginning
 #  of the line in question, else this proc will fail.
 # -------------------------------------------------------------------------
 ##
set C_recNBI "^\[ \t\]*((\}?\[ \t\]*(if|else\[ \t\]+if)|for)\[ \t\]*\\(.*\\)|\}?\[ \t\]*else)\[ \t\]*(//\[^\r\n\]*)?\[ \t\r\n\]*"
proc C_isLineNBI {pos} {
    global C_recNBI
    if {![catch {search -s -f 1 -r 1 -l [nextLineStart [nextLineStart $pos]] $C_recNBI $pos} ifelse] } {
	if {[pos::compare $pos == [lindex $ifelse 0]]} {
	    if {[pos::compare [lindex $ifelse 1] == [maxPos]] || ([lookAt [lindex $ifelse 1]] != "\{")} {
		return 1 
	    }
	}
    }
    return 0
}

# use 'catch' to call this proc: error = no, otherwise returns st,end pos
proc C_inCComment {pos} {
    set cS [search -s -f 0 -r 0 -l [pos::math $pos - 1000] "/*" $pos]
    set cE [search -s -f 1 -r 0 -l [pos::math $pos + 1000] "*/" [lindex $cS 1]]
    if {[pos::compare $pos >= [lindex $cE 1]] } {
	error "No"
    } else {
	return [list [lindex $cS 0] [lindex $cE 1]]
    }
}

# look for '<<' and '(...)' multi lines.
proc C_isLineMulti {pos} {
    # look for multi-line '(...)'
    if { ![catch {search -s -f 0 -r 1 -l $pos {\).*$} [nextLineStart $pos]} paren] \
      && [pos::compare [nextLineStart $pos] == [pos::math [lindex $paren 1] + 1 ]] } {
	if {[catch {matchIt "\)" [pos::math [lindex $paren 0] - 1] 200} realStart]} {
	    return -1
	}
	if {[pos::compare [lineStart $realStart] != [lineStart [lindex $paren 0]]] } {
	    set lst [search -s -f 0 -r 1 -i 0 "^\[ \t\]*\[^ \t\r\n\]" $realStart]
	    return [posX [pos::math [lindex $lst 1] - 1]]
	}
    }
    # look for multi-line '<<' or '>>'
    set p $pos
    while {![catch {search -s -f 1 -r 1 -l [nextLineStart $p] "^\[ \t\]*(<<|>>)" $p} strm] } {
	set p [prevLineStart $p]
    }
    if { $p != $pos } {
	set lst [search -s -f 1 -r 1 -i 0 "^\[ \t\]*\[^ \t\r\n\]" $p]
	return [posX [pos::math [lindex $lst 1] - 1]]
    }
    
    return -1
    
}

## 
 # -------------------------------------------------------------------------
 #   
 # "C_indentCommentLine" --
 #  
 #  Indents a line within a multi-line /* ... */ comment correctly.
 # -------------------------------------------------------------------------
 ##
proc C_indentCommentLine {beg cS cE} {
    set lwhite [text::minSpaceForm [getText [lineStart $cS] $cS]]
    if {[pos::compare $beg != [lineStart [lindex $cE 0]]] \
      || [text::firstNonWs [pos::math $beg - 1]] == "*" } {
	append lwhite " "	
    }
    
    set text [getText $beg [nextLineStart $beg]]
    regexp "^\[ \t\]*" $text white
    set len [string length $white]
    if {$white != $lwhite} {
	replaceText $beg [pos::math $beg + $len] $lwhite
    }
    goto [pos::math $beg + [expr {[string length $lwhite] +1}]]
}


## 
 # -------------------------------------------------------------------------
 #   
 # "C_prevCodeIndent" --
 #  
 #  Find the indent of the previous line
 #  -  If it's the start of the file, return 0 0 (special case)
 #  else
 #  -  if it's a C++ comment, keep looking backwards (so you can offset
 #     C++ comments if you so desire)
 #  -  if it's a C comment, get the indentation of the '/*' not some
 #     intermediate point.
 # -------------------------------------------------------------------------
 ##
proc C_prevCodeIndent {pos} { 
    while {1} {
	if {[pos::compare $pos == [minPos]] \
	  || ([catch {search -s -m 0 -f 0 -r 1 -i 0 "^\[ \t\]*\[^ \t\r\n\]" $pos} p]) \
	  || $p == "[minPos] [minPos]" } {
	    return [list [minPos] [pos::math [minPos] + 1]]
	} else {
	    set pp [doubleLookAt [pos::math [lindex $p 1] - 1]]
	    if { $pp == "//" } {
		set pos [pos::math [lindex $p 0] - 1]
	    } elseif { [string index $pp 0] == "#" } {
		global indentMacros
		if {$indentMacros == "code 0"} {
		    break
		}
		set pos [pos::math [lindex $p 0] - 1]
	    } elseif { $pp == "*/" } {
		set pos [lindex [search -s -f 0 -r 0 "/*" \
		  [pos::math [lindex $p 0] - 1]] 0]
	    } elseif { ![catch {set comment [C_inCComment [lindex $p 0]]} ] } {
		set pos [pos::math [lineStart [lindex $comment 0]] - 1]
		#return [text::indentation [lindex $comment 0]] (old style)
	    } else {
		break
	    }
	}
    }
    return $p
}


#  Electric routines  #

proc C::carriageReturn {} {C++::carriageReturn}
proc C::OptionTitlebar {} {C++::OptionTitlebar}
proc C::OptionTitlebarSelect {item} {C++::OptionTitlebarSelect $item}

## 
 # -------------------------------------------------------------------------
 #	 
 # "C++::carriageReturn" --
 #	
 #	Called by the general routine 'carriageReturn'.	We know	no selection 
 #	exists, and we are not inside a block comment.
 # -------------------------------------------------------------------------
 ##
proc C++::carriageReturn {} {
    if {[lookAt [pos::math [getPos] - 1]] == ":"} {
	if { [lookAt [getPos]] == "\r" } {
	    bind::IndentLine
	    endOfLine
	    insertText "\r"
	} else {
	    set pos [getPos]
	    endOfLine
	    set t [getText $pos [getPos]]
	    replaceText $pos [getPos] ""
	    bind::IndentLine
	    endOfLine
	    insertText "\r"
	    insertText $t
	}
    } else {
	insertText "\r"
    }
    catch {bind::IndentLine}
}

proc C++::OptionTitlebar {} {
    if {![catch {C++::tryIDEget} ret] && ![regexp {\(No} $ret] } { return $ret }
    # else just scan through, provided the scan will function
    set cid [scancontext create]
    set lines {}
    scanmatch $cid {#.*include.*(<|")(.*)(>|")}  {lappend lines $matchInfo(submatch1)}
    set fid [open [win::Current] "r"]
    scanfile $cid $fid
    close $fid
    scancontext delete $cid
    return [lsort -ignore $lines]
}

proc C++::OptionTitlebarSelect {fname} {
    C++::tryIDEedit $fname
}

proc C++::tryIDEget {} {
    global IDE
    switch -- $IDE {
	1 {thinkGetIncludeFiles}
	0 {cw::getIncludeFiles}
	2 {error "No IDE at all!"}
    }
}

proc C++::tryIDEedit {fname} {
    global IDE
    switch -- $IDE {
	1 {thinkEditIncludeFile $fname}
	0 {cw::editIncludeFile $fname}
	2 {error "No IDE at all!"}
    }
}

