#  
# "gnuplotMode.tcl"  
#                                    created: 26/4/97 {7:59:36 pm} 
#                                last update: 23/5/98 {8:25:15 pm} 
#  Author: Jeff Schindall
#  E-mail: <mailto:schindall@nrl.navy.mil>
#    mail: Naval Research Laboratory 
#          Acoustics Division --- Code 7120
#          4555 Overlook Ave SW
#          Washington, DC, 20375 USA ]
#    
# gnuplotMode.tcl, Version 1.83       For  gnuplot 3.6
#
# This is a set of TCL proc's that allow the shareware Macintosh 
# text editor Alpha to serve as a front end for GNUPLOT for 
# Macintosh version 3.6. This script requires Alpha 7.0 or later.
#
# Just use 'shift-ctrl-g' to launch a gnuplot console
# 
# (Note: Vince updated this file for use with Alpha 7.1b10)
#############################################################################
#
# Autoload procedures
#
#
alpha::mode GPLT 1.9b2 dummyGPLT {*.gp *.gnu *.gnp *.gplt *.GP *.GNU *.GNP *.GPLT }  \
  GnuplotMenu {
    addMenu GnuplotMenu "415"
    set modeCreator(GPLT) GPLT
    set modeCreator(GPSE) GPLT
    # Set GLOBAL mode binding to bring up gnuplot Console
    Bind 'g' <sz> GP_Console
    Bind 'n' <sc> GP_NewWindow
}

########################################################################
#
#  This mode was written by Jeff Schindall.  Some code was pinched from 
#  other TCL files distributed with Alpha and matlab.tcl.
#   
#  Comments, suggestions, and bug reports should be sent to Jeff at
#     mailto:schindall@nrl.navy.mil
#
#  You should be able to find the most recent current version of this
#  gnuplotMode.tcl and the server app script at 
#      
#      ftp://ftp.ee.gatech.edu/pub/mac/gnuplot
#
#   and the most recent bleeding edge version at 
#
#      ftp://wave1m.nrl.navy.mil/pub/gnuplotMode.tcl.gz
#
#######################################################################
#																		
#	 Version History:												
#																		
#		 1.6	12/23/96												   
#		 -----------------------------------------------
#         Floating palatte now very usefull.  User can run a script
#         by selecting a script menu item, or edit the script by
#         selecting the script menu item with the option key held down
#
#		 1.5.9b	12/10/96												   
#		 -----------------------------------------------
#         repaired broken scripts menu
#         added a "edit scripts" menu----eventually, this one
#         will go away, but the functionality will be retained
#
#		 1.5.9	12/05/96												   
#		 -----------------------------------------------
#         repaired broken pwd display
#
#		 1.5.8	12/05/96												   
#		 -----------------------------------------------
#         plot '-' now works
#         pause in demo-mode works better
#         added option to rebuild scripts menu
#
#		 1.5.7	11/13/96												   
#		 -----------------------------------------------
#         Check OUTP event for "Sorry, " string
#         so that help for unknown item will be sent to console
#         rather than a new output terminal page
#
#		 1.5.6	11/07/96												   
#		 -----------------------------------------------
#		  Fixed a few floating menu buggers
#
#		 1.5.5	11/06/96												   
#		 -----------------------------------------------
#		  Added a "Scripts" menu which auto loads any script
#         in gnuplots "Scripts" folder (or subfolder)
#         Made terminal output window creation faster
#																		
#		 1.5.4	11/05/96												   
#		 -----------------------------------------------
#		  Added terminal output windows for PS/TeX/MIF/etc.
#																		
#		 1.5.3	11/02/96												   
#		 -----------------------------------------------
#		  See 1.5.2
#																		
#		 1.5.2	11/02/96												   
#		 -----------------------------------------------
#		  Attempt to fix ome context switching weirdness
#																		
#		 1.5.1	10/23/96												   
#		 -----------------------------------------------
#		  Added some more apple event and floating palatte 
#           options.
#
#		 1.5	10/22/96												   
#		 -----------------------------------------------
#		  Slight bug fixes
#
#		 1.5b3	07/18/96												   
#		 -----------------------------------------------
#		  Now works with Alpha 6.1 and higher.
#         Added Floating menu...
#
#		 1.5b2	07/16/96												   
#		 -----------------------------------------------
#		  Now works with Alpha 6.1 and higher.
#
#		 1.5b1	07/02/96												   
#		 -----------------------------------------------
#		  Modify code so that it is compliant with the new
#            mode conventions Pete added to 6.2 (see changes file).
#         This script should still work for Alpha pre 6.2!
#		  Nifty self-installer!
#		  																
#		  																
#		 1.4.4	04/26/96												   
#		 -----------------------------------------------
#		  Modify trap for broken eventhandler on 68k		         
#		  	so that pause works correctly and so that		
#		  	gnuplot can bring itself to the front			
#		  																
#		  																
#		 1.4.3	04/24/96												  
#		 -----------------------------------------------
#		  Add trap for broken eventhandler on 68k			         
#		  																
#		 1.4.2	04/17/96												
#		 -----------------------------------------------
#		  Let alpha do bookkeeping on globals				         
#		  																
#		 1.4.1	04/15/96												   	
#		 -----------------------------------------------
#		  Repaired broken quit and switchto menu options         
#		  																
#		  																
#		 1.4.0	04/14/96												   	
#		 -----------------------------------------------
#		  GPLT mode preferences accessable from                  
#            config:currentmode:flags... menu			
#		  Keyword coloring now works and is auto-sourced
#		    whenever GPTLPrefs.tcl is closed					      
#		  Reorganized and added to gnuplot menu			
#		  Reorganized all mode specifice procedures and 
#		     variable names										
#		  																
#		  																
#		 1.3.9	04/10/96												   	
#		 -----------------------------------------------
#		  Keyword coloring editable from gnuplot pref menu.		
#		  gnuplot pref menu re-arranged							      
#		  this package should display the path		               
#			 on the message bar										      
#		  																
#		  																
#		 1.3.8	03/13/96												   	
#		 -----------------------------------------------
#		  Re-arranged some code.  								
#			 																      
#		  																
#		 1.3.7	03/13/96												   	
#		 -----------------------------------------------
#		  Added support for cwd display on message bar	
#			 																      
#		  																
#		 1.3.6	02/26/96												   	
#		 -----------------------------------------------
#		  Added graph button preference and repaired		
#        my broken closeHook procedure                         
#		  																
#		 1.3.5	02/01/96												   	
#		 -----------------------------------------------
#		  Some minor fixes to console routines				
#		  																
#																		
#		 1.3.4	02/01/96												   	
#		 -----------------------------------------------
#       Added "iconic" graph window which switches to	         
#		  	 the gnuplot application							
#		  Added a "gnuplot prefs" submenu					
#																		
#		 1.3.3	12/20/95												   	
#		 -----------------------------------------------
#       Added Live History window  							         
#		  Added a function sub-menu							
#			 															
#																		
#		 1.3.2	12/15/95												   	
#		 -----------------------------------------------
#       History dump Really working this time.......           
#		  Included a kludge eventHander: GPIC EXEC		
#			 for Dave (temporary)								
#																		
#		 1.3.1	12/14/95												   	
#		 -----------------------------------------------
#		  Consolidated console and script editor modes.	
#		  Supports server once again.   						
#       History dump working.......                            
#																		
#																		
#		 1.3	12/09/95												   		
#		 -----------------------------------------------
#		  Should work with gnuplot app and              
#		  Fixed an "unknown" bug---thanks Vince			
#		  Files with gnuplot creator open in gnuplot mode
#		  Added several eventHandler's to work with the          
#         gnuplot's new personality module                     
#       NOTE:  No longer supports the gnuplot server app,      
#              but I might add it back in later...             
#																		
#		 1.2.5	8/29/95											
#		 -----------------------------------------------
#		   File type as well as creator settings in place
#																		
#																		
#		 1.2.4	8/28/95											
#		 -----------------------------------------------
#			I honestly don't recall								
#																		
#		 1.2.3	8/27/95											
#		 -----------------------------------------------
#		   Fixed a few prompt related items.				
#			I need to clean up the code a bit				
#			especially in the console output routines		
#																		
#		 1.2.2	8/23/95											
#		 -----------------------------------------------
#		   Repaired help/prompting/etc which broke in	
#				1.2.1													
#			DoSelection works for multiple lines			
#																		
#																		
#		 1.2.1	8/23/95											
#		 -----------------------------------------------
#		   Now works with unthreaded 68k systems					   
#																		
#																		
#		 1.2	8/23/95												
#		 -----------------------------------------------
#		   Deal w/"pause -1"	 properly								   
#			cmd-dbl-click now works for all prompts		 
#			Cleaned up set output creator						
#			  															
#																		
#		 1.1	8/22/95												
#		 -----------------------------------------------
#		   Set output creators from gnuplot menu			
#			Quit Working properly once again					
#			Added ERRP eventHandler for those w/o the             
#          Thread Manager										
#																		
#		 1.0	8/21/95  (these release numbers are backwards)		
#		 -----------------------------------------------
#		   First working release	 							
#																		
#	============= Below were really beta's ==================== 
#																		
#		 1.0.6	8/17/95											
#		 -----------------------------------------------
#		   Cleaned up several procs							
#			Quit now works properly								
#																		
#																		
#		 1.0.5	8/16/95											
#		 -----------------------------------------------
#			 replaced 'dosc' w/AEBuild							
#			 added eventHandler  (thanks Dave)                    
#			 dumped "clean" window since Pete will			
#				add this functionality to "new" in 6.0.2	
#																		
#																		
#		 1.0.4	8/12/95											
#		 -----------------------------------------------
#			 new modeVar to keep console "clean" 			
#																		
#																		
#		 1.0.3	8/12/95											
#		 -----------------------------------------------
#			 Fixed bugs in closing console window			
#			 Added wristwatch cursor while waiting for gnuplot		
#																		
#		 1.0.2	8/11/95											
#		 -----------------------------------------------
#         When console window is closed the gnuplot	
#			  app is quit and user is prompted to save	
#          the Alpha/gnuplot history						
#																		
#         Command-Dbl-Click anywhere between gnuplot 	
#			  prompts to select gnuplot output.  Nice		
#          if you send term output to the console.		
#																		
#		 1.0.1	8/8/95											
#		 -----------------------------------------------
#		    Handles multiplot mode								
#			 set output file CREATOR modeVar	(not yet)	
#			 															
#																		
#		 1.0	8/7/95												
#		 -----------------------------------------------
#		    Now works with 3.6 (but not with 3.5)			
#			 															
#	=======================================================		
#			 															
#		 0.4	8/3/95												
#		 -----------------------------------------------
#	       user specified colorizing through check pop-up       
#			 menu in GNUc console.  You must quit alpha and       
#			 restart to see the effects.  Also, you must          
#         make sure that keywords and colors don't overlap.    # 
#                                                              
#																		
#		 0.3	8/3/95												
#		 -----------------------------------------------
#			 Console position remembered between sessions
#																		
#		 	 Enabled command history to be dumped to a window		
#              													
#																		
#		 0.2	8/2/95												
#		 -----------------------------------------------
#			 Added a	Switch to gnuplot	menu option			
#																		
#			 Added Console modeVar	                   		     	
#																		
#         Added run in background modeVar            			   
#																		
#			 Command History mostly working in console.	
#																		
#			 Cleaned	things up a	bit.							
#																		
#																		
#		 0.1	8/1/95												
#		 -----------------------------------------------
#		     converted matlab.tcl to gnuplot.tcl			
#																		
#																		
###############################################################
 


proc dummyGPLT  {} {}
proc GnuplotMenu {} {}
hook::register mode::init GP_GraphButton GPLT
hook::register mode::editPrefsFile GP_editCurrentModePrefs GPLT
hook::register dialog::modifyModeFlags GP_modifyModeFlags GPLT		
hook::register closeHook GP_CloseHook GPLT
hook::register deactivateHook GP_DeactivateHook GPLT
hook::register activateHook GP_ActivateHook GPLT

newPref v prefixString {# } GPLT
newPref v wordBreak {[a-zA-Z0-9_]+} GPLT
newPref f wordWrap {0} GPLT
newPref v wordBreakPreface {[^a-zA-Z0-9_]} GPLT
newPref v tabSize {3} GPLT
newPref v prefixString {# } GPLT
newPref f NevrSavHist {0} GPLT
newPref f LiveHist {1} GPLT
newPref f GraphButton {1} GPLT
newPref f EventHandler {1} GPLT
newPref v bracesColor blue GPLT
newPref v bracesColor blue GPLT
newPref v stringColor green GPLT
newPref v commentColor red GPLT
set gpTermCt 0

###BGK
   # (DO NOT ERASE Previous line)
   # 
   # NOTE:  Some coloring is controlled via 
   #        Config:current mode:flags... menu
   #

      ### BLUE words ###

set gpBlueWords { 
	console  set show plot splot \\
	autoscale      binary         boxxyerrorbars bugs
	call           cd             clear          co-ordinates
	comments             environment    exit
	expressions    fit                       if
	introduction   line-editing   load           pause
	plot           print          pwd            quit
	replot         reread         reset          save
	seeking-assistance set            shell          show
	splot          startup        style          substitution
	test           update         userdefined    xyerrorbars
	xerrorbars yerrorbars
	"Copyright(C) 1986 - 1997" "Copyright(C) 1986 - 1998"
} 



      ### RED words ###

set gpRedWords { 
	topics available: Subtopics available  
	server macintosh Press return for more: Help topic: 
	Subtopic of {G N U P L O T} {(pre 3.6)}  3.5 3.6 
	version for 68k ppc Power Macintosh patchlevel 
	last modified first second
} 


     ### GREEN WORDS ###

set gpGreenWords {  
	ranges         smooth         data-file      datafile          
	parametric     locale         nosquare       errorbars
	gnuplot        gnuplot>       term           square         
	angles         arrow          autoscale      bar
	bmargin        border         boxwidth       clabel
	clip           cntrparam      contour        data
	dgrid3d        dummy          encoding       format
	function       grid           hidden3d       isosamples
	key            keytitle       label          lmargin
	logscale       mapping        margin         missing
	multiplot      mx2tics        mxtics         my2tics
	mytics         mztics         noarrow        noautoscale
	noborder       noclabel       noclip         nodgrid3d
	nokey          nolabel        nologscale     nomultiplot
	nomx2tics      nomxtics       nomy2tics      nomytics
	nomztics       noparametric   nopolar        nosurface
	nox2dtics      nox2mtics      nox2tics       nox2zeroaxis
	noxdtics       noxmtics       noxtics        noxzeroaxis
	noy2dtics      noy2mtics      noy2tics       noy2zeroaxis
	noydtics       noymtics       noytics        noyzeroaxis
	nozdtics       nozeroaxis     nozmtics       noztics
	offsets        origin         output         parametric
	pointsize      polar          punctuation    rmargin
	rrange         samples        size           specify
	style          surface        syntax         terminal
	tics           ticscale       ticslevel      time
	timefmt        title          tmargin        trange
	urange         view           vrange         x2dtics
	x2label        x2mtics        x2range        x2tics
	x2zeroaxis     xdata          xdtics         xlabel
	xmtics         xrange         xtics          xzeroaxis
	y2dtics        y2label        y2mtics        y2range
	y2tics         y2zeroaxis     ydtics         ylabel
	ymtics         yrange         ytics          yzeroaxis
	zdtics         zero           zeroaxis       zlabel
	zmtics         zrange         ztics
	threaded  
} 



    ### MAGENTA WORDS ###

set gpMageWords  { 
	with lines using  points  multiplot> mac gx eps enh
	info-gnuplot dartmouth edu bug-gnuplot { \@ }
	Send comments and requests for help to
	Send bugs, suggestions and mods to
} 
                   


    ### CYAN WORDS ###

set gpCyanWords  {   post mac     macintosh      texdraw
	aifm           atari          dumb           enhpost
	epson          epson180       epson60        fig
	gpic           hpljii         imagen         iris4d
	latex          linux          mf             mif
	mtos           nec-cp6        pbm            pcl5
	postscript     pslatex        regis          starc
	table          tandy60        tgif           uniplex
	vdi            windows        unknown        pstricks
	png            dxf            cgm            gif
	emtex          pstex          eepic          tpic
	pstricks       texdraw
	Thomas Williams, Colin Kelley and many others 
	Russell Lang, Dave Kotz, John Campbell. Gershon Elber
} 

#
# Color keywords for GPLT mode
#
regModeKeywords  -i "\}" -i "\{"  -i ">" -i "<" -i ")" -i "("  -i "/" -i "\\"  \
    -i "\]" -i "\[" -i "\$" -i "\'" -i "\`" -i ">" -i "<" -i "^" -i "_" \
    -I $GPLTmodeVars(bracesColor) \
	 -e {#} -c $GPLTmodeVars(commentColor) \
    -s $GPLTmodeVars(stringColor)  \
    -k red GPLT $gpRedWords
regModeKeywords -a -k blue GPLT $gpBlueWords
regModeKeywords -a -k green GPLT $gpGreenWords
regModeKeywords -a -k magenta GPLT $gpMageWords
regModeKeywords -a -k cyan GPLT $gpCyanWords

#  (DO NOT ERASE NEXT TWO LINES)
###EGK



#define saved globals
ensureset GnuplotSig 				 {GPLT}  
ensureset gp_CREA 				 {ALFA}  
ensureset gp_TYPE 				 {TEXT}  
ensureset gp_CreatorList [list] 
ensureset gp_TypeList [list] 
ensureset gp_CreatorNames [list] 
ensureset gp_GEOM [list]
ensureset gp_HistGEOM [list ]
ensureset headerSuffices {$GPLTmodeSuffixes}
ensureset sourceSuffices {$GPLTmodeSuffixes}

if {[llength $gp_CreatorList] == 0 \
 || [llength $gp_CreatorList] != [llength $gp_CreatorNames] \
 || [llength $gp_CreatorList] != [llength $gp_TypeList]} {
	set gp_CreatorList [list ALFA GPLT]
	set gp_TypeList [list  TEXT TEXT]
	set gp_CreatorNames [list  alpha gnuplot]
	set gp_CREA {ALFA} 
	set gp_TYPE {TEXT}
}

#remove unused, previously saved globals
if { [info exists GPLTmodeVars(FSIG)]}  { 
    removeArrDef  GPLTmodeVars FSIG
    unset GPLTmodeVars(FSIG)
} 
if { [info exists GPLTmodeVars(CREA)]}  { 
    removeArrDef  GPLTmodeVars  CREA
    unset GPLTmodeVars(CREA)
} 
if { [info exists GPLTmodeVars(TYPE)]}  { 
    removeArrDef  GPLTmodeVars TYPE
    unset GPLTmodeVars(TYPE)
} 


#############################################################################
#
#  global variables
#

set gp_CommandHist [list]
set gp_CommandNum 0

set gp_Prompt       "gnuplot> "
set gp_MultiPrompt  "multiplot> "
set gp_ContPrompt   "> "
set gp_HelpPrompt   ": "

set gp_Prompts [list $gp_Prompt $gp_ContPrompt $gp_MultiPrompt ]

set gp_Console  "  gnuplot  "
set gp_Hist     "  history  "
set gp_Graph	 "  graph  "
set gp_sl [list]

#############################################################################
#
#  Bind some keys
#

# Editing .gnu files

Bind '\r' <z>  GP_DoLine             "GPLT"

# Command Window

Bind '\r'      GP_CarriageReturn     "GPLT"
Bind up        GP_PrevCommand        "GPLT"
Bind down      GP_NextCommand        "GPLT"
Bind '1'  <c>  GP_Console            "GPLT"
Bind '2'  <c>  GP_Activate           "GPLT"
Bind '3'  <c>  GP_DumpHistory        "GPLT"
Bind 'f'  <sc>  GP_SaveAndExecute    "GPLT"


# Repeat menu keys for command window

set gp_Launched {0}




#############################################################################
#
#  gnuplot Menu stuff
#

Menu -n	$GnuplotMenu -p GnuplotMenuItem	{						 
    "/1console"													 
    "/2graph"													 
    "/3history"													 
    "(-"	
    "setWorkingFolder..."
    "/P<UchoosePlotFile..."
    "/L<Uload..."										 
    {Menu -n "saveSettings" -p GnuplotMenuItem  {
	"/S<Uall"		 		 
	"(-"
	"setCmds" 
	"functions"		 
	"variables"	
    }}
    "(-"																 																 
    "/N<UnewScriptWin"												 
    "/F<UsaveAndExecute"										 
    "(-"	
    {Menu  -s -m -n mathFunctions -p GnuplotMenuItem  {
	{Menu  -s -m -n Trigonometric -p GnuplotMenuItem  {
	    "cos"
	    "tan"
	    "sin"
	}}
	{Menu  -s -m -n InverseTrig -p GnuplotMenuItem  {
	    "acos"
	    "asin"
	    "atan"	 	
	}}
	{Menu  -s -m -n Hyperbolic -p GnuplotMenuItem  {
	    "cosh"
	    "sinh"
	    "tanh"
	}}
	{Menu  -s -m -n special -p GnuplotMenuItem  {
	    "erf"            
	    "erfc"           
	    "inverf"                                  
	    "(-"
	    "gamma"                                       
	    "igamma"                        
	    "lgamma"                                      
	    "(-"
	    "ibeta"                                        
	}}
	{Menu  -s -m -n bessel -p GnuplotMenuItem  {
	    "besj0"
	    "besj1"
	    "besy0"
	    "besy1"	 	
	}}
	"(-"
	"abs"  
	"arg"               
	"sgn"     
	"sqrt"
	"(-"
	"exp"
	"log"
	"log10"                                  
	"(-"
	"ceil"           
	"floor" 
	"rand"
	"norm"
	"invnorm"
	"(-"
	"real" 
	"imag"
	"int"
    }}
    "(-"	
    "/M<UdoSelection"											 
    "doLine"														 
    "(-"
    {Menu -n gnuplotOptions -p GnuplotMenuItem	 {		 
	"setPointSize..."
	"(-"	
	"/H<UclearHistory"
	"(-"	
	{Menu -n setOutputCreator -p GnuplotMenuItem	 {		 
	    "select..."												 
	    "add..."													 
	    "delete..."												 
	}}
	"keywordColoring..."
    }}				
    "readme..."
    "/2switchTo gnuplot"										 
    "/Q<Uquit gnuplot"											 
}																		 


	 # Attempt to overload the following command keys:
	 #
	   #  Command-1  :  Console
		#  Command-2  :  Graph
		#  Command-3  :  History
						
						
						
proc	GnuplotMenuItem {menu item} {								 
    #global GnuplotMenu													 
    switch $item {												 
	"console"				GP_Console					 
	"graph"				 	GP_Activate					 
	"gnuplot"				 	GP_Activate					 
	"history"				GP_DumpHistory					 
	"newScriptWin"			GP_NewWindow		 
	"choosePlotFile..."		GP_ChoosePlotFile		 
	"saveAndExecute"	 	GP_SaveAndExecute		 
	"load..."		 		GP_LoadScript			 
	"all"		 			{ GP_SaveSettings "" }			 
	"setCmds"		 		{ GP_SaveSettings "set" }			 
	"functions"		 		{ GP_SaveSettings "fun" }			 
	"variables"		 		{ GP_SaveSettings "var" }			 
	"doSelection"		 	GP_DoSelection			 
	"doLine"					GP_DoLine					 	 
	"switchTognuplot"		GP_Activate				 
	"select..."		 		GP_SelectCreator		 
	"add..."			 		GP_AddCreator			 
	"delete..."		 		GP_DeleteCreator		 
	"clearHistory"			GP_ClearHistory			 
	"quitgnuplot"		 	GP_Quit					 
	"keywordColoring..."		editCurrentModePrefs
	"setWorkingFolder..."   GP_SetCWD
	"setPointSize..."   	GP_SetPTSZ
	"readme..."			 	GP_Readme
	"labels..."				{ GP_Dialog "labl" }
	"line styles..."		    { GP_Dialog "line" }
	"text format..."		    { GP_Dialog "text" }
	"labels..."				{ GP_Dialog "labl" }
	"gxText"				{ GP_Dialog "gxtx" }
	"offsets..."	 		{ GP_Dialog "oset" }
	default					{ insertText [string tolower $item ] () 
	backwardChar    
    }
}																 
}																		 
																			 
#############################################################################
#
#  setup the event handler for Alpha/gnuplot interapp communication
#  This file only works with Alpha 7.0 or newer so we assume
#  eventHandling actually works.
#

if { 1 } {
    # Setup event Handler for STDOUT
    eventHandler GPSE OUTP "GP_STDOUThandler"  
    
    # Setup event Handler for systems w/o ThreadManager
    eventHandler GPSE ERRP "GP_STDERRhandler"
    
    # *ICInitializeCommand // This initializes the console.  
    # Alpha eventhandler is needed.
    # 'GPIC init'
    eventHandler GPIC init "GP_ConsoleH"
    # 
    # *ICInitializePath // sends the working directory as 
    # stored in preferences.
    # Since you aren't displaying the working directory anywhere, 
    # we can ignore
    # this for now.
    # 'GPIC path', contains a string in the direct object.
    eventHandler GPIC path "GP_SendPath"
    # 
    # ICExecute // Tells the console to execute a gnuplot command.  
    # I can't think
    # of a reason for this one in Alpha.  The menuing system uses 
    # this one in the current console.  We could define an event however.
    # 
    # 
    # ICInsertCommand // Might be slick.  An example of what this 
    # does is where
    # functions get pasted into the command line.  Not absolutely necessary
    # though.
    # 'GPIC' 'inse'
    eventHandler GPIC inse "GP_INSEhandler"
    # 
    # ICComeToFront  // The function will bring Alpha to the front.  
    # No handler needed.
    # 
    # *ICBringGnuplotToFront // Handler needed.  When you get this one, bring
    # gnuplot to the front.
    # 'GPIC tofr'
    eventHandler GPIC tofr "GP_ActivateH"
    # 
    # *ICHandleAEReply // You'll get this one if somebody used a 
    # gnuplot menu to
    # do something which necessitated a reply from gnuplot. The 
    # gnuplot interface
    # will pass the reply to you for display.
    # 'GPIC repl', handle this one just like the reply from your exec event.
    eventHandler GPIC repl "GP_STDERRhandler"
    # 
    # *ICMakeNewDocument  // It sounds like this one is working already.
    # 'core crel'
    eventHandler core crel "GP_NewWindowH"
    # 
    # *ICOpenDocument // Alpha already knows about this one.
    # --already defined in alpha---
    
    # The event 'GPIC' 'cbye' is now sent whenever gnuplot quits.
    # This will let you close the console if somebody quits 
    # gnuplot some other way. You could
    # use this to eliminate your 'quit' trapping if you want.
    eventHandler GPIC cbye "GP_CloseH"
    # I also defined a new event: 'GPIC' 'EXEC'.  All you need to 
    # do is take the
    # data and send it back to gnuplot as a 'GPSE' 'exec' event. 
    # This is a kludge
    # to make the commands in the gnuplot app menus work. 
    # It will eventually go away.
    eventHandler GPIC EXEC "GP_Kludge"
    
    proc GP_Kludge {it} {
	set outit  [GP_filtercurlyq $it]
	GP_STDERR $outit
	if { $it == "Unable to find process" } GP_Quit
	return 0
    }	
    
    proc GP_STDERRhandler {it} {
	global gp_cwd
	set outit  [GP_filtercurlyq $it]
	GP_ExtractPath $it
	GP_Results $outit
	if { $it == "Unable to find process" } GP_Quit
	return 0
    }
    
    proc GP_STDOUThandler {it} {
	global gp_cwd gp_Out gpTermCt
	global gp_Console gp_Graph  
	global GPLTmodeVars gp_Launched gp_GEOM
	global gp_Prompt  gp_cwd GnuplotMenu 
	
	set outit  [GP_filtercurlyq $it]
	GP_ExtractPath $it
	set wins [winNames]	
	
	set itLen [ string length "$it" ]
	set termID [ string range "$outit" 0 20 ]
	set termType [ string range "$it" [expr $itLen -25] [expr $itLen -1] ] 
	
	if { [ string first "Sorry," "$termID" ] == 0 } {
	    insertText -w  $gp_Console "\n$outit"
	    return
	    
	} elseif { [ string first "% GNUPLOT: LaTeX" "$termID" ] == 0 } {	   	
	    incr gpTermCt 1
	    #            set gp_Out [getline "Enter name of output console?" "* TeX output $gpTermCt *" ]
	    set gp_Out "* TeX output $gpTermCt *"
	    set theMode "TeX"
	    
	} elseif { [string first "%!PS-Adobe" "$termID" ] == 0 } {
	    incr gpTermCt 1
	    #			set gp_Out [getline "Enter name of output console?" "* PS output $gpTermCt *" ]
	    set gp_Out "* PS output $gpTermCt *"
	    set theMode "PS"
	    
	} elseif { [string first "<MIFFile 3.00>" "$termID" ] == 0 } {
	    incr gpTermCt 1
	    #			set gp_Out [getline "Enter name of output console?" "* MIF output $gpTermCt *" ]
	    set gp_Out "* MIF output $gpTermCt *"
	    set theMode "PS"
	    
	} elseif { [string first "% GNUPLOT: dxf" "$termID" ] >= 0 } {
	    incr gpTermCt 1
	    #			set gp_Out [getline "Enter name of output console?" "* misc output $gpTermCt *" ]
	    set gp_Out "* misc output $gpTermCt *"
	    set theMode "TEXT"
	    
	} elseif { [string first "if unknown cmbase" "$termID" ] == 0 } {
	    incr gpTermCt 1
	    #			set gp_Out [getline "Enter name of output console?" "* MF output $gpTermCt *" ]
	    set gp_Out "* MF output $gpTermCt *"
	    set theMode "TeX"
	    
	} elseif { [string first "#Curve" "$termID" ] == 0 } {
	    incr gpTermCt 1
	    #			set gp_Out [getline "Enter name of output console?" "* misc output $gpTermCt *" ]
	    set gp_Out"* misc output $gpTermCt *"
	    set theMode "TEXT"
	    
	} elseif { [ string index "$termID" 0  ] == " " && [ string first "TERM:dumb" "$termType" ] > 0 } {
	    set ns "\n"
	    append ns $outit
	    set outit "$ns"
	    set gp_Out $gp_Console
	    #set theMode "TEXT"
	    
	} elseif { ![info exists gp_Out ] || [lsearch $wins $gp_Out ] < 0 } {
	    incr gpTermCt 1
	    #			set gp_Out [getline "Enter name of output console?" "* misc output $gpTermCt *" ]
	    set gp_Out "* misc output $gpTermCt *"
	    set theMode "TEXT"
	}
	
	if { $gp_Out == "" } {set gp_Out $gp_Console }
	
	if {  [lsearch $wins $gp_Out ]  < 0 } { 
	    new  -n $gp_Out -m $theMode
	    #set wins [winNames]
	    set gp_Out [lindex [winNames] 0]
	} else {
	    #catch [ bringToFront $gp_Out ] ans
	    #if { ![info exists ans] } { return }
	}
	
	insertText -w $gp_Out $outit
	GP_Console
	if { $it == "Unable to find process" } GP_Quit
	return 0
    }
    
    proc GP_INSEhandler {it} {
	global gp_Console gp_TYPE gp_CREA GnuplotSig
	set res [GP_filtercurlyq $it]
	set wins [winNames]
	if { ( "$res" != "\n" ) & ( "$res" != "" ) & ( "$res" != "\r" ) } {
	    if { [ lsearch $wins $gp_Console  ] >= 0} {
		bringToFront $gp_Console	
	    }		
	}		
	
	goto [maxPos]		
	insertText -w $gp_Console $res
	
	
	set paren  [string first "()" $res ]
	
	if { $paren >= 1 } {
	    goto [expr [maxPos] - $paren + 2]
	}
	
	if { "$res" == "\r" }  {
	    GP_SendCommand "" 3600
	} elseif { "$res" == "\n" }  {
	    GP_SendCommand "" 3600 
	} elseif { "$res" == "" }  {
	    GP_SendCommand "" 3600
	} else {
	    return 0
	}
	
	      
    }
    
    
    proc GP_SendPath { dummyVar } {
	global gp_cwd
	# display current path on status bar
	set gp_cwd [ GP_filtercurlyq $dummyVar ]
	message "Current gnuplot Path ==> $gp_cwd"
    }
    
    proc GP_ConsoleH { dummyVar } { 
	GP_Console   
	# this is a dummy routine
    }  
    
    proc GP_NewWindowH { dummyVar } { 
	switchTo 'ALFA'
	GP_NewWindow   
	# this is a dummy routine
    }  
    
    proc GP_ActivateH { dummyVar } { 
	GP_Activate   
	# this is a dummy routine
    }  

    proc GP_CloseH { dummyVar } { 
	GP_Quit   
	# this is a dummy routine
    }  

} else { 
    set GPLTmodeVars(EventHandler) 0 
}


#############################################################################
#
#  Find and launch gnuplot
#
#

proc GP_Check {} {
    global GnuplotMenu gp_Launched GPLTmodeVars
    
    # Check if gnuplot app is running.  If not, open the app named in 
    # $ (if defined) or have the user select an app via a
    # standard file dialog.  Leave the gnuplot app in the background.
    
    if {![catch {app::launchAnyOfThese {GPSE GPLT} GnuplotSig}]} {
	set gp_Launched 1
	enableMenuItem $GnuplotMenu "quit gnuplot" on
	enableMenuItem $GnuplotMenu "graph" on
	enableMenuItem $GnuplotMenu "history" on
	enableMenuItem $GnuplotMenu "saveSettings" on  
	enableMenuItem gnuplotOptions "setPointSize..." on  
	enableMenuItem $GnuplotMenu "setWorkingFolder..." on
	enableMenuItem $GnuplotMenu "choosePlotFile..."	 on
	return 0
    } else {
	return -1
    }
}

#############################################################################
#
#  Goto command window
#
# 
proc GP_Console {  } {
    global gp_Console  GPLTmodeVars 
    global gp_Launched gp_Prompt 
    
    # Check if gnuplot app is running.  If not, open the app named in 
    # $ (if defined) or have the user select an app via a
    # standard file dialog.  Leave the gnuplot app in the background.
    
    set wins [winNames]
    if { [lsearch $wins $gp_Console ]  >= 0} {
	bringToFront $gp_Console
	goto [maxPos]
    } else   {
	eventHandler GPIC cbye "GP_CloseH"
	GP_NewConsole
    }  
}


#############################################################################
#
#  Create  command window
#
# 
proc GP_NewConsole { } {
    global  gp_Console gp_Graph  gp_Path
    global  GPLTmodeVars gp_Launched gp_GEOM GP_GraphMenu
    global gp_Prompt  gp_cwd GnuplotMenu  gp_home gp_scriptItems
    
    if {[llength $gp_GEOM] != "4" } {			
	GP_Readme
	new -n $gp_Console -m GPLT
	set gp_GEOM [ getGeometry $gp_Console ] 
    }   
    set wd [lindex $gp_GEOM 2]
    set ht [lindex $gp_GEOM 3]
    set top [lindex $gp_GEOM 1]
    set left [lindex $gp_GEOM 0]
    set gY [expr $top - 15]
    set gX [expr $left + $wd + 5]
    set gW [expr 72 ]
    set gH [expr 50 ]
    
    set wins [winNames]	
    if {  [lsearch $wins $gp_Console ]  < 0 } { 
	new -g $left $top $wd $ht -n $gp_Console -m GPLT
    }
    catch { setWinInfo -w $gp_Console shell 1 } jjj
    GP_GraphButton
    if { $GPLTmodeVars(LiveHist) } GP_DumpHistory
    insertText -w $gp_Console  "\nWelcome to Alpha's gnuplot 3.6 shell.\n" 
    GP_Check
    bringToFront $gp_Console
    
    set res [ GP_STDERR ""  3600 ]
    insertText -w $gp_Console "$res"
    
    # The following is a huge kludge...to deal with accidentally
    # closing the gnuplot window
    if	{ $res == "" }	{
	GP_Results "gnuplot> "
    }
    # end kludge
    
    # Now setup the CLIE
    if {[string first "Using threaded console."  $res ] != {-1} \
      | [string first "ppc" [string tolower $res ] ] != {-1}  } { 
	set ress [GP_STDERR "" 3600 ]
    }
    
    set gp_home "$gp_cwd"
    append gp_home "Scripts:*" 
    
    
    set cdir [pwd]
    set gp_Path "$gp_home"
    
    GP_RebuildScriptMenu
    cd "$cdir"
    
    set gp_home [string range "$gp_home" 0 [expr [string length "$gp_home" ] -2 ] ]
    message "Current gnuplot Path ==> $gp_cwd"
    
}


################################################################################
#
#  Rebuild the script menu 
#      
#

proc GP_RebuildScriptMenu {} {
    global gp_cwd GP_GraphMenu gp_scriptItems gp_openItems gp_Path

    set gp_scriptItems [list]
    set gp_openItems [list]
    set gp_home "$gp_Path"

    set gp_sl [ GP_ScriptList "$gp_home" "Scripts" ]
    set gp_sm [concat Menu -m -n "Scripts" -p GP_ScriptMenuItems [list "$gp_sl"]  ]
    
    # kill the current floating menu (if any)
    GP_KillGraphButton
    
    Menu  -n "$GP_GraphMenu" -p GnuplotMenuItem [list \
      "gnuplot" \
      "(-" \
      {Menu -m -s -n "Settings" -p GnuplotMenuItem  {\
      "line styles...&" \
      "text format...&" \
      "labels...&" \
      "offsets...&" \
    }}\
    "(-" \
    "$gp_sm" \
    ]
 	
    GP_GraphButton
}
   
    
################################################################################
#
#  Generate a new script window 
#      
#

proc GP_NewWindow {} {
    set wname "Untitled.gp"
    new -n $wname -m GPLT
    GP_uFD
    insertText "#\r"
    setWinInfo -w $wname dirty 0
}




#############################################################################
#
#  Tell gnuplot to quit
#

proc GP_Quit {} {
    global gp_Console  
    
    switchTo 'ALFA'
    set wins [winNames]
    if { [set winThere [lsearch $wins $gp_Console ] ] >= 0} {
	set name [lindex $wins $winThere]
	bringToFront $name
	killWindow
    } 
    
}


#############################################################################
#
#  Switch to gnuplot
#

proc GP_Activate {  } {
    global   GnuplotSig 
    
    if { ![GP_Check] } { 
	switchTo \'$GnuplotSig\' 
    }	
}


#############################################################################
#
#  Carriage return for command window
#

proc GP_CarriageReturn {} {
    global gp_CommandHist gp_CommandNum  gp_Console gp_Hist gp_Graph 
    
    #enter only if cr in console window...
    set wins [winNames]
    if { [lsearch $wins $gp_Console ]  == 0  } {
	setWinInfo -w $gp_Console dirty 0			
	set pos [getPos]
	
	# I look for > and : instead of the proper prompts... Hmmm...
	# if -1 then we are not on an input line...
	# or we could be waiting for a pause...
	# which should be on the last line...		
	set ind [string first ">" [getText [lineStart $pos] $pos] ]
	if {$ind < 0} {
	    set ind [string first ":" [getText [lineStart $pos] $pos] ]
	    if {$ind < 0} {
		endOfBuffer
		# just send a cr to the server
		insertText "\r"
		GP_SendCommand [getText [lineStart $pos] $pos] 400
		return 
	    }
	}
	set lStart [pos::math [lineStart $pos]+ [expr $ind+2]]
	endOfLine
	set lEnd  [getPos]  
	set scriptName [getText $lStart $lEnd]
	insertText "\r"
	# if not on last line, then replace text on last line...
	GP_SendCommand "$scriptName"  102
    } elseif {[lsearch $wins $gp_Hist ] == 0} {
	# execute the current command in the history window...
	GP_HistgotoMatch
    } else {
	insertText "\r"
    }
}



#############################################################################
#
#  Filter curlyq's out of sting...We may need to be smarter 
#    about this later
#
proc GP_filtercurlyq { it } {
    
    set from [string first "" $it]
    set to [string first "" $it]
    set ans [string range $it [expr $from + 1] [expr $to - 1] ]
    if { ![expr [string length $ans] -1 ] } { 
	regexp -nocase {[a-z0-9]} $ans nans
	if {[info exists nans]} {
	    set ans $nans
	} else {
	    set ans ""
	}
	
	
    }
    
    return $ans
}

#############################################################################
#
#  Extract current gnuplot path from event reply
#

proc GP_ExtractPath { ans } {
    global gp_cwd 
    
    # We need to be tricky since I'm not sure if Dave is sending the
    # path in an alis, or as a string
    #	regexp {(.*)(.*)(.*)} "$ans" dummy spec1 spec2 spec3   
    
    set frst [ string first "PSTR:" "$ans" ]
    set lst [ string first "TERM:" "$ans" ]
    
    if { ($frst > 0) } {
	if { $lst <= 0 } { set lst [string length $ans ] }
	set ans [string range "$ans" $frst $lst ]
	regexp {(.*)} "$ans" dummy  spec3   spec1 
	if {[info exists spec3]} {
	    set ngp_cwd $spec3
	    if {$ngp_cwd != "" } {
		set gp_cwd "$ngp_cwd"
		return 0
	    } 		
	}
    }
    
    regexp {(.*)} "$ans" dummy spec
    if {[info exists spec]} {
	set ngp_cwd [specToPathName $spec]
	if {$ngp_cwd != "" } {
	    set gp_cwd "$ngp_cwd"
	    return 0
	} 		
    }
}	
  
	
 
#############################################################################
#
#  Send a command to gnuplot and return stderr!
#

proc GP_STDERR { mycommand tmout } {
    global  gp_cwd  GPLTmodeVars GnuplotSig gp_TYPE gp_CREA
    
    if { ! $GPLTmodeVars(EventHandler) } {
	catch { AEBuild -t $tmout -r \'$GnuplotSig\' GPSE  "exec" ---- \
	  [curlyq $mycommand] {CREA:} "$gp_CREA" \
	  {TYPE:} "$gp_TYPE" } ans 
    } else {
	catch { AEBuild -t $tmout -r \'$GnuplotSig\' GPSE  "exec" ---- \
	  [curlyq $mycommand] {CLIE:} "ALFA" {CREA:} "$gp_CREA" \
	  {TYPE:} "$gp_TYPE" } ans 
    } 
    if { $ans == "Unable to find process"  }  GP_Quit		
    GP_ExtractPath $ans
    return [GP_filtercurlyq $ans]
}


#############################################################################
#
#  Send a command to gnuplot  
#

proc GP_SendCommand { mycommand tmout} {
    global GPLTmodeVars GnuplotMenu  gp_CommandHist gp_Rsp  gp_CommandNum  
    global gp_Prompts gp_Launched 
    
    watchCursor
    #	GP_Console
    
    set tmout 300
    #display command on the last line of the console if its not already there
    GP_DispCommand "$mycommand"
    if { [string trim $mycommand '\r'] != {} } {
	GP_AddToHist $mycommand
    }
    
    # send gnuplot a command
    # display the stderr results on the screen
    # The eventHandler above will display the stdout results first
    set stderr [GP_STDERR "$mycommand\r"  $tmout ]
    
    # Null stderr can mean two things.  
    #   (1) a pause 
    #   (2) if no thread manager available, it could mean go back 
    #       and retrieve the stderr which will help 68k systems 
    #       work since eventHandler is broken in 6.01
    
    # This can probably be cleaned up with a little effort
    # What I'm doing in the next line is taking care of the 
    # non-threaded macs...
    # which always return "".  Its harmless otherwise.
    #if {$stderr == ""  & $mycommand != "" } { set stderr [GP_STDERR "" $tmout ] }
    #if { $GPLTmodeVars(EventHandler) == "0" &  $stderr == "" } { set stderr "gnuplot> " }
    if { $stderr != "" } { 
	GP_Results	 "$stderr" 
    } else {
	#GP_Results ""
    }
    
    blink [getPos]
}
  

#############################################################################
#
#  Save current window and execute it in GNUPLOT, just like GNUPLOT 
#  command ;)
#

proc GP_SaveAndExecute {} {
    
    if {[winDirty]} {save}
    
    # Get the path of the current window and it's name
    
    # Set the working directory to the current window's
    # current dir.
    set GPLTFilePath "cd \'\:"
    set GPLTFile [lindex [winNames -f] 0]
    set GPLTFP [file dirname $GPLTFile]
    append  GPLTFilePath  $GPLTFP ":\'"
    
    # use unix style file paths 
    regsub -all ":" $GPLTFilePath {/} GPLTFilePath
    
    # get the load command ready...
    set scriptName  "load \'"
    append scriptName [file tail $GPLTFile] "\'"
    
    # Change current working directory to window's
    GP_SendCommand $GPLTFilePath 600
    
    # Do the script
    GP_SendCommand $scriptName 700
}
  

#############################################################################
#
#  Write results to command window  

proc GP_Results { res } {
    global gp_Console gp_cwd
    insertText -w "$gp_Console"  "\n" $res
    setWinInfo -w "$gp_Console" dirty 0
    message "Current gnuplot Path ==> $gp_cwd"
}
 

#############################################################################
#
#  Display or rewrite "command" to command window  

proc GP_DispCommand {command} {
    global   gp_Prompts gp_cwd 
    
    # This is ugly and probably not very efficient.
    
    set lst [maxPos]
    set boll [lineStart $lst]
    set curr [getPos]
    
    if {[pos::compare $curr >= $boll]} {   	
	set bol [lineStart $curr]
	set eol [nextLineStart $curr] 
	set text [getText $bol $eol]
	set ltext [getText $boll $lst]
	foreach gp $gp_Prompts {
	    set c1 [string first $gp $ltext]
	    set c2 [expr $lst - $boll]
	    set c3 [string length $gp]
	    set c4 [expr $lst - $curr] 
	    set c5 [string length $command]
	    if { $c1 == 0 & [expr $c2 >= $c3 | $c4 >= $c5 ] } {
		if {[string first $command $text] == -1} {
		    set a [expr $boll + [string length $gp] ]
		    set b [string trim $command "\r"]
		    replaceText $lst  $a $b
		} 
	    } 
	}	
    }
}


 

#############################################################################
#
#  Send line to GNUPLOT
#

proc GP_DoLine {} {
    
    beginningOfLine
    set bol [getPos]
    endOfLine
    set eol [getPos]
    
    set scriptName [getText $bol $eol]
    GP_SendCommand $scriptName 	800
}


#############################################################################
#
#  Send selection to GNUPLOT
#

proc GP_DoSelection {} {
    # Break lines into separate commands.
    foreach sN [split [getSelect] "\r"] { 
	GP_SendCommand $sN 900
    }
    
}




#############################################################################
#
#  Command History 
#

proc GP_PrevCommand {} {
    global  gp_CommandHist gp_CommandNum gp_Hist gp_Prompt gp_MultiPrompt 
    global  gp_ContPrompt gp_Console gp_Hist
    
    #enter only if cr in console window...
    set wins [winNames]
    if { [lsearch $wins "$gp_Console" ] == 0} {
	
	set text [getText [lineStart [getPos] ] [nextLineStart [getPos] ] ]
	if {[set ind [string first $gp_Prompt $text] ] == 0} {
	    goto [expr [lineStart [getPos] ] + $ind + [string length $gp_Prompt] ]
	} elseif {[set ind [string first $gp_MultiPrompt $text] ] == 0} {
	    goto [expr [lineStart [getPos] ] + $ind + 
	    [string length $gp_Multiprompt] ]
	} elseif {[set ind [string first $gp_ContPrompt $text] ] == 0} {
	    goto [expr [lineStart [getPos] ] + $ind + [string length $gp_Contprompt] ]
	} elseif { return }
	
	incr gp_CommandNum -1
	if {$gp_CommandNum < 0} {
	    incr gp_CommandNum
	    endOfLine
	    return
	} 
	set text [lindex $gp_CommandHist $gp_CommandNum]
	set to [nextLineStart [getPos] ]
	if {[lookAt [expr $to-1] ] == "\r"} {incr to -1}
	
	replaceText [getPos] $to $text
    } elseif { [lsearch $wins $gp_Hist ]  == 0} {
	
	set limit [nextLineStart [nextLineStart 0] ]
	if {[getPos] > $limit} {
	    set limit [pos::math [getPos] - 1]
	}
	select [lineStart $limit] [nextLineStart $limit]
    } else {
	previousLine
    }
    
}
# 

proc GP_NextCommand {} {
    global  gp_CommandHist gp_CommandNum gp_Prompt gp_MultiPrompt 
    global gp_ContPrompt gp_Console gp_Hist
    
    #enter only if cr in console window...
    set wins [winNames]
    if { [lsearch $wins "$gp_Console"  ]  == 0} {
	
	set text [getText [lineStart [getPos] ] [nextLineStart [getPos] ]]
	if {[set ind [string first $gp_Prompt $text] ] == 0} {
	    goto [expr [lineStart [getPos] ] + $ind + 9]
	} elseif {[set ind [string first $gp_MultiPrompt $text] ] == 0} {
	    goto [expr [lineStart [getPos] ] + $ind + 11]
	} elseif {[set ind [string first $gp_ContPrompt $text] ] == 0} {
	    goto [expr [lineStart [getPos] ] + $ind + 3]
	} else  { 
	    endOfBuffer
	    return 
	}
	
	incr gp_CommandNum
	if {$gp_CommandNum > [llength $gp_CommandHist]} {
	    incr gp_CommandNum -1
	    return
	}
	set text [lindex $gp_CommandHist $gp_CommandNum]
	set to [nextLineStart [getPos] ]
	if {[lookAt [expr $to-1] ] == "\r"} {incr to -1}
	replaceText [getPos] $to $text
    } elseif { [lsearch $wins $gp_Hist  ]  == 0} {
	set pos [getPos]
	if {$pos < [nextLineStart 0]} {
	    set pos [nextLineStart 0]
	}
	if {[nextLineStart $pos] != [maxPos]} {
	    select [nextLineStart $pos] [nextLineStart [nextLineStart $pos] ]
	}
    } else {
	# mv cusor down...
	nextLine
    }	
}



#############################################################################
#
#  Edit current window in GNUPLOT
#

proc GP_EditFile {} {
    global GnuplotSig 
    
    if { ![GP_Check] } {
	set thisWin  [lindex [winNames] 0]
	if {[winDirty]} {
	    if {[askyesno "Save '$thisWin'?"] == "yes"} {
		save
	    } else { 
		return 
	    } 	
	}
	set thisWin  [lindex [winNames -f ] 0]
	killWindow
	if {![catch {sendOpenEvent -n \'$GnuplotSig\' $thisWin }]} {
	    switchTo \'$GnuplotSig\' 	
	}
    }
}


#############################################################################
#
#  change behavior of modifyModeFlags
#

	
proc GP_modifyModeFlags {{title ""}} {
    global mode GPLTmodeVars gp_modflag PREFS gp_HistGEOM gp_GEOM
    global GnuplotMenu  gp_Graph gp_Console  gp_Hist gp_floatmenu
    
    set wins [winNames]
    if { [lsearch $wins "$gp_Console" ]  >= 0}  {
	set gp_GEOM [ getGeometry "$gp_Console" ]
    }
    
    if { [lsearch $wins $gp_Hist] >= 0 } {
	set gp_HistGEOM [ getGeometry "$gp_Hist" ]
    }
    
    set gp_modflag 1
    
    if { $GPLTmodeVars(LiveHist) } { 
	set wins [winNames]
	if { [lsearch $wins "$gp_Console"  ]  >= 0} {
	    GP_DumpHistory
	} 
    } else {
	set wins [winNames]
	if {[lsearch $wins $gp_Hist  ]  >= 0} {
	    bringToFront $gp_Hist
	    killWindow 
	} 
    }
    if { $GPLTmodeVars(EventHandler) } { 
    } else {
	set jj1 "The event handler is broken in Alpha (68k).
	set jj2 "You may need to disable event handling until it is fixed."
	alertnote $jj1 $jj2
    }
    if { $GPLTmodeVars(GraphButton) } { 
	GP_GraphButton
    } else {
	GP_KillGraphButton
    }
    # This file is sourced when appropriate by Alpha, 
    # it should not happen here.
    #catch {  source $PREFS:GPLTPrefs.tcl } jjj
    catch {	bringToFront "$gp_Console" } jjj
}

#############################################################################
#
#  closeHook procedure so that gnuplot is quit 
#  whenever the user closes the console window.  Also ask about 
#  saving the history list when the console is closed.
#
#
	
proc GP_CloseHook	{name} {
    global GnuplotMenu GPLTmodeVars PREFS modifiedArrayElements
    global gp_CreatorList gp_TypeList gp_Console gp_Graph gp_Hist 
    global gp_CreatorNames gp_CommandNum gp_Launched GnuplotSig modifiedVars
    global gp_GEOM gp_HistGEOM modifiedVars
    
    if { [string first "$gp_Console" $name] == 0	} {
	
	if	{$gp_CommandNum != 0 && ! $GPLTmodeVars(NevrSavHist) } {
	    GP_DumpHistory
	    set ans [askyesno -c "Save	gnuplot command History?" ]
	} else {	set ans "yes" }
	
	GP_OffSet
	switch -exact [string tolower $ans] {
	    "cancel"   { GP_Console; return $result }
	    "no"       { GP_ClearHistory }
	    "yes"	   { 	
		catch { setWinInfo -w $gp_Hist read-only 0 } jj										
		catch { setWinInfo -w $gp_Hist dirty 1 } jj
		catch { bringToFront $gp_Hist } jj
		if { $jj == 0 } { 
		    catch { saveAs "history.gp" } jj
		}
		catch { setWinInfo -w $gp_Hist dirty 0 } jj										
		catch { setWinInfo -w $gp_Hist read-only 1 } jj
		GP_ClearHistory
	    }
	} 
	#end case
	#		if {$gp_Launched	!=	0 } { 
	catch { sendQuitEvent \'$GnuplotSig\' } hhh  
	lappend modifiedVars  GnuplotSig 
	#            } 
	set gp_Launched 0
	set wins [winNames]
	if { [lsearch $wins $gp_Hist  ]  >= 0} {
	    bringToFront $gp_Hist
	    killWindow 
	} 
	lappend modifiedVars   gp_GEOM 
	lappend modifiedVars   gp_HistGEOM 
	
    } elseif {[string first $gp_Hist	$name] == 0} {
	set wins [winNames]
	if { [lsearch $wins "$gp_Console" ]  >= 0} {
	    set GPLTmodeVars(LiveHist) 0
	} 
    }
} 
	

#############################################################################
#
#  Redefine the deactivateHook procedure so that gnuplot is quit 
#  whenever the user closes the console window.  Also ask about 
#  saving the history list when the console is closed.
#
#
	
proc GP_DeactivateHook	{name} {
    global  gp_Hist GPLTmodeVars gp_Console gp_Graph
    global  gp_GEOM gp_HistGEOM
    if	{ [string first $gp_Hist $name] == 0	} {
	set gp_HistGEOM [ getGeometry "$gp_Hist" ]
	endOfBuffer
    } elseif {[string first "$gp_Console" $name] == 0} {
	set gp_GEOM [getGeometry "$gp_Console" ]
    } 
} 

#############################################################################
#
#  Redefine the activateHook procedure so that gnuplot is quit 
#  whenever the user closes the console window.  Also ask about 
#  saving the history list when the console is closed.
#
#
proc GP_ActivateHook	{name} {
    global  gp_Hist gp_Graph gp_Console modifiedArrayElements
    global  mode gp_cwd GPLTmodeVars mode gp_modflag gp_GEOM
    
    if	{ [string first "$gp_Console" $name] == 0} {
	changeMode GPLT
	set gp_GEOM [ getGeometry "$gp_Console" ]
    } elseif	{ [string first $gp_Hist $name] == 0} {
	set gp_HistGEOM [ getGeometry "$gp_Hist" ]
    }
    
    message "Current gnuplot Path ==> $gp_cwd"
} 




###########################################################################
#
# In GNUc mode, cmd-double-click highlights area btween consecutive 
# gnuplot prompts
#

proc GPLT::DblClick {from to} {
    
    global gp_Prompts
    
    # First find "gnuplot> " prompt above and below cursor entry...
    # don't forget to deal with "multiplot> " and "> "
    
    set gp1 [list]
    foreach gp $gp_Prompts {lappend gp1 [search -n -f 0 -r 1   $gp $from] }
    set firstmatch [lindex [lindex $gp1 0 ] 0]
    foreach el $gp1 { 
	if {[lindex $el 1] > $firstmatch } { 
	    set firstmatch [lindex $el 0] 
	} 
    }	
    
    if {$firstmatch == {}} {
	message "You are not between prompts" 
	return 
    } else {
	
	set firstmatch [nextLineStart $firstmatch]
	endOfBuffer
	set lastmatch [getPos ]
	set gp1 [list]
	foreach gp $gp_Prompts {lappend gp1 [search -n -f 1 -r 1   $gp $from] }
	foreach el $gp1 {
	    if {[lindex $el 1]!={} & [lindex $el 0]< $lastmatch } { 
		set lastmatch $el 
	    } 
	}
	if {$lastmatch == {}} {
	    message "You are not between prompts" 
	    return 
	} else { 
	    
	    goto $lastmatch
	    beginningOfLine
	    select $firstmatch [getPos] 
	}
    }
}



#############################################################################
#
#  Select creator from list
#

proc GP_SelectCreator {} {
    global gp_CreatorNames  gp_CreatorList   gp_TypeList GPLTmodeVars  
    global setOutputCreator modifiedArrayElements modifiedVars
    global gp_CREA gp_TYPE
    
    set crea [listpick -p "Select output file creator:" $gp_CreatorNames  ]
    set creator [lindex $gp_CreatorList [lsearch  $gp_CreatorNames $crea] ]
    set type [lindex $gp_TypeList [lsearch  $gp_CreatorNames $crea] ]
    if {$creator == {} } {
	set gp_CREA 'ALFA'
	set gp_TYPE 'TEXT' 
    } else { 
	set gp_CREA $creator
	set gp_TYPE $type
    }
    lappend modifiedVars  gp_TYPE
    lappend modifiedVars  gp_CREA
    lappend modifiedVars  gp_CreatorList 
    lappend modifiedVars  gp_TypeList
    lappend modifiedVars  gp_CreatorNames 
}


#############################################################################
#
#  Add creator to list from file dialog
#

proc GP_AddCreator {} {
    global gp_CreatorNames  gp_CreatorList  GnuplotMenu gp_TypeList 
    global GPLTmodeVars modifiedVars modifiedArrayElements
    global gp_CREA gp_TYPE
    
    set fname [getfile "Select file type for creator"] 
    #  add to creator list
    if {[getFileType $fname]=="APPL"} {
	alertnote "Sorry, but that was an application. \rTry again."
	return
    }
    
    if {$fname != {}} {
	set nm [getline "What do you wish to call it?" [file tail $fname ] ]
	if {$nm != {} } {   
	    set gp_CREA  [getFileSig $fname]
	    set gp_TYPE  [getFileType $fname]
	    lappend gp_CreatorList  $gp_CREA
	    lappend gp_TypeList     $gp_TYPE
	    lappend gp_CreatorNames $nm
	    enableMenuItem  setOutputCreator "Select..." on
	    enableMenuItem  setOutputCreator "Delete..." on
	    lappend modifiedVars  gp_TYPE
	    lappend modifiedVars  gp_CREA
	    lappend modifiedVars  gp_CreatorList 
	    lappend modifiedVars  gp_TypeList 
	    lappend modifiedVars  gp_CreatorNames 
	}
    }
    
    
}

#############################################################################
#
#  Remove creator from list
#

proc GP_DeleteCreator {} {
    global gp_CreatorNames GnuplotMenu gp_CreatorList  gp_TypeList 
    global GPLTmodeVars modifiedVars modifiedArrayElements
    global gp_CREA gp_TYPE
    
    set crea [listpick -p "Select creator to be deleted:"  $gp_CreatorNames ]
    
    if {$crea != {}} {
	#  now remove this creator from both lists....
	set creatorInd [lsearch  $gp_CreatorNames $crea]
	set crea [ lindex $gp_CreatorList $creatorInd]
	set gp_CreatorNames [ lreplace $gp_CreatorNames $creatorInd $creatorInd ]
	set gp_CreatorList  [ lreplace $gp_CreatorList  $creatorInd $creatorInd ]
	set gp_TypeList     [ lreplace $gp_TypeList     $creatorInd $creatorInd ]
	
	if {$gp_CREA == $crea } {
	    set gp_CREA 'ALFA'
	    set gp_TYPE 'TEXT'
	} 
	lappend modifiedVars  gp_TYPE
	lappend modifiedVars  gp_CREA
	lappend modifiedVars  gp_CreatorList 
	lappend modifiedVars  gp_TypeList 
	lappend modifiedVars  gp_CreatorNames 
    }
    
    if {[llength $gp_CreatorList] == 0} {
	enableMenuItem  setOutputCreator "Select..." off
	enableMenuItem setOutputCreator "Delete..." off
    }
}


#############################################################################
#
#  Add command to history list
#

proc GP_AddToHist  { cmmd } {
    global gp_CommandHist gp_CommandNum GnuplotMenu 
    global GP_Console gp_Hist GPLTmodeVars
    
    enableMenuItem gnuplotOptions "clearHistory" on
    lappend gp_CommandHist $cmmd
    set gp_CommandNum [llength $gp_CommandHist]
    
    if { $GPLTmodeVars(LiveHist) } {
	# if history list active then append $cmmd on last line
	set wins [winNames]
	if { [lsearch $wins $gp_Hist ]  >= 0} {
	    setWinInfo -w $gp_Hist dirty 1
	    setWinInfo -w $gp_Hist  read-only 0
	    insertText -w $gp_Hist "$cmmd\r"
	    setWinInfo -w $gp_Hist  dirty 0
	    setWinInfo    -w $gp_Hist  read-only 1
	} else {
	    GP_DumpHistory
	    bringToFront "$gp_Console"
	}
	
    }
}


#############################################################################
#
#  Clear History list 
#

proc GP_ClearHistory {} {
    global  GnuplotMenu gp_CommandHist gp_CommandNum  gp_Hist
    
    set gp_CommandHist [list]
    set gp_CommandNum "0"
    enableMenuItem gnuplotOptions "clearHistory" off	
    set wins [winNames]
    if { [lsearch $wins $gp_Hist ] >= 0} {
	bringToFront $gp_Hist
	killWindow 
    }
}


#############################################################################
#
#  Write History list into a window of its own.
#

proc GP_DumpHistory {} {
    global gp_CommandHist gp_CommandNum gp_Console 
    global GPLTmodeVars gp_Console gp_Hist  
    global gp_GEOM
    
    set wins [winNames]
    set nw [ llength $wins ]
    
    if { [lsearch $wins $gp_Hist ]  == -1} {
	
	set l [ expr [lindex $gp_GEOM 0] + 12 + [lindex $gp_GEOM 2] ]
	set t [ expr [lindex $gp_GEOM 1] + 65 ]
	set w 96
	set h [ expr [lindex $gp_GEOM 3] - 65 ]
	new -n $gp_Hist -g $l $t $w $h -m GPLT
	set gp_HistGEOM [getGeometry]		
	GP_uFD
	set scriptName "# (<cr> to send to gnuplot)\r#-----\r"
	foreach word $gp_CommandHist  {append  scriptName  $word "\r" }
	insertText  -w $gp_Hist $scriptName
	setWinInfo dirty 0
	setWinInfo read-only 1
    } else {
	bringToFront $gp_Hist
    }
}

	

################################################################################
#
#  Insert File Description---use Vince's if possible.  
#      this used in creating new window and in dumping history list
#

proc GP_uFD { } {
    #catch {userFileDescription } ans 
    #if { 	$ans != ""	}  {
    insertText "#\r#\r#     " [join [mtime [now] long] ] "\r"
    nextLine
    #}
    endOfBuffer
}


################################################################################
#
#  Clear a few globals...
#
#
#
proc GP_Clear {} {
    global PREFS  GPLTmodeVars
    global  gp_CreatorList gp_CreatorNames  
    global gp_GEOM gp_HistGEOM modifiedVars
    global gp_CREA gp_TYPE
    
    if { [info exists gp_GEOM] } { set gp_GEOM [list] }      
    if { [info exists gp_CreatorList] } { unset gp_CreatorList }      
    if { [info exists gp_TypeList] } { unset gp_TypeList }      
    if { [info exists gp_CreatorNames] } { unset gp_CreatorNames }      
    if { [info exists gp_HistGEOM] } { unset gp_HistGEOM  }      
    if { [info exists gp_CREA] } { unset gp_CREA  }      
    if { [info exists gp_TYPE] } { unset gp_TYPE  }      
    
    ensureset gp_CreatorList [list ALFA GPLT ] 
    ensureset gp_TypeList [list TEXT TEXT ] 
    ensureset gp_CreatorNames [list alpha gnuplot] 
    ensureset gp_CREA ALFA
    ensureset gp_TYPE TEXT
    ensureset gp_GEOM [list]
    ensureset gp_HistGEOM [list ]
    
    if { [llength $gp_CreatorList] == 0 \
      || [llength $gp_CreatorList] != [llength $gp_CreatorNames] \
      || [llength $gp_CreatorList] != [llength $gp_TypeList]} {
	set gp_CreatorList [list]
	set gp_TypeList [list]
	set gp_CreatorNames [list]
    }
    
    lappend modifiedVars gp_CreatorNames gp_TypeList gp_CreatorList 
    lappend modifiedVars gp_HistGEOM gp_GEOM
    lappend modifiedVars gp_TYPE gp_CREA
    #catch { source $PREFS:gnuplotMode.tcl } blah
    #catch { source $HOME:Tcl:Modes:gnuplotMode.tcl } blah
}


################################################################################
#
#  History goto match...
#
#
#

proc GP_HistgotoMatch {} {
    set frst [lineStart [getPos] ]
    endOfLine
    set lst  [getPos]
    endOfBuffer
    beginningOfLine
    GP_SendCommand [getText $frst $lst ] 1000
}




 
################################################################################
#
#  Create floating menu
#
#
#

set GP_GraphMenu "gnuplotGraph"

set gp_grmen [list "Menu  -n $GP_GraphMenu -p GnuplotMenuItem" ]
lappend gp_grmen "gnuplot" "(-" 

Menu  -n $GP_GraphMenu -p GnuplotMenuItem   [ concat \
  "gnuplot" \
  ]

 	





################################################################################
#
#  run load scripts from scripts menu
#
#
#

proc GP_ScriptMenuItems {menu item} {
    global gp_sl gp_home gp_scriptItems gp_Path  gp_openItems
    
    set men [string tolower $menu]
    set ite [string tolower $item]
    
    if { "$item" == "Rebuild Menu" } {
	set cdir [pwd]
	set sl [expr [string length $gp_Path ] - 2] 
	cd [string range $gp_Path 0 $sl ]
	GP_RebuildScriptMenu
	cd "$cdir"
	return 0
    }
    
    foreach it $gp_scriptItems {
	if { [string match "cd \'*$men:\'; load \'*$men:$ite\'" [string tolower $it] ] } {
	    GP_SendCommand "$it" 110
	    return 0
	}  	
    }
    
    #set men [string tolower [string range $menu 5 [string length $menu] ] ]
    
    # filter out the " edit "  from the selected $menu $item
    set ite [string tolower [string range $item 7 [string length $item] ] ]
    
    foreach it $gp_openItems {
	if { [string match "*$men:$ite" [string tolower $it] ] } {
	    edit "$it" 
	    changeMode GPLT 
	    return 0
	}  	
    }
}



################################################################################
#
#  Create a floating gnuplot graph button (Alpha 6.2 or higher)
#
#
#
proc GP_GraphButton {} {	
    global gp_floatmenu GP_GraphMenu GPLTmodeVars gp_sl gp_Path gp_GEOM gp_FLTGEOM
    
    
    #	if {[llength $gp_FLTGEOM] != 2 } {	
    if {[llength $gp_GEOM] == 4 } {
	set l [ expr [lindex $gp_GEOM 0] + 5 + [lindex $gp_GEOM 2] ]
	set t [ expr [lindex $gp_GEOM 1] - 20 ]
	set gp_FLTGEOM [list $l $t ] 
    } else {
	set l 20
	set t 20
    }
    #	}  else {
    #  		set l  [lindex $gp_FLTGEOM 0]  
    #  		set t  [lindex $gp_FLTGEOM 1]  
    #	}
    
    if {$GPLTmodeVars(GraphButton) } { 
	if { (![info exists  gp_floatmenu] )} {
	    set gp_floatmenu [float -m $GP_GraphMenu -n "" -M -1 -z GPLT -l $l -t $t ]
	} 
	
    } 
    
}



################################################################################
#
#  Generate the script menu 
#      
#

proc GP_ScriptList { sdir men } {
    global gp_scriptItems  gp_openItems
   
    if {"$men" == "Scripts" } {
    	set sl [list "\(Rebuild Menu"]
    } else {
    	set sl [list]
    }
    
    # get the list of text files in $sdir
    set gp_fl [ glob -nocomplain -t TEXT "$sdir"] 
    set mdir [string range "$sdir" 0 [expr [string length "$sdir"] - 2 ] ] 
    set rdir [string range "$mdir" 0 [expr [string length "$mdir"] -1 ] ]
    foreach f $gp_fl {
	set mitem [string range $f [expr 1 + [string last ":" "$f" ] ] [ string length "$f" ] ]
	#append mitem "&"
	if { $mitem != "" } { 
	    lappend sl "<E<S$mitem" 
	    lappend sl "<S<I edit $mitem" 
	    lappend sl "<S<B edit $mitem" 
	    lappend sl "<S<U edit $mitem" 
	    lappend sl "<S<O edit $mitem" 
	    lappend gp_scriptItems "cd \'$rdir\'; load \'$f\'"
	    lappend gp_openItems "$f"
	}
    }
    
    # get the list of aliased directories in $sdir and
    # perform this operation again on subdirectories
    set dlist [ glob   -t fdrp -nocomplain "$sdir"]
    foreach d $dlist {
	set dn [string range $d [expr [string last ":" "$d" ] +1 ] [string length $d]   ]
	#set dn [string range $dn [expr 1 + [string last ":" "$dn" ] ] [ string length "$dn" ] ]
	set sl [concat "$sl"  [concat " \{Menu -m -n" "\"$dn\"" -p GP_ScriptMenuItems  " \{  "  ] ]
	set dnam $d
	append dnam "*" 
	#set gp_ssl [ GP_ScriptList "$dnam" $dn ]
	set gp_ssl [list "(ALIASED FOLDERS NOT WORKING YET"]
	set sl [ concat "$sl "  $gp_ssl " \}  \} " ]
    }
    
    # get the list of directories in $sdir and
    # perform this operation again on subdirectories
    set dlist [ glob -nocomplain  "$sdir:"]
    foreach d $dlist {
	set dn [string range $d 0 [expr [string last ":" "$d" ] - 1 ]  ]
	set dn [string range $dn [expr 1 + [string last ":" "$dn" ] ] [ string length "$dn" ] ]
	set sl [concat "$sl"  [concat " \{Menu -m -n" "\"$dn\"" -p GP_ScriptMenuItems  " \{  "  ] ]
	set dnam $d
	append dnam "*" 
	set gp_ssl [ GP_ScriptList "$dnam" $dn ]
	set sl [ concat "$sl "  $gp_ssl " \}  \} " ]
    }
    
    return  $sl 
}


################################################################################
#
#  Kill a floating gnuplot menu (Alpha 6.2 or higher)
#
#
#
proc GP_KillGraphButton {} {	
    global gp_floatmenu GnuplotMenu GPLTmodeVars 
    
    if { [info exists  gp_floatmenu] }  { 
	catch {unfloat $gp_floatmenu } ans
	unset gp_floatmenu
    }
}





################################################################################
#
#  Load a script into gnuplot 
#      
#

proc GP_LoadScript {} {
    global gp_cwd
    catch { cd "$gp_cwd" } hmm
    set GPLTFile [ getfile "Choose a script to load:" ]
    if { $GPLTFile != "" } {	
	GP_SendCommand  "load \'$GPLTFile\'" 120
    }
}



################################################################################
#
#  Tell gnuplot to save settings...
#
#
#

proc GP_SaveSettings { what } {
    global  GPLTmodeVars gp_cwd gp_TYPE gp_CREA
    
    catch { cd "$gp_cwd" } hmm
    set tCREA $gp_CREA
    set tTYPE $gp_TYPE
    set gp_CREA {ALFA}
    set gp_TYPE {TEXT}
    set where [ putfile "Save current gnuplot settings" \
      [format "gnuplot%src.gp" [string toupper $what ] ] ]
    if { $where != "" } { 
	GP_SendCommand "save $what \'$where\'" 130
    }
    set gp_CREA  $tCREA
    set gp_TYPE  $tTYPE
}



################################################################################
#
#  Tell gnuplot where the current dir is...
#
#
#

proc GP_SetCWD {} {
    set gp_cwd [ get_directory -p "Select gnuplot working folder"]
    if { $gp_cwd != "" } {
	GP_SendCommand "cd \'$gp_cwd\'" 140
    }
}



################################################################################
#
#  Tell gnuplot to change the point size
#
#
#

proc GP_SetPTSZ {} {
    GP_SendCommand " set pointsize [ getline "Enter point size" 1 ] " 150
}

################################################################################
#
#  Choose a file to plot and write "plot 'filename'" on command line
#
#
#

proc GP_ChoosePlotFile { } {
    global gp_Console gp_cwd
    catch { cd "$gp_cwd" } hmm
    set plotfile [ getPathName "Choose a file to plot" 1 ] 
    if { $plotfile != "" } {
	insertText -w "$gp_Console" "plot \'$plotfile\' "
    }
}


################################################################################
#
#  Setup menu flags, etc ... assuming gnuplot is off
#
#
#
proc GP_OffSet {} {
    global GnuplotMenu gp_CreatorList
    
    enableMenuItem gnuplotOptions "clearHistory" off				 
    enableMenuItem $GnuplotMenu "quit gnuplot" off				 
    enableMenuItem $GnuplotMenu "graph" off				 
    enableMenuItem $GnuplotMenu "history" off				 
    enableMenuItem $GnuplotMenu "saveSettings" off  
    enableMenuItem gnuplotOptions "setPointSize..." off  
    enableMenuItem $GnuplotMenu "setWorkingFolder..." off
    enableMenuItem $GnuplotMenu "choosePlotFile..."	 off
    
    if {[llength $gp_CreatorList] == 0} {
	enableMenuItem  setOutputCreator "Select..." off
	enableMenuItem  setOutputCreator "Delete..." off
    }
    
}

################################################################################
#
#  TEMPORARY JUNK
#
#
#
set gp_cwd "???"

proc aevt { hmm } { 
    #dummy procedure to fool 68k into semi-working w/eventHandler....
    if { $hmm == "'GP_A'()" } {
	GP_Activate
    } elseif {$hmm=="'GP_C'()" } {
	GP_Results "gnuplot> "
	
    }	
}
	 

################################################################################
#
#  Things to do in order to properly setup gnuplot mode menu
#
#
#
set gp_modflag 0
GP_OffSet


################################################################################
#
#  A simple user message
#
#
#
proc GP_Readme {} {	
  set wname "message"
  new -n $wname -m GPLT
  GP_uFD

  insertText { 
#
   gnuplotMode.tcl Version 1.82

#   NEWSTUFF:
#   ---------

   This version has a simple floating menu with a button that lists
   all texts files in the scripts directory of gnuplot home dir.
   To run a script, just select it from the scripts menu.  To edit
   a script in Alpha, select a script menu item while holding down a 
   modifier key (shift, option, command, OR ctrl).


   Modify some of the GPLT mode behaviour by choosing the menu item:

#     Config:Current Mode:Flags...


   To edit keyword coloring choose the configure menu item:

#     Config:Current Mode:Edit Prefs



#   GNUPLOT works best with Alpha 6.2 or later
#   ------------------------------------------

#   FOR 68K USERS ONLY
#   ------------------

   Recent versions of Alpha (<6.2) do not have a fully working      
   eventHandler procedure.  Thus, you might notice strange behavior  
   in the gnuplot console.  The symptoms of the problem are that     
   a new gnuplot prompt may not be displayed on the screen after     
   pressing a carriage return;  or, longer messages may be garbled. 
  
   Try the following: 

#      set term post
#      plot sin(x)

   If you see pages of postscript output, then the eventHandler is 
   apparently working.

   If not, then to make effective use of the console you may need   
   to open the Config:Current Mode:flags... menu in Alpha (when in  
   
   Keep an eye out at ftp://www.cs.umd.edu/pub/faculty/keleher/Alpha
   for the latest versions of Alpha which will eventually solve      
   this problem.

#   jeff@wave.nrl.navy.mil 
}	
   
  setWinInfo -w $wname dirty 0
	 
}


#############################################################################
#
#  change behavior of editCurrentModePrefs
#

proc GP_editCurrentModePrefs { } {
    global mode GPLTmodeVars gp_modflag PREFS gp_HistGEOM gp_GEOM
    global GnuplotMenu  gp_Graph gp_Console  gp_Hist 
    global PREFS HOME 
    
    set wins  [winNames]
    set jjwinThere [lsearch $wins "GPLTPrefs.tcl"]
    set searchString1 {[\n\r]###BGK[\n\r](.*)[\n\r]###EGK[\n\r]}
    
    if { $jjwinThere >= 0} {
	set ss [searchInFile [file join $PREFS GPLTPrefs.tcl]  "$searchString1" ]
	if { $ss == "" } {
	    goto [maxPos]
	    if {$ss == ""} {											   	
		set ss [searchInFile [file join $HOME Tcl Modes gnuplotMode.tcl] \
		  "$searchString1" ]
	    } 
	    if {$ss == ""} {											   	
		alertnote "Sorry, you'll have to edit gnuplotMode.tcl on your own."
	    } else {
		insertText -w "GPLTPrefs.tcl" "\n\n$ss\n\n"
		goto [nextLineStart [minPos]]
	    }
	}
    }
}


set gp_fm_first 1



#############################################################################
#
#  Called from menu to handle dialogs in the server app
#  
#
proc GP_Dialog { ans } {
    global  GnuplotSig
    switchTo  \'$GnuplotSig\'
    AEBuild -t 3600 -r 'GPSE' GPLT "DIAG" ---- $ans
    switchTo 'ALFA'
}




