/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.utils;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.rules.DirectiveConditional;
import org.islandoftex.arara.api.rules.DirectiveConditionalType;
import org.islandoftex.arara.cli.utils.StringExtensionsKt;
import org.islandoftex.arara.core.configuration.ConfigurationUtils;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.islandoftex.arara.core.session.Session;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002J\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0016J\u0016\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007J\u0018\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002J\u0018\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002J\u000e\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0016H\u0002J\u000e\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u0007J\u0014\u00100\u001a\u00020\"2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000702J\u000e\u00103\u001a\u00020\"2\u0006\u00104\u001a\u000205J\u0015\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u000208H\u0000\u00a2\u0006\u0002\b9J\u000e\u0010:\u001a\u00020\"2\u0006\u0010;\u001a\u00020<J\b\u0010=\u001a\u00020\"H\u0002J\u000e\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u0007J\u0006\u0010@\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\tR\u0014\u0010\u001f\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0011\u00a8\u0006A"}, d2={"Lorg/islandoftex/arara/cli/utils/DisplayUtils;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "logoString", "", "getLogoString", "()Ljava/lang/String;", "configurationFileName", "getConfigurationFileName", "setConfigurationFileName", "(Ljava/lang/String;)V", "longestMatch", "", "getLongestMatch", "()I", "longestMatch$delegate", "Lkotlin/Lazy;", "shortenedLongestMatch", "displayLine", "", "displayResult", "displayRolling", "displayException", "isDryRunMode", "()Z", "isVerboseMode", "applicationPath", "getApplicationPath$cli", "outputWidth", "getOutputWidth", "buildShortEntry", "", "name", "task", "printEntryResult", "value", "printEntry", "buildLongEntry", "buildDryRunEntry", "printException", "exception", "Lorg/islandoftex/arara/api/AraraException;", "getResult", "printWrapped", "text", "printAuthors", "authors", "", "printConditional", "conditional", "Lorg/islandoftex/arara/api/rules/DirectiveConditional;", "byteSizeToString", "size", "", "byteSizeToString$cli", "printTime", "seconds", "", "displayDetailsLine", "displayOutputSeparator", "message", "displaySeparator", "cli"})
@SourceDebugExtension(value={"SMAP\nDisplayUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayUtils.kt\norg/islandoftex/arara/cli/utils/DisplayUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n1563#2:367\n1634#2,3:368\n*S KotlinDebug\n*F\n+ 1 DisplayUtils.kt\norg/islandoftex/arara/cli/utils/DisplayUtils\n*L\n53#1:367\n53#1:368,3\n*E\n"})
public final class DisplayUtils {
    @NotNull
    public static final DisplayUtils INSTANCE = new DisplayUtils();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(DisplayUtils::logger$lambda$0);
    @NotNull
    private static final String logoString = "  __ _ _ __ __ _ _ __ __ _\n / _` | '__/ _` | '__/ _` |\n| (_| | | | (_| | | | (_| |\n \\__,_|_|  \\__,_|_|  \\__,_|";
    @NotNull
    private static String configurationFileName = "[none]";
    @NotNull
    private static final Lazy longestMatch$delegate = LazyKt.lazy(DisplayUtils::longestMatch_delegate$lambda$2);
    private static final int shortenedLongestMatch = 10;
    private static boolean displayLine = true;
    private static boolean displayResult;
    private static boolean displayRolling;
    private static boolean displayException;

    private DisplayUtils() {
    }

    @NotNull
    public final String getLogoString() {
        return logoString;
    }

    @NotNull
    public final String getConfigurationFileName() {
        return configurationFileName;
    }

    public final void setConfigurationFileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        configurationFileName = string;
    }

    private final int getLongestMatch() {
        Lazy lazy = longestMatch$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final boolean isDryRunMode() {
        return LinearExecutor.INSTANCE.getExecutionOptions().getExecutionMode() == ExecutionMode.DRY_RUN;
    }

    private final boolean isVerboseMode() {
        return LinearExecutor.INSTANCE.getExecutionOptions().getVerbose();
    }

    @NotNull
    public final String getApplicationPath$cli() {
        String string;
        try {
            string = ConfigurationUtils.getApplicationPath().toString();
        }
        catch (AraraException araraException) {
            string = "[unknown application path]";
        }
        return string;
    }

    private final int getOutputWidth() {
        return Session.INSTANCE.getUserInterfaceOptions().getTerminalOutputWidth();
    }

    private final void buildShortEntry(String name, String task) {
        int result2 = this.getLongestMatch() >= this.getOutputWidth() ? 10 : this.getLongestMatch();
        int space = this.getOutputWidth() - result2 - 1;
        String line = StringExtensionsKt.abbreviate$default("(" + name + ") " + task + " ", space - 4, null, 2, null);
        System.out.print((Object)(StringsKt.padEnd(line, space, '.') + " "));
    }

    public final void printEntryResult(boolean value) {
        displayLine = false;
        displayResult = true;
        logger.info(() -> DisplayUtils.printEntryResult$lambda$3(value));
        if (!this.isDryRunMode()) {
            Object object = !this.isVerboseMode() ? StringsKt.padStart$default(this.getResult(value), this.getLongestMatch(), '\u0000', 2, null) : "\n" + StringsKt.padStart(" " + this.getResult(value), this.getOutputWidth(), '-');
            System.out.println(object);
        }
    }

    public final void printEntry(@NotNull String name, @NotNull String task) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(task, "task");
        logger.info(() -> DisplayUtils.printEntry$lambda$4(task, name));
        displayLine = true;
        displayResult = false;
        if (!this.isDryRunMode()) {
            if (!this.isVerboseMode()) {
                this.buildShortEntry(name, task);
            } else {
                this.buildLongEntry(name, task);
            }
        } else {
            this.buildDryRunEntry(name, task);
        }
    }

    private final void buildLongEntry(String name, String task) {
        if (displayRolling) {
            System.out.println();
        } else {
            displayRolling = true;
        }
        System.out.println((Object)this.displaySeparator());
        String string = StringExtensionsKt.abbreviate$default("(" + name + ") " + task, this.getOutputWidth(), null, 2, null);
        System.out.println((Object)string);
        System.out.println((Object)this.displaySeparator());
    }

    private final void buildDryRunEntry(String name, String task) {
        if (displayRolling) {
            System.out.println();
        } else {
            displayRolling = true;
        }
        System.out.println((Object)StringExtensionsKt.abbreviate$default("[DR] (" + name + ") " + task, this.getOutputWidth(), null, 2, null));
        System.out.println((Object)this.displaySeparator());
    }

    public final void printException(@NotNull AraraException exception) {
        String string;
        Intrinsics.checkNotNullParameter(exception, "exception");
        displayException = true;
        if (displayResult) {
            System.out.println();
        }
        if (displayLine && !this.isDryRunMode()) {
            String string2 = !this.isVerboseMode() ? StringsKt.padStart$default(LanguageController.getMessages().getINFO_LABEL_ON_ERROR(), this.getLongestMatch(), '\u0000', 2, null) : StringsKt.padStart(" " + LanguageController.getMessages().getINFO_LABEL_ON_ERROR(), this.getOutputWidth(), '-');
            System.out.println((Object)string2);
            System.out.println();
        }
        if ((string = exception.hasException() ? exception.getMessage() + " " + LanguageController.getMessages().getINFO_DISPLAY_EXCEPTION_MORE_DETAILS() : exception.getMessage()) == null) {
            string = "EXCEPTION PROVIDES NO MESSAGE";
        }
        String text2 = string;
        logger.error(() -> DisplayUtils.printException$lambda$5(text2));
        this.printWrapped(text2);
        if (exception.hasException()) {
            System.out.println();
            this.displayDetailsLine();
            Exception exception2 = exception.getException();
            Intrinsics.checkNotNull(exception2);
            String string3 = exception2.getMessage();
            Intrinsics.checkNotNull(string3);
            String details = string3;
            logger.error(() -> DisplayUtils.printException$lambda$6(details));
            this.printWrapped(details);
        }
    }

    private final String getResult(boolean value) {
        return value ? LanguageController.getMessages().getINFO_LABEL_ON_SUCCESS() : LanguageController.getMessages().getINFO_LABEL_ON_FAILURE();
    }

    public final void printWrapped(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        System.out.println((Object)StringExtensionsKt.wrap(text2, this.getOutputWidth()));
    }

    public final void printAuthors(@NotNull List<String> authors) {
        Intrinsics.checkNotNullParameter(authors, "authors");
        String line = authors.size() == 1 ? LanguageController.getMessages().getINFO_LABEL_AUTHOR() : LanguageController.getMessages().getINFO_LABEL_AUTHORS();
        String text2 = authors.isEmpty() ? LanguageController.getMessages().getINFO_LABEL_NO_AUTHORS() : CollectionsKt.joinToString$default(authors, ", ", null, null, 0, null, DisplayUtils::printAuthors$lambda$7, 30, null);
        this.printWrapped(line + " " + text2);
    }

    public final void printConditional(@NotNull DirectiveConditional conditional) {
        Intrinsics.checkNotNullParameter(conditional, "conditional");
        if (conditional.getType() != DirectiveConditionalType.NONE) {
            this.printWrapped(LanguageController.getMessages().getINFO_LABEL_CONDITIONAL() + " (" + conditional.getType() + ") " + conditional.getCondition());
        }
    }

    @NotNull
    public final String byteSizeToString$cli(long size2) {
        Object object;
        double conversionFactor = 1000.0;
        if ((double)size2 < conversionFactor) {
            object = size2 + " B";
        } else {
            int exp2 = (int)(Math.log(size2) / Math.log(conversionFactor));
            boolean bl = false;
            double baseSize = (double)size2 / Math.pow(conversionFactor, exp2);
            int ones = (int)baseSize;
            int tenths = (int)((baseSize - (double)ones) * (double)10);
            String[] stringArray = new String[]{String.valueOf(ones), String.valueOf(Session.INSTANCE.getUserInterfaceOptions().getLocale().getDecimalSeparator()), String.valueOf(tenths), String.valueOf("kMGTPE".charAt(exp2 - 1))};
            object = org.islandoftex.arara.core.utils.StringExtensionsKt.formatString("%s%s%s %sB", stringArray);
        }
        return object;
    }

    public final void printTime(double seconds) {
        if (displayLine || displayException) {
            System.out.println();
        }
        long secondDuration = DurationKt.toDuration(seconds, DurationUnit.SECONDS);
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[3];
        stringArray2[0] = String.valueOf(Duration.getInWholeSeconds-impl(secondDuration));
        stringArray2[1] = String.valueOf(Session.INSTANCE.getUserInterfaceOptions().getLocale().getDecimalSeparator());
        stringArray2[2] = String.valueOf(Duration.getInWholeMilliseconds-impl(Duration.minus-LRDsOJo(secondDuration, DurationKt.toDuration(Duration.getInWholeSeconds-impl(secondDuration), DurationUnit.SECONDS))));
        stringArray[0] = org.islandoftex.arara.core.utils.StringExtensionsKt.formatString("%s%s%s", stringArray2);
        String text2 = org.islandoftex.arara.core.utils.StringExtensionsKt.formatString(LanguageController.getMessages().getINFO_DISPLAY_EXECUTION_TIME(), stringArray);
        logger.info(() -> DisplayUtils.printTime$lambda$9(text2));
        this.printWrapped(text2);
    }

    private final void displayDetailsLine() {
        String string = StringsKt.padEnd(StringExtensionsKt.abbreviate$default(LanguageController.getMessages().getINFO_LABEL_ON_DETAILS() + " ", this.getOutputWidth(), null, 2, null), this.getOutputWidth(), '-');
        System.out.println((Object)string);
    }

    @NotNull
    public final String displayOutputSeparator(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return StringExtensionsKt.center(" " + message + " ", this.getOutputWidth(), '-');
    }

    @NotNull
    public final String displaySeparator() {
        return StringsKt.repeat("-", this.getOutputWidth());
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final int longestMatch_delegate$lambda$2() {
        void var3_3;
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{LanguageController.getMessages().getINFO_LABEL_ON_SUCCESS(), LanguageController.getMessages().getINFO_LABEL_ON_FAILURE(), LanguageController.getMessages().getINFO_LABEL_ON_ERROR()};
        Iterable $this$map$iv = CollectionsKt.listOf(stringArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.length());
        }
        Object t = CollectionsKt.maxOrNull((List)var3_3);
        Intrinsics.checkNotNull(t);
        return ((Number)t).intValue();
    }

    private static final Object printEntryResult$lambda$3(boolean $value) {
        return LanguageController.getMessages().getLOG_INFO_TASK_RESULT() + " " + INSTANCE.getResult($value);
    }

    private static final Object printEntry$lambda$4(String $task, String $name) {
        String[] stringArray = new String[]{$task, $name};
        return org.islandoftex.arara.core.utils.StringExtensionsKt.formatString(LanguageController.getMessages().getLOG_INFO_INTERPRET_TASK(), stringArray);
    }

    private static final Object printException$lambda$5(String $text) {
        return $text;
    }

    private static final Object printException$lambda$6(String $details) {
        return $details;
    }

    private static final CharSequence printAuthors$lambda$7(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final Object printTime$lambda$9(String $text) {
        return $text;
    }
}

