/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.common.QuorumX509Util;
import org.apache.zookeeper.common.SecretUtilsTest;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v2CRLBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.cert.ocsp.jcajce.JcaBasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.jcajce.JcaCertificateID;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.MiscPEMGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class QuorumSSLTest
extends QuorumPeerTestBase {
    private static final String SSL_QUORUM_ENABLED = "sslQuorum=true\n";
    private static final String PORT_UNIFICATION_ENABLED = "portUnification=true\n";
    private static final String PORT_UNIFICATION_DISABLED = "portUnification=false\n";
    private static final char[] PASSWORD = "testpass".toCharArray();
    private static final String HOSTNAME = "localhost";
    private QuorumX509Util quorumX509Util;
    private QuorumPeerTestBase.MainThread q1;
    private QuorumPeerTestBase.MainThread q2;
    private QuorumPeerTestBase.MainThread q3;
    private int clientPortQp1;
    private int clientPortQp2;
    private int clientPortQp3;
    private String tmpDir;
    private String quorumConfiguration;
    private String validKeystorePath;
    private String truststorePath;
    private KeyPair rootKeyPair;
    private X509Certificate rootCertificate;
    private KeyPair defaultKeyPair;
    private ContentSigner contentSigner;
    private Date certStartTime;
    private Date certEndTime;

    @BeforeEach
    public void setup() throws Exception {
        this.quorumX509Util = new QuorumX509Util();
        ClientBase.setupTestEnv();
        this.tmpDir = ClientBase.createTmpDir().getAbsolutePath();
        this.clientPortQp1 = PortAssignment.unique();
        this.clientPortQp2 = PortAssignment.unique();
        this.clientPortQp3 = PortAssignment.unique();
        this.validKeystorePath = this.tmpDir + "/valid.jks";
        this.truststorePath = this.tmpDir + "/truststore.jks";
        this.quorumConfiguration = this.generateQuorumConfiguration();
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.certStartTime = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.certStartTime);
        cal.add(1, 1);
        this.certEndTime = cal.getTime();
        this.rootKeyPair = this.createKeyPair();
        this.contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(this.rootKeyPair.getPrivate());
        this.rootCertificate = this.createSelfSignedCertifcate(this.rootKeyPair);
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, PASSWORD);
        trustStore.setCertificateEntry(this.rootCertificate.getSubjectDN().toString(), this.rootCertificate);
        FileOutputStream outputStream = new FileOutputStream(this.truststorePath);
        trustStore.store(outputStream, PASSWORD);
        outputStream.flush();
        outputStream.close();
        this.defaultKeyPair = this.createKeyPair();
        X509Certificate validCertificate = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), HOSTNAME, "127.0.0.1", null, null);
        this.writeKeystore(validCertificate, this.defaultKeyPair, this.validKeystorePath);
        this.setSSLSystemProperties();
    }

    private void writeKeystore(X509Certificate certificate, KeyPair entityKeyPair, String path) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, PASSWORD);
        keyStore.setKeyEntry("alias", entityKeyPair.getPrivate(), PASSWORD, new Certificate[]{certificate});
        FileOutputStream outputStream = new FileOutputStream(path);
        keyStore.store(outputStream, PASSWORD);
        outputStream.flush();
        outputStream.close();
    }

    private X509Certificate createSelfSignedCertifcate(KeyPair keyPair) throws Exception {
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, HOSTNAME);
        BigInteger serialNumber = new BigInteger(128, new Random());
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(nameBuilder.build(), serialNumber, this.certStartTime, this.certEndTime, nameBuilder.build(), keyPair.getPublic());
        X509v3CertificateBuilder certificateBuilder = jcaX509v3CertificateBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
        return new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(this.contentSigner));
    }

    private void buildCRL(X509Certificate x509Certificate, String crlPath) throws Exception {
        JcaX509v2CRLBuilder builder = new JcaX509v2CRLBuilder(x509Certificate.getIssuerX500Principal(), this.certStartTime);
        builder.addCRLEntry(x509Certificate.getSerialNumber(), this.certStartTime, 2);
        builder.setNextUpdate(this.certEndTime);
        builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(this.rootCertificate));
        builder.addExtension(Extension.cRLNumber, false, (ASN1Encodable)new CRLNumber(new BigInteger("1000")));
        X509CRLHolder cRLHolder = builder.build(this.contentSigner);
        PemWriter pemWriter = new PemWriter((Writer)new FileWriter(crlPath));
        pemWriter.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)cRLHolder));
        pemWriter.flush();
        pemWriter.close();
    }

    public X509Certificate buildEndEntityCert(KeyPair keyPair, X509Certificate caCert, PrivateKey caPrivateKey, String hostname, String ipAddress, String crlPath, Integer ocspPort) throws Exception {
        JcaX509CertificateHolder holder = new JcaX509CertificateHolder(caCert);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(caPrivateKey);
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
        if (hostname != null) {
            generalNames.add(new GeneralName(2, hostname));
        }
        if (ipAddress != null) {
            generalNames.add(new GeneralName(7, ipAddress));
        }
        SubjectPublicKeyInfo entityKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)PublicKeyFactory.createKey((byte[])keyPair.getPublic().getEncoded()));
        BcX509ExtensionUtils extensionUtils = new BcX509ExtensionUtils();
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(holder.getSubject(), new BigInteger(128, new Random()), this.certStartTime, this.certEndTime, new X500Name("CN=Test End Entity Certificate"), keyPair.getPublic());
        X509v3CertificateBuilder certificateBuilder = jcaX509v3CertificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtils.createAuthorityKeyIdentifier((X509CertificateHolder)holder)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extensionUtils.createSubjectKeyIdentifier(entityKeyInfo)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
        if (!generalNames.isEmpty()) {
            certificateBuilder.addExtension(Extension.subjectAlternativeName, true, (ASN1Encodable)new GeneralNames(generalNames.toArray(new GeneralName[0])));
        }
        if (crlPath != null) {
            DistributionPointName distPointOne = new DistributionPointName(new GeneralNames(new GeneralName(6, "file://" + crlPath)));
            certificateBuilder.addExtension(Extension.cRLDistributionPoints, false, (ASN1Encodable)new CRLDistPoint(new DistributionPoint[]{new DistributionPoint(distPointOne, null, null)}));
        }
        if (ocspPort != null) {
            certificateBuilder.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)new AuthorityInformationAccess(X509ObjectIdentifiers.ocspAccessMethod, new GeneralName(6, "http://" + hostname + ":" + ocspPort)));
        }
        return new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(signer));
    }

    private KeyPair createKeyPair() throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(4096);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        return keyPair;
    }

    private String generateQuorumConfiguration() {
        StringBuilder sb = new StringBuilder();
        int portQp1 = PortAssignment.unique();
        int portQp2 = PortAssignment.unique();
        int portQp3 = PortAssignment.unique();
        int portLe1 = PortAssignment.unique();
        int portLe2 = PortAssignment.unique();
        int portLe3 = PortAssignment.unique();
        sb.append(String.format("server.1=127.0.0.1:%d:%d;%d\n", portQp1, portLe1, this.clientPortQp1));
        sb.append(String.format("server.2=127.0.0.1:%d:%d;%d\n", portQp2, portLe2, this.clientPortQp2));
        sb.append(String.format("server.3=127.0.0.1:%d:%d;%d\n", portQp3, portLe3, this.clientPortQp3));
        return sb.toString();
    }

    private String generateMultiAddressQuorumConfiguration() {
        StringBuilder sb = new StringBuilder();
        int portQp1a = PortAssignment.unique();
        int portQp1b = PortAssignment.unique();
        int portQp2a = PortAssignment.unique();
        int portQp2b = PortAssignment.unique();
        int portQp3a = PortAssignment.unique();
        int portQp3b = PortAssignment.unique();
        int portLe1a = PortAssignment.unique();
        int portLe1b = PortAssignment.unique();
        int portLe2a = PortAssignment.unique();
        int portLe2b = PortAssignment.unique();
        int portLe3a = PortAssignment.unique();
        int portLe3b = PortAssignment.unique();
        sb.append(String.format("server.1=127.0.0.1:%d:%d|127.0.0.1:%d:%d;%d\n", portQp1a, portLe1a, portQp1b, portLe1b, this.clientPortQp1));
        sb.append(String.format("server.2=127.0.0.1:%d:%d|127.0.0.1:%d:%d;%d\n", portQp2a, portLe2a, portQp2b, portLe2b, this.clientPortQp2));
        sb.append(String.format("server.3=127.0.0.1:%d:%d|127.0.0.1:%d:%d;%d\n", portQp3a, portLe3a, portQp3b, portLe3b, this.clientPortQp3));
        return sb.toString();
    }

    public void setSSLSystemProperties() {
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        System.setProperty(this.quorumX509Util.getSslKeystoreLocationProperty(), this.validKeystorePath);
        System.setProperty(this.quorumX509Util.getSslKeystorePasswdProperty(), "testpass");
        System.setProperty(this.quorumX509Util.getSslTruststoreLocationProperty(), this.truststorePath);
        System.setProperty(this.quorumX509Util.getSslTruststorePasswdProperty(), "testpass");
    }

    @AfterEach
    public void cleanUp() throws Exception {
        System.clearProperty("zookeeper.multiAddress.enabled");
        this.clearSSLSystemProperties();
        if (this.q1 != null) {
            this.q1.shutdown();
        }
        if (this.q2 != null) {
            this.q2.shutdown();
        }
        if (this.q3 != null) {
            this.q3.shutdown();
        }
        Security.removeProvider("BC");
        this.quorumX509Util.close();
    }

    private void clearSSLSystemProperties() {
        System.clearProperty(this.quorumX509Util.getSslKeystoreLocationProperty());
        System.clearProperty(this.quorumX509Util.getSslKeystorePasswdProperty());
        System.clearProperty(this.quorumX509Util.getSslKeystorePasswdPathProperty());
        System.clearProperty(this.quorumX509Util.getSslTruststoreLocationProperty());
        System.clearProperty(this.quorumX509Util.getSslTruststorePasswdProperty());
        System.clearProperty(this.quorumX509Util.getSslTruststorePasswdPathProperty());
        System.clearProperty(this.quorumX509Util.getSslHostnameVerificationEnabledProperty());
        System.clearProperty(this.quorumX509Util.getSslOcspEnabledProperty());
        System.clearProperty(this.quorumX509Util.getSslCrlEnabledProperty());
        System.clearProperty(this.quorumX509Util.getCipherSuitesProperty());
        System.clearProperty(this.quorumX509Util.getSslProtocolProperty());
    }

    @TestBothFipsModes
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testQuorumSSL(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.clientPortQp1, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.clientPortQp2, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q1.start();
        this.q2.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        this.clearSSLSystemProperties();
        this.q3 = new QuorumPeerTestBase.MainThread(3, this.clientPortQp3, this.quorumConfiguration);
        this.q3.start();
        Assertions.assertFalse((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
    }

    @TestBothFipsModes
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testQuorumSSL_withPasswordFromFile(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        Path secretFile = SecretUtilsTest.createSecretFile(String.valueOf(PASSWORD));
        System.clearProperty(this.quorumX509Util.getSslKeystorePasswdProperty());
        System.setProperty(this.quorumX509Util.getSslKeystorePasswdPathProperty(), secretFile.toString());
        System.clearProperty(this.quorumX509Util.getSslTruststorePasswdProperty());
        System.setProperty(this.quorumX509Util.getSslTruststorePasswdPathProperty(), secretFile.toString());
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.clientPortQp1, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.clientPortQp2, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q3 = new QuorumPeerTestBase.MainThread(3, this.clientPortQp3, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q1.start();
        this.q2.start();
        this.q3.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
    }

    @TestBothFipsModes
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testQuorumSSLWithMultipleAddresses(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        System.setProperty("zookeeper.multiAddress.enabled", "true");
        this.quorumConfiguration = this.generateMultiAddressQuorumConfiguration();
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.clientPortQp1, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.clientPortQp2, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q1.start();
        this.q2.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        this.clearSSLSystemProperties();
        this.q3 = new QuorumPeerTestBase.MainThread(3, this.clientPortQp3, this.quorumConfiguration);
        this.q3.start();
        Assertions.assertFalse((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
    }

    @TestBothFipsModes
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testRollingUpgrade(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.clientPortQp1, this.quorumConfiguration);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.clientPortQp2, this.quorumConfiguration);
        this.q3 = new QuorumPeerTestBase.MainThread(3, this.clientPortQp3, this.quorumConfiguration);
        HashMap<Integer, QuorumPeerTestBase.MainThread> members = new HashMap<Integer, QuorumPeerTestBase.MainThread>();
        members.put(this.clientPortQp1, this.q1);
        members.put(this.clientPortQp2, this.q2);
        members.put(this.clientPortQp3, this.q3);
        for (QuorumPeerTestBase.MainThread member : members.values()) {
            member.start();
        }
        Iterator<Object> iterator = members.keySet().iterator();
        while (iterator.hasNext()) {
            int clientPort = (Integer)iterator.next();
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPort, ClientBase.CONNECTION_TIMEOUT));
        }
        this.setSSLSystemProperties();
        this.stopAppendConfigRestartAll(members, PORT_UNIFICATION_ENABLED);
        this.stopAppendConfigRestartAll(members, SSL_QUORUM_ENABLED);
        this.stopAppendConfigRestartAll(members, PORT_UNIFICATION_DISABLED);
    }

    private void stopAppendConfigRestartAll(Map<Integer, QuorumPeerTestBase.MainThread> members, String config) throws Exception {
        for (Map.Entry<Integer, QuorumPeerTestBase.MainThread> entry : members.entrySet()) {
            int clientPort = entry.getKey();
            QuorumPeerTestBase.MainThread member = entry.getValue();
            member.shutdown();
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + clientPort, ClientBase.CONNECTION_TIMEOUT));
            FileWriter fileWriter = new FileWriter(member.getConfFile(), true);
            fileWriter.write(config);
            fileWriter.flush();
            fileWriter.close();
            member.start();
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPort, ClientBase.CONNECTION_TIMEOUT));
        }
    }

    @TestNoFipsOnly
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testHostnameVerificationWithInvalidHostname(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        String badhostnameKeystorePath = this.tmpDir + "/badhost.jks";
        X509Certificate badHostCert = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), "bleepbloop", null, null, null);
        this.writeKeystore(badHostCert, this.defaultKeyPair, badhostnameKeystorePath);
        this.testHostnameVerification(badhostnameKeystorePath, false);
    }

    @TestNoFipsOnly
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testHostnameVerificationWithInvalidIPAddress(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        String badhostnameKeystorePath = this.tmpDir + "/badhost.jks";
        X509Certificate badHostCert = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), null, "140.211.11.105", null, null);
        this.writeKeystore(badHostCert, this.defaultKeyPair, badhostnameKeystorePath);
        this.testHostnameVerification(badhostnameKeystorePath, false);
    }

    @TestNoFipsOnly
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testHostnameVerificationWithInvalidIpAddressAndInvalidHostname(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        String badhostnameKeystorePath = this.tmpDir + "/badhost.jks";
        X509Certificate badHostCert = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), "bleepbloop", "140.211.11.105", null, null);
        this.writeKeystore(badHostCert, this.defaultKeyPair, badhostnameKeystorePath);
        this.testHostnameVerification(badhostnameKeystorePath, false);
    }

    @TestNoFipsOnly
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testHostnameVerificationForInvalidMultiAddressServerConfig(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        System.setProperty("zookeeper.multiAddress.enabled", "true");
        this.quorumConfiguration = this.generateMultiAddressQuorumConfiguration();
        String badhostnameKeystorePath = this.tmpDir + "/badhost.jks";
        X509Certificate badHostCert = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), "bleepbloop", "140.211.11.105", null, null);
        this.writeKeystore(badHostCert, this.defaultKeyPair, badhostnameKeystorePath);
        this.testHostnameVerification(badhostnameKeystorePath, false);
    }

    @TestNoFipsOnly
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testHostnameVerificationWithInvalidIpAddressAndValidHostname(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        String badhostnameKeystorePath = this.tmpDir + "/badhost.jks";
        X509Certificate badHostCert = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), HOSTNAME, "140.211.11.105", null, null);
        this.writeKeystore(badHostCert, this.defaultKeyPair, badhostnameKeystorePath);
        this.testHostnameVerification(badhostnameKeystorePath, true);
    }

    @TestNoFipsOnly
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testHostnameVerificationWithValidIpAddressAndInvalidHostname(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        String badhostnameKeystorePath = this.tmpDir + "/badhost.jks";
        X509Certificate badHostCert = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), "bleepbloop", "127.0.0.1", null, null);
        this.writeKeystore(badHostCert, this.defaultKeyPair, badhostnameKeystorePath);
        this.testHostnameVerification(badhostnameKeystorePath, true);
    }

    private void testHostnameVerification(String keystorePath, boolean expectSuccess) throws Exception {
        System.setProperty(this.quorumX509Util.getSslHostnameVerificationEnabledProperty(), "false");
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.clientPortQp1, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.clientPortQp2, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q1.start();
        this.q2.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        System.setProperty(this.quorumX509Util.getSslKeystoreLocationProperty(), keystorePath);
        this.q3 = new QuorumPeerTestBase.MainThread(3, this.clientPortQp3, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q3.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
        this.q1.shutdown();
        this.q2.shutdown();
        this.q3.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
        this.setSSLSystemProperties();
        System.clearProperty(this.quorumX509Util.getSslHostnameVerificationEnabledProperty());
        this.q1.start();
        this.q2.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        System.setProperty(this.quorumX509Util.getSslKeystoreLocationProperty(), keystorePath);
        this.q3.start();
        Assertions.assertEquals((Object)expectSuccess, (Object)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
    }

    @TestBothFipsModes
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testCertificateRevocationList(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.clientPortQp1, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.clientPortQp2, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q1.start();
        this.q2.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        String revokedInCRLKeystorePath = this.tmpDir + "/crl_revoked.jks";
        String crlPath = this.tmpDir + "/crl.pem";
        X509Certificate revokedInCRLCert = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), HOSTNAME, null, crlPath, null);
        this.writeKeystore(revokedInCRLCert, this.defaultKeyPair, revokedInCRLKeystorePath);
        this.buildCRL(revokedInCRLCert, crlPath);
        System.setProperty(this.quorumX509Util.getSslKeystoreLocationProperty(), revokedInCRLKeystorePath);
        this.q3 = new QuorumPeerTestBase.MainThread(3, this.clientPortQp3, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q3.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
        this.q1.shutdown();
        this.q2.shutdown();
        this.q3.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
        this.setSSLSystemProperties();
        System.setProperty(this.quorumX509Util.getSslCrlEnabledProperty(), "true");
        X509Certificate validCertificate = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), HOSTNAME, null, crlPath, null);
        this.writeKeystore(validCertificate, this.defaultKeyPair, this.validKeystorePath);
        this.q1.start();
        this.q2.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        System.setProperty(this.quorumX509Util.getSslKeystoreLocationProperty(), revokedInCRLKeystorePath);
        this.q3.start();
        Assertions.assertFalse((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestBothFipsModes
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testOCSP(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        Integer ocspPort = PortAssignment.unique();
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.clientPortQp1, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.clientPortQp2, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q1.start();
        this.q2.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        String revokedInOCSPKeystorePath = this.tmpDir + "/ocsp_revoked.jks";
        X509Certificate revokedInOCSPCert = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), HOSTNAME, null, null, ocspPort);
        this.writeKeystore(revokedInOCSPCert, this.defaultKeyPair, revokedInOCSPKeystorePath);
        HttpServer ocspServer = HttpServer.create(new InetSocketAddress(ocspPort), 0);
        try {
            ocspServer.createContext("/", new OCSPHandler(revokedInOCSPCert));
            ocspServer.start();
            System.setProperty(this.quorumX509Util.getSslKeystoreLocationProperty(), revokedInOCSPKeystorePath);
            this.q3 = new QuorumPeerTestBase.MainThread(3, this.clientPortQp3, this.quorumConfiguration, SSL_QUORUM_ENABLED);
            this.q3.start();
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
            this.q1.shutdown();
            this.q2.shutdown();
            this.q3.shutdown();
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
            this.setSSLSystemProperties();
            System.setProperty(this.quorumX509Util.getSslOcspEnabledProperty(), "true");
            X509Certificate validCertificate = this.buildEndEntityCert(this.defaultKeyPair, this.rootCertificate, this.rootKeyPair.getPrivate(), HOSTNAME, null, null, ocspPort);
            this.writeKeystore(validCertificate, this.defaultKeyPair, this.validKeystorePath);
            this.q1.start();
            this.q2.start();
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
            System.setProperty(this.quorumX509Util.getSslKeystoreLocationProperty(), revokedInOCSPKeystorePath);
            this.q3.start();
            Assertions.assertFalse((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
        }
        finally {
            ocspServer.stop(0);
        }
    }

    @TestBothFipsModes
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testCipherSuites(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        SSLServerSocketFactory ssf = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        ArrayList<String> defaultCiphers = new ArrayList<String>();
        for (String cipher : ssf.getDefaultCipherSuites()) {
            if (cipher.matches(".*EMPTY.*") || !cipher.startsWith("TLS") || !cipher.contains("RSA")) continue;
            defaultCiphers.add(cipher);
        }
        if (defaultCiphers.size() < 2) {
            Assertions.fail((String)"JDK has to support at least 2 valid (RSA) cipher suites for this test to run");
        }
        String suitesOfEnsemble = String.join((CharSequence)",", defaultCiphers.subList(1, defaultCiphers.size()));
        System.setProperty(this.quorumX509Util.getCipherSuitesProperty(), suitesOfEnsemble);
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.clientPortQp1, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.clientPortQp2, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q1.start();
        this.q2.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        String suiteOfClient = (String)defaultCiphers.get(0);
        System.setProperty(this.quorumX509Util.getCipherSuitesProperty(), suiteOfClient);
        this.q3 = new QuorumPeerTestBase.MainThread(3, this.clientPortQp3, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q3.start();
        Assertions.assertFalse((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
    }

    @TestBothFipsModes
    @Timeout(value=5L, unit=TimeUnit.MINUTES)
    public void testProtocolVersion(boolean fipsEnabled) throws Exception {
        System.setProperty(this.quorumX509Util.getFipsModeProperty(), Boolean.toString(fipsEnabled));
        System.setProperty(this.quorumX509Util.getSslProtocolProperty(), "TLSv1.2");
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.clientPortQp1, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.clientPortQp2, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q1.start();
        this.q2.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp1, ClientBase.CONNECTION_TIMEOUT));
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp2, ClientBase.CONNECTION_TIMEOUT));
        System.setProperty(this.quorumX509Util.getSslProtocolProperty(), "TLSv1.1");
        this.q3 = new QuorumPeerTestBase.MainThread(3, this.clientPortQp3, this.quorumConfiguration, SSL_QUORUM_ENABLED);
        this.q3.start();
        Assertions.assertFalse((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPortQp3, ClientBase.CONNECTION_TIMEOUT));
    }

    private class OCSPHandler
    implements HttpHandler {
        private X509Certificate revokedCert;

        public OCSPHandler(X509Certificate revokedCert) {
            this.revokedCert = revokedCert;
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            byte[] responseBytes;
            try {
                String uri = httpExchange.getRequestURI().toString();
                QuorumPeerTestBase.LOG.info("OCSP request: {} {}", (Object)httpExchange.getRequestMethod(), (Object)uri);
                httpExchange.getRequestHeaders().entrySet().forEach(e -> QuorumPeerTestBase.LOG.info("OCSP request header: {} {}", e.getKey(), e.getValue()));
                InputStream request = httpExchange.getRequestBody();
                byte[] requestBytes = new byte[10000];
                int len = request.read(requestBytes);
                QuorumPeerTestBase.LOG.info("OCSP request size {}", (Object)len);
                if (len < 0) {
                    String removedUriEncoding = URLDecoder.decode(uri.substring(1), "utf-8");
                    QuorumPeerTestBase.LOG.info("OCSP request from URI no encoding {}", (Object)removedUriEncoding);
                    requestBytes = Base64.getDecoder().decode(removedUriEncoding);
                }
                OCSPReq ocspRequest = new OCSPReq(requestBytes);
                Object[] requestList = ocspRequest.getRequestList();
                QuorumPeerTestBase.LOG.info("requestList {}", (Object)Arrays.toString(requestList));
                DigestCalculator digestCalculator = new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1);
                JcaBasicOCSPRespBuilder responseBuilder = new JcaBasicOCSPRespBuilder(QuorumSSLTest.this.rootKeyPair.getPublic(), digestCalculator);
                for (Object req : requestList) {
                    CertificateID certId = req.getCertID();
                    JcaCertificateID revokedCertId = new JcaCertificateID(digestCalculator, QuorumSSLTest.this.rootCertificate, this.revokedCert.getSerialNumber());
                    Object certificateStatus = revokedCertId.equals((Object)certId) ? new UnknownStatus() : CertificateStatus.GOOD;
                    QuorumPeerTestBase.LOG.info("addResponse {} {}", (Object)certId, certificateStatus);
                    responseBuilder.addResponse(certId, certificateStatus, null);
                }
                X509CertificateHolder[] chain = new X509CertificateHolder[]{new JcaX509CertificateHolder(QuorumSSLTest.this.rootCertificate)};
                ContentSigner signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(QuorumSSLTest.this.rootKeyPair.getPrivate());
                BasicOCSPResp ocspResponse = responseBuilder.build(signer, chain, Calendar.getInstance().getTime());
                QuorumPeerTestBase.LOG.info("response {}", (Object)ocspResponse);
                responseBytes = new OCSPRespBuilder().build(0, (Object)ocspResponse).getEncoded();
                QuorumPeerTestBase.LOG.error("OCSP server response OK");
            }
            catch (CertificateEncodingException | OCSPException | OperatorException exception) {
                QuorumPeerTestBase.LOG.error("Internal OCSP server error", exception);
                responseBytes = new OCSPResp(new OCSPResponse(new OCSPResponseStatus(2), null)).getEncoded();
            }
            catch (Throwable exception) {
                QuorumPeerTestBase.LOG.error("Internal OCSP server error", exception);
                responseBytes = new OCSPResp(new OCSPResponse(new OCSPResponseStatus(2), null)).getEncoded();
            }
            Headers rh = httpExchange.getResponseHeaders();
            rh.set("Content-Type", "application/ocsp-response");
            httpExchange.sendResponseHeaders(200, responseBytes.length);
            OutputStream os = httpExchange.getResponseBody();
            os.write(responseBytes);
            os.close();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @ParameterizedTest(name="fipsEnabled = {0}")
    @ValueSource(booleans={false})
    private static @interface TestNoFipsOnly {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @ParameterizedTest(name="fipsEnabled = {0}")
    @ValueSource(booleans={false, true})
    private static @interface TestBothFipsModes {
    }
}

