/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.openjdk.source.doctree.DocCommentTree;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.CommentHelper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class VisibleMemberMap {
    private boolean noVisibleMembers = true;
    public static final String STARTLEVEL = "start";
    private static final Pattern GETTERSETTERPATTERN = Pattern.compile("[sg]et\\p{Upper}.*");
    private final Set<TypeElement> visibleClasses;
    private final Map<Object, Map<Element, String>> memberNameMap = new HashMap<Object, Map<Element, String>>();
    private final Map<TypeElement, ClassMembers> classMap = new HashMap<TypeElement, ClassMembers>();
    private final TypeElement typeElement;
    private final Kind kind;
    private final Configuration configuration;
    private final Utils utils;
    private final Comparator<Element> comparator;
    private final Map<TypeElement, List<Element>> propertiesCache;
    private final Map<Element, Element> classPropertiesMap;
    private final Map<Element, GetterSetter> getterSetterMap;

    public VisibleMemberMap(TypeElement typeElement, Kind kind, Configuration configuration) {
        this.typeElement = typeElement;
        this.kind = kind;
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.propertiesCache = configuration.propertiesCache;
        this.classPropertiesMap = configuration.classPropertiesMap;
        this.getterSetterMap = configuration.getterSetterMap;
        this.comparator = this.utils.makeGeneralPurposeComparator();
        this.visibleClasses = new LinkedHashSet<TypeElement>();
        new ClassMembers(typeElement, STARTLEVEL).build();
    }

    public SortedSet<TypeElement> getVisibleClasses() {
        TreeSet<Element> vClasses = new TreeSet<Element>(this.comparator);
        vClasses.addAll(this.visibleClasses);
        return vClasses;
    }

    public Element getPropertyMemberDoc(Element element) {
        return this.classPropertiesMap.get(element);
    }

    public Element getGetterForProperty(Element propertyMethod) {
        return this.getterSetterMap.get(propertyMethod).getGetter();
    }

    public Element getSetterForProperty(Element propertyMethod) {
        return this.getterSetterMap.get(propertyMethod).getSetter();
    }

    private List<Element> getInheritedPackagePrivateMethods() {
        ArrayList<Element> results = new ArrayList<Element>();
        for (TypeElement currentClass : this.visibleClasses) {
            if (currentClass == this.typeElement || !this.utils.isPackagePrivate(currentClass) || this.utils.isLinkable(currentClass)) continue;
            results.addAll(this.classMap.get(currentClass).members);
        }
        return results;
    }

    public SortedSet<Element> getLeafClassMembers() {
        SortedSet<Element> result = this.getMembersFor(this.typeElement);
        result.addAll(this.getInheritedPackagePrivateMethods());
        return result;
    }

    public Set<Element> getLeafClassMembersSourceOrder() {
        LinkedHashSet<Element> result = new LinkedHashSet<Element>(this.classMap.get(this.typeElement).members);
        result.addAll(this.getInheritedPackagePrivateMethods());
        return result;
    }

    public SortedSet<Element> getMembersFor(TypeElement typeElement) {
        return this.asSortedSet(this.classMap.get(typeElement).members);
    }

    public boolean hasMembersFor(TypeElement typeElement) {
        return !this.classMap.get(typeElement).members.isEmpty();
    }

    private SortedSet<Element> asSortedSet(Collection<Element> in) {
        if (in == null) {
            return Collections.emptySortedSet();
        }
        TreeSet<Element> out = new TreeSet<Element>(this.comparator);
        out.addAll(in);
        return out;
    }

    private void fillMemberLevelMap(List<? extends Element> list, String level) {
        for (Element element : list) {
            Object key = this.getMemberKey(element);
            Map<Element, String> memberLevelMap = this.memberNameMap.get(key);
            if (memberLevelMap == null) {
                memberLevelMap = new HashMap<Element, String>();
                this.memberNameMap.put(key, memberLevelMap);
            }
            memberLevelMap.put(element, level);
        }
    }

    private void purgeMemberLevelMap(Iterable<? extends Element> list, String level) {
        for (Element element : list) {
            Object key = this.getMemberKey(element);
            Map<Element, String> memberLevelMap = this.memberNameMap.get(key);
            if (memberLevelMap == null || !level.equals(memberLevelMap.get(element))) continue;
            memberLevelMap.remove(element);
        }
    }

    public boolean noVisibleMembers() {
        return this.noVisibleMembers;
    }

    private ClassMember getClassMember(ExecutableElement member) {
        for (Object key : this.memberNameMap.keySet()) {
            if (key instanceof String || !((ClassMember)key).isEqual(member)) continue;
            return (ClassMember)key;
        }
        return new ClassMember(member);
    }

    private Object getMemberKey(Element element) {
        if (this.utils.isConstructor(element)) {
            return this.utils.getSimpleName(element) + this.utils.flatSignature((ExecutableElement)element);
        }
        if (this.utils.isMethod(element)) {
            return this.getClassMember((ExecutableElement)element);
        }
        if (this.utils.isField(element) || this.utils.isEnumConstant(element) || this.utils.isAnnotationType(element)) {
            return this.utils.getSimpleName(element);
        }
        String classOrIntName = this.utils.getSimpleName(element);
        classOrIntName = classOrIntName.indexOf(46) != 0 ? classOrIntName.substring(classOrIntName.lastIndexOf(46)) : classOrIntName;
        return "clint" + classOrIntName;
    }

    public class GetterSetter {
        private final Element getter;
        private final Element setter;

        public GetterSetter(Element getter, Element setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public Element getGetter() {
            return this.getter;
        }

        public Element getSetter() {
            return this.setter;
        }
    }

    private class ClassMembers {
        private final TypeElement typeElement;
        private Set<Element> members = new LinkedHashSet<Element>();
        private final String level;

        private ClassMembers(TypeElement mappingClass, String level) {
            this.typeElement = mappingClass;
            this.level = level;
            if (VisibleMemberMap.this.classMap.containsKey(mappingClass) && level.startsWith(((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)mappingClass)).level)) {
                VisibleMemberMap.this.purgeMemberLevelMap(this.getClassMembers(mappingClass, false), ((ClassMembers)((VisibleMemberMap)VisibleMemberMap.this).classMap.get((Object)mappingClass)).level);
                VisibleMemberMap.this.classMap.remove(mappingClass);
                VisibleMemberMap.this.visibleClasses.remove(mappingClass);
            }
            if (!VisibleMemberMap.this.classMap.containsKey(mappingClass)) {
                VisibleMemberMap.this.classMap.put(mappingClass, this);
                VisibleMemberMap.this.visibleClasses.add(mappingClass);
            }
        }

        private void build() {
            if (VisibleMemberMap.this.kind == Kind.CONSTRUCTORS) {
                this.addMembers(this.typeElement);
            } else {
                this.mapClass();
            }
        }

        private void mapClass() {
            TypeElement superclass;
            this.addMembers(this.typeElement);
            List<? extends TypeMirror> interfaces = this.typeElement.getInterfaces();
            for (TypeMirror typeMirror : interfaces) {
                String locallevel = this.level + 1;
                ClassMembers cm = new ClassMembers(VisibleMemberMap.this.utils.asTypeElement(typeMirror), locallevel);
                cm.mapClass();
            }
            if (VisibleMemberMap.this.utils.isClass(this.typeElement) && (superclass = VisibleMemberMap.this.utils.getSuperClass(this.typeElement)) != null && !this.typeElement.equals(superclass)) {
                ClassMembers classMembers = new ClassMembers(superclass, this.level + "c");
                classMembers.mapClass();
            }
        }

        private void addMembers(TypeElement fromClass) {
            List<? extends Element> classMembers = this.getClassMembers(fromClass, true);
            ArrayList<Element> incllist = new ArrayList<Element>();
            for (Element element : classMembers) {
                if (this.found(this.members, element) || !this.memberIsVisible(element) || this.isOverridden(element, this.level) || this.isTreatedAsPrivate(element)) continue;
                incllist.add(element);
            }
            if (!incllist.isEmpty()) {
                VisibleMemberMap.this.noVisibleMembers = false;
            }
            this.members.addAll(incllist);
            VisibleMemberMap.this.fillMemberLevelMap(this.getClassMembers(fromClass, false), this.level);
        }

        private boolean isTreatedAsPrivate(Element pgmelem) {
            if (!((VisibleMemberMap)VisibleMemberMap.this).configuration.javafx) {
                return false;
            }
            List<? extends DocTree> aspTags = VisibleMemberMap.this.utils.getBlockTags(pgmelem, "@treatAsPrivate");
            boolean result = aspTags != null && !aspTags.isEmpty();
            return result;
        }

        private boolean memberIsVisible(Element element) {
            if (VisibleMemberMap.this.utils.getEnclosingTypeElement(element).equals(VisibleMemberMap.this.typeElement)) {
                return true;
            }
            if (VisibleMemberMap.this.utils.isPrivate(element)) {
                return false;
            }
            if (VisibleMemberMap.this.utils.isPackagePrivate(element)) {
                return VisibleMemberMap.this.utils.containingPackage(element).equals(VisibleMemberMap.this.utils.containingPackage(VisibleMemberMap.this.typeElement));
            }
            return true;
        }

        private List<? extends Element> getClassMembers(TypeElement te, boolean filter) {
            List<Object> list;
            if (VisibleMemberMap.this.utils.isEnum(te) && VisibleMemberMap.this.kind == Kind.CONSTRUCTORS) {
                return Collections.emptyList();
            }
            switch (VisibleMemberMap.this.kind) {
                case ANNOTATION_TYPE_FIELDS: {
                    list = filter ? VisibleMemberMap.this.utils.getAnnotationFields(te) : VisibleMemberMap.this.utils.getAnnotationFieldsUnfiltered(te);
                    break;
                }
                case ANNOTATION_TYPE_MEMBER_OPTIONAL: {
                    list = VisibleMemberMap.this.utils.isAnnotationType(te) ? this.filterAnnotations(te, false) : Collections.emptyList();
                    break;
                }
                case ANNOTATION_TYPE_MEMBER_REQUIRED: {
                    list = VisibleMemberMap.this.utils.isAnnotationType(te) ? this.filterAnnotations(te, true) : Collections.emptyList();
                    break;
                }
                case INNER_CLASSES: {
                    List<TypeElement> xlist = filter ? VisibleMemberMap.this.utils.getInnerClasses(te) : VisibleMemberMap.this.utils.getInnerClassesUnfiltered(te);
                    list = new ArrayList<TypeElement>(xlist);
                    break;
                }
                case ENUM_CONSTANTS: {
                    list = VisibleMemberMap.this.utils.getEnumConstants(te);
                    break;
                }
                case FIELDS: {
                    if (filter) {
                        list = VisibleMemberMap.this.utils.isAnnotationType(te) ? VisibleMemberMap.this.utils.getAnnotationFields(te) : VisibleMemberMap.this.utils.getFields(te);
                        break;
                    }
                    list = VisibleMemberMap.this.utils.isAnnotationType(te) ? VisibleMemberMap.this.utils.getAnnotationFieldsUnfiltered(te) : VisibleMemberMap.this.utils.getFieldsUnfiltered(te);
                    break;
                }
                case CONSTRUCTORS: {
                    list = VisibleMemberMap.this.utils.getConstructors(te);
                    break;
                }
                case METHODS: {
                    list = filter ? VisibleMemberMap.this.utils.getMethods(te) : VisibleMemberMap.this.utils.getMethodsUnfiltered(te);
                    this.checkOnPropertiesTags(list);
                    break;
                }
                case PROPERTIES: {
                    list = this.properties(te, filter);
                    break;
                }
                default: {
                    list = Collections.emptyList();
                }
            }
            if (((VisibleMemberMap)VisibleMemberMap.this).configuration.nodeprecated) {
                return VisibleMemberMap.this.utils.excludeDeprecatedMembers(list);
            }
            return list;
        }

        private List<Element> filterAnnotations(TypeElement typeElement, boolean required) {
            List<Element> members = VisibleMemberMap.this.utils.getAnnotationMethods(typeElement);
            ArrayList<Element> targetMembers = new ArrayList<Element>();
            for (Element member : members) {
                ExecutableElement ee = (ExecutableElement)member;
                if ((!required || ee.getDefaultValue() != null) && (required || ee.getDefaultValue() == null)) continue;
                targetMembers.add(member);
            }
            return targetMembers;
        }

        private boolean found(Iterable<Element> list, Element elem) {
            for (Element pgmelem : list) {
                if (!VisibleMemberMap.this.utils.matches(pgmelem, elem)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverridden(Element element, String level) {
            Object key = VisibleMemberMap.this.getMemberKey(element);
            Map memberLevelMap = (Map)VisibleMemberMap.this.memberNameMap.get(key);
            if (memberLevelMap == null) {
                return false;
            }
            for (String mappedlevel : memberLevelMap.values()) {
                if (!mappedlevel.equals(VisibleMemberMap.STARTLEVEL) && (!level.startsWith(mappedlevel) || level.equals(mappedlevel))) continue;
                return true;
            }
            return false;
        }

        private List<Element> properties(TypeElement typeElement, boolean filter) {
            List<ExecutableElement> allMethods = filter ? VisibleMemberMap.this.utils.getMethods(typeElement) : VisibleMemberMap.this.utils.getMethodsUnfiltered(typeElement);
            List<VariableElement> allFields = VisibleMemberMap.this.utils.getFieldsUnfiltered(typeElement);
            if (VisibleMemberMap.this.propertiesCache.containsKey(typeElement)) {
                return (List)VisibleMemberMap.this.propertiesCache.get(typeElement);
            }
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element element : allMethods) {
                ExecutableElement ee = (ExecutableElement)element;
                if (!this.isPropertyMethod(ee)) continue;
                ExecutableElement getter = this.getterForField(allMethods, ee);
                ExecutableElement setter = this.setterForField(allMethods, ee);
                VariableElement field = this.fieldForProperty(allFields, ee);
                this.addToPropertiesMap(setter, getter, ee, field);
                VisibleMemberMap.this.getterSetterMap.put(element, new GetterSetter(getter, setter));
                result.add(ee);
            }
            VisibleMemberMap.this.propertiesCache.put(typeElement, result);
            return result;
        }

        private void addToPropertiesMap(ExecutableElement setter, ExecutableElement getter, ExecutableElement propertyMethod, VariableElement field) {
            if (field == null || VisibleMemberMap.this.utils.getDocCommentTree(field) == null) {
                this.addToPropertiesMap(setter, propertyMethod);
                this.addToPropertiesMap(getter, propertyMethod);
                this.addToPropertiesMap(propertyMethod, propertyMethod);
            } else {
                this.addToPropertiesMap(getter, field);
                this.addToPropertiesMap(setter, field);
                this.addToPropertiesMap(propertyMethod, field);
            }
        }

        private void addToPropertiesMap(Element propertyMethod, Element commentSource) {
            if (null == propertyMethod || null == commentSource) {
                return;
            }
            DocCommentTree docTree = VisibleMemberMap.this.utils.getDocCommentTree(propertyMethod);
            if (docTree == null || propertyMethod.equals(commentSource)) {
                VisibleMemberMap.this.classPropertiesMap.put(propertyMethod, commentSource);
            }
        }

        private ExecutableElement getterForField(List<ExecutableElement> methods, ExecutableElement propertyMethod) {
            String propertyMethodName = VisibleMemberMap.this.utils.getSimpleName(propertyMethod);
            String fieldName = propertyMethodName.substring(0, propertyMethodName.lastIndexOf("Property"));
            String fieldNameUppercased = "" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String fieldTypeName = propertyMethod.getReturnType().toString();
            String getterNamePattern = "boolean".equals(fieldTypeName) || fieldTypeName.endsWith("BooleanProperty") ? "(is|get)" + fieldNameUppercased : "get" + fieldNameUppercased;
            for (ExecutableElement method : methods) {
                if (!Pattern.matches(getterNamePattern, VisibleMemberMap.this.utils.getSimpleName(method)) || (!method.getParameters().isEmpty() || !VisibleMemberMap.this.utils.isPublic(method)) && !VisibleMemberMap.this.utils.isProtected(method)) continue;
                return method;
            }
            return null;
        }

        private ExecutableElement setterForField(List<ExecutableElement> methods, ExecutableElement propertyMethod) {
            String propertyMethodName = VisibleMemberMap.this.utils.getSimpleName(propertyMethod);
            String fieldName = propertyMethodName.substring(0, propertyMethodName.lastIndexOf("Property"));
            String fieldNameUppercased = "" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String setter = "set" + fieldNameUppercased;
            for (ExecutableElement method : methods) {
                if (!setter.equals(VisibleMemberMap.this.utils.getSimpleName(method)) || method.getParameters().size() != 1 || method.getReturnType().getKind() != TypeKind.VOID || !VisibleMemberMap.this.utils.isPublic(method) && !VisibleMemberMap.this.utils.isProtected(method)) continue;
                return method;
            }
            return null;
        }

        private VariableElement fieldForProperty(List<VariableElement> fields, ExecutableElement property) {
            for (VariableElement field : fields) {
                String fieldName = VisibleMemberMap.this.utils.getSimpleName(field);
                String propertyName = fieldName + "Property";
                if (!propertyName.equals(VisibleMemberMap.this.utils.getSimpleName(property))) continue;
                return field;
            }
            return null;
        }

        private boolean isPropertyMethod(ExecutableElement method) {
            if (!((VisibleMemberMap)VisibleMemberMap.this).configuration.javafx) {
                return false;
            }
            if (!VisibleMemberMap.this.utils.getSimpleName(method).endsWith("Property")) {
                return false;
            }
            if (!this.memberIsVisible(method)) {
                return false;
            }
            if (GETTERSETTERPATTERN.matcher(VisibleMemberMap.this.utils.getSimpleName(method)).matches()) {
                return false;
            }
            if (!method.getTypeParameters().isEmpty()) {
                return false;
            }
            return method.getParameters().isEmpty() && method.getReturnType().getKind() != TypeKind.VOID;
        }

        private void checkOnPropertiesTags(List<? extends Element> members) {
            block0: for (Element element : members) {
                ExecutableElement ee = (ExecutableElement)element;
                if (!VisibleMemberMap.this.utils.isIncluded(ee)) continue;
                CommentHelper ch = VisibleMemberMap.this.utils.getCommentHelper(ee);
                for (DocTree docTree : VisibleMemberMap.this.utils.getBlockTags(ee)) {
                    String tagName = ch.getTagName(docTree);
                    if (!tagName.equals("@propertySetter") && !tagName.equals("@propertyGetter") && !tagName.equals("@propertyDescription")) continue;
                    if (this.isPropertyGetterOrSetter(members, ee)) continue block0;
                    ((VisibleMemberMap)VisibleMemberMap.this).configuration.message.warning(ch.getDocTreePath(docTree), "doclet.javafx_tag_misuse", new Object[0]);
                    continue block0;
                }
            }
        }

        private boolean isPropertyGetterOrSetter(List<? extends Element> members, ExecutableElement method) {
            String propertyName = VisibleMemberMap.this.utils.propertyName(method);
            if (!propertyName.isEmpty()) {
                String propertyMethodName = propertyName + "Property";
                for (Element element : members) {
                    if (!VisibleMemberMap.this.utils.getSimpleName(element).equals(propertyMethodName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class ClassMember {
        private Set<Element> members = new HashSet<Element>();

        public ClassMember(Element element) {
            this.members.add(element);
        }

        public boolean isEqual(ExecutableElement member) {
            for (Element element : this.members) {
                if (!VisibleMemberMap.this.utils.executableMembersEqual(member, (ExecutableElement)element)) continue;
                this.members.add(member);
                return true;
            }
            return false;
        }
    }

    public static enum Kind {
        INNER_CLASSES,
        ENUM_CONSTANTS,
        FIELDS,
        CONSTRUCTORS,
        METHODS,
        ANNOTATION_TYPE_FIELDS,
        ANNOTATION_TYPE_MEMBER_OPTIONAL,
        ANNOTATION_TYPE_MEMBER_REQUIRED,
        PROPERTIES;

        public static final EnumSet<Kind> summarySet;
        public static final EnumSet<Kind> detailSet;

        public static String getNavLinkLabels(Kind kind) {
            switch (kind) {
                case INNER_CLASSES: {
                    return "doclet.navNested";
                }
                case ENUM_CONSTANTS: {
                    return "doclet.navEnum";
                }
                case FIELDS: {
                    return "doclet.navField";
                }
                case CONSTRUCTORS: {
                    return "doclet.navConstructor";
                }
                case METHODS: {
                    return "doclet.navMethod";
                }
            }
            throw new AssertionError((Object)("unknown kind:" + (Object)((Object)kind)));
        }

        static {
            summarySet = EnumSet.range(INNER_CLASSES, METHODS);
            detailSet = EnumSet.range(ENUM_CONSTANTS, METHODS);
        }
    }
}

