/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.RateLimiter;
import com.twitter.util.Promise;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.ServiceUnavailableException;
import org.apache.distributedlog.exceptions.StreamUnavailableException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.service.config.StreamConfigProvider;
import org.apache.distributedlog.service.stream.Stream;
import org.apache.distributedlog.service.stream.StreamFactory;
import org.apache.distributedlog.service.stream.StreamManager;
import org.apache.distributedlog.service.streamset.Partition;
import org.apache.distributedlog.service.streamset.PartitionMap;
import org.apache.distributedlog.service.streamset.StreamPartitionConverter;
import org.apache.distributedlog.util.ConfUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamManagerImpl
implements StreamManager {
    private static final Logger logger = LoggerFactory.getLogger(StreamManagerImpl.class);
    private final ConcurrentHashMap<String, Stream> streams = new ConcurrentHashMap();
    private final AtomicInteger numCached = new AtomicInteger(0);
    private final ConcurrentHashMap<String, Stream> acquiredStreams = new ConcurrentHashMap();
    private final AtomicInteger numAcquired = new AtomicInteger(0);
    private final StreamPartitionConverter partitionConverter;
    private final PartitionMap cachedPartitions = new PartitionMap();
    private final PartitionMap acquiredPartitions = new PartitionMap();
    final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private final ScheduledExecutorService executorService;
    private final DistributedLogConfiguration dlConfig;
    private final StreamConfigProvider streamConfigProvider;
    private final String clientId;
    private boolean closed = false;
    private final StreamFactory streamFactory;
    private final Namespace dlNamespace;

    public StreamManagerImpl(String clientId, DistributedLogConfiguration dlConfig, ScheduledExecutorService executorService, StreamFactory streamFactory, StreamPartitionConverter partitionConverter, StreamConfigProvider streamConfigProvider, Namespace dlNamespace) {
        this.clientId = clientId;
        this.executorService = executorService;
        this.streamFactory = streamFactory;
        this.partitionConverter = partitionConverter;
        this.dlConfig = dlConfig;
        this.streamConfigProvider = streamConfigProvider;
        this.dlNamespace = dlNamespace;
    }

    private DynamicDistributedLogConfiguration getDynConf(String streamName) {
        Optional<DynamicDistributedLogConfiguration> dynDlConf = this.streamConfigProvider.getDynamicStreamConfig(streamName);
        if (dynDlConf.isPresent()) {
            return (DynamicDistributedLogConfiguration)dynDlConf.get();
        }
        return ConfUtils.getConstDynConf((DistributedLogConfiguration)this.dlConfig);
    }

    @Override
    public boolean allowAcquire(Stream stream) {
        return this.acquiredPartitions.addPartition(stream.getPartition(), stream.getStreamConfiguration().getMaxAcquiredPartitionsPerProxy());
    }

    @Override
    public com.twitter.util.Future<Void> deleteAndRemoveAsync(final String stream) {
        final Promise result = new Promise();
        Future<?> scheduleFuture = this.schedule(new Runnable(){

            @Override
            public void run() {
                result.become(StreamManagerImpl.this.doDeleteAndRemoveAsync(stream));
            }
        }, 0L);
        if (null == scheduleFuture) {
            return com.twitter.util.Future.exception((Throwable)new ServiceUnavailableException("Couldn't schedule a delete task."));
        }
        return result;
    }

    @Override
    public com.twitter.util.Future<Void> closeAndRemoveAsync(final String streamName) {
        final Promise releasePromise = new Promise();
        Future<?> scheduleFuture = this.schedule(new Runnable(){

            @Override
            public void run() {
                releasePromise.become(StreamManagerImpl.this.doCloseAndRemoveAsync(streamName));
            }
        }, 0L);
        if (null == scheduleFuture) {
            return com.twitter.util.Future.exception((Throwable)new ServiceUnavailableException("Couldn't schedule a release task."));
        }
        return releasePromise;
    }

    @Override
    public com.twitter.util.Future<Void> createStreamAsync(final String stream) {
        final Promise createPromise = new Promise();
        Future<?> scheduleFuture = this.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    StreamManagerImpl.this.dlNamespace.createLog(stream);
                    createPromise.setValue(null);
                }
                catch (Exception e) {
                    createPromise.setException((Throwable)e);
                }
            }
        }, 0L);
        if (null == scheduleFuture) {
            return com.twitter.util.Future.exception((Throwable)new ServiceUnavailableException("Couldn't schedule a create task."));
        }
        return createPromise;
    }

    @Override
    public void notifyReleased(Stream stream) {
        this.acquiredPartitions.removePartition(stream.getPartition());
        if (this.acquiredStreams.remove(stream.getStreamName(), stream)) {
            this.numAcquired.getAndDecrement();
        }
    }

    @Override
    public void notifyAcquired(Stream stream) {
        if (null == this.acquiredStreams.put(stream.getStreamName(), stream)) {
            this.numAcquired.getAndIncrement();
        }
    }

    @Override
    public boolean notifyRemoved(Stream stream) {
        this.cachedPartitions.removePartition(stream.getPartition());
        if (this.streams.remove(stream.getStreamName(), stream)) {
            this.numCached.getAndDecrement();
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> getStreamOwnershipMap(Optional<String> regex) {
        HashMap<String, String> ownershipMap = new HashMap<String, String>();
        for (Map.Entry<String, Stream> entry : this.acquiredStreams.entrySet()) {
            String owner;
            Stream stream;
            String name = entry.getKey();
            if (regex.isPresent() && !name.matches((String)regex.get()) || null == (stream = entry.getValue()) || null != (owner = stream.getOwner())) continue;
            ownershipMap.put(name, this.clientId);
        }
        return ownershipMap;
    }

    @Override
    public Stream getStream(String stream) {
        return this.streams.get(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream getOrCreateStream(String streamName, boolean start) throws IOException {
        Stream stream = this.streams.get(streamName);
        if (null == stream) {
            this.closeLock.readLock().lock();
            try {
                if (this.closed) {
                    Stream stream2 = null;
                    return stream2;
                }
                DynamicDistributedLogConfiguration dynConf = this.getDynConf(streamName);
                int maxCachedPartitions = dynConf.getMaxCachedPartitionsPerProxy();
                Partition partition = this.partitionConverter.convert(streamName);
                if (!this.cachedPartitions.addPartition(partition, maxCachedPartitions)) {
                    throw new StreamUnavailableException("Stream " + streamName + " is not allowed to cache more than " + maxCachedPartitions + " partitions");
                }
                stream = this.newStream(streamName, dynConf);
                Stream oldWriter = this.streams.putIfAbsent(streamName, stream);
                if (null != oldWriter) {
                    stream = oldWriter;
                } else {
                    this.numCached.getAndIncrement();
                    logger.info("Inserted mapping stream name {} -> stream {}", (Object)streamName, (Object)stream);
                    stream.initialize();
                    if (start) {
                        stream.start();
                    }
                }
            }
            finally {
                this.closeLock.readLock().unlock();
            }
        }
        return stream;
    }

    @Override
    public com.twitter.util.Future<List<Void>> closeStreams() {
        int numAcquired = this.acquiredStreams.size();
        int numCached = this.streams.size();
        logger.info("Closing all acquired streams : acquired = {}, cached = {}.", (Object)numAcquired, (Object)numCached);
        HashSet<Stream> streamsToClose = new HashSet<Stream>();
        streamsToClose.addAll(this.streams.values());
        return this.closeStreams(streamsToClose, (Optional<RateLimiter>)Optional.absent());
    }

    @Override
    public void scheduleRemoval(final Stream stream, long delayMs) {
        if (delayMs > 0L) {
            logger.info("Scheduling removal of stream {} from cache after {} sec.", (Object)stream.getStreamName(), (Object)delayMs);
        }
        this.schedule(new Runnable(){

            @Override
            public void run() {
                if (StreamManagerImpl.this.notifyRemoved(stream)) {
                    logger.info("Removed cached stream {} after probation.", (Object)stream.getStreamName());
                } else {
                    logger.info("Cached stream {} already removed.", (Object)stream.getStreamName());
                }
            }
        }, delayMs);
    }

    @Override
    public int numAcquired() {
        return this.numAcquired.get();
    }

    @Override
    public int numCached() {
        return this.numCached.get();
    }

    @Override
    public boolean isAcquired(String streamName) {
        return this.acquiredStreams.containsKey(streamName);
    }

    @Override
    public void close() {
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
    }

    private com.twitter.util.Future<List<Void>> closeStreams(Set<Stream> streamsToClose, Optional<RateLimiter> rateLimiter) {
        if (streamsToClose.isEmpty()) {
            logger.info("No streams to close.");
            ArrayList emptyList = new ArrayList();
            return com.twitter.util.Future.value(emptyList);
        }
        ArrayList<com.twitter.util.Future<Void>> futures = new ArrayList<com.twitter.util.Future<Void>>(streamsToClose.size());
        for (Stream stream : streamsToClose) {
            if (rateLimiter.isPresent()) {
                ((RateLimiter)rateLimiter.get()).acquire();
            }
            futures.add(stream.requestClose("Close Streams"));
        }
        return com.twitter.util.Future.collect(futures);
    }

    private Stream newStream(String name, DynamicDistributedLogConfiguration streamConf) {
        return this.streamFactory.create(name, streamConf, this);
    }

    public com.twitter.util.Future<Void> doCloseAndRemoveAsync(String streamName) {
        Stream stream = this.streams.get(streamName);
        if (null == stream) {
            logger.info("No stream {} to release.", (Object)streamName);
            return com.twitter.util.Future.value(null);
        }
        return stream.requestClose("release ownership");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<?> schedule(Runnable runnable, long delayMs) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                Future<?> future = null;
                return future;
            }
            if (delayMs > 0L) {
                ScheduledFuture<?> scheduledFuture = this.executorService.schedule(runnable, delayMs, TimeUnit.MILLISECONDS);
                return scheduledFuture;
            }
            Future<?> future = this.executorService.submit(runnable);
            return future;
        }
        catch (RejectedExecutionException ree) {
            logger.error("Failed to schedule task {} in {} ms : ", new Object[]{runnable, delayMs, ree});
            Future<?> future = null;
            return future;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private com.twitter.util.Future<Void> doDeleteAndRemoveAsync(String streamName) {
        com.twitter.util.Future result;
        Stream stream = this.streams.get(streamName);
        if (null == stream) {
            logger.warn("No stream {} to delete.", (Object)streamName);
            return com.twitter.util.Future.exception((Throwable)new UnexpectedException("No stream " + streamName + " to delete."));
        }
        logger.info("Deleting stream {}, {}", (Object)streamName, (Object)stream);
        try {
            stream.delete();
            result = stream.requestClose("Stream Deleted");
        }
        catch (IOException e) {
            logger.error("Failed on removing stream {} : ", (Object)streamName, (Object)e);
            result = com.twitter.util.Future.exception((Throwable)e);
        }
        return result;
    }

    @VisibleForTesting
    public ConcurrentHashMap<String, Stream> getCachedStreams() {
        return this.streams;
    }

    @VisibleForTesting
    public ConcurrentHashMap<String, Stream> getAcquiredStreams() {
        return this.acquiredStreams;
    }
}

