/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.userdefined;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.PartitionIterator;
import org.apache.cassandra.stress.generate.RatioDistribution;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.PartitionOperation;
import org.apache.cassandra.stress.operations.userdefined.SchemaStatement;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.stress.util.Timer;

public class SchemaInsert
extends SchemaStatement {
    private final BatchStatement.Type batchType;

    public SchemaInsert(Timer timer, StressSettings settings, PartitionGenerator generator, SeedManager seedManager, Distribution batchSize, RatioDistribution useRatio, RatioDistribution rowPopulation, Integer thriftId, PreparedStatement statement, ConsistencyLevel cl, BatchStatement.Type batchType) {
        super(timer, settings, new PartitionOperation.DataSpec(generator, seedManager, batchSize, useRatio, rowPopulation), statement, thriftId, cl);
        this.batchType = batchType;
    }

    @Override
    public void run(JavaDriverClient client) throws IOException {
        this.timeWithRetry(new JavaDriverRun(client));
    }

    @Override
    public boolean isWrite() {
        return true;
    }

    @Override
    public void run(ThriftClient client) throws IOException {
        this.timeWithRetry(new ThriftRun(client));
    }

    private class ThriftRun
    extends SchemaStatement.Runner {
        final ThriftClient client;

        private ThriftRun(ThriftClient client) {
            super(SchemaInsert.this);
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            for (PartitionIterator iterator : SchemaInsert.this.partitions) {
                while (iterator.hasNext()) {
                    this.client.execute_prepared_cql3_query(SchemaInsert.this.thriftId, iterator.getToken(), SchemaInsert.this.thriftRowArgs((Row)iterator.next()), SchemaInsert.this.settings.command.consistencyLevel);
                    ++this.rowCount;
                }
            }
            return true;
        }
    }

    private class JavaDriverRun
    extends SchemaStatement.Runner {
        final JavaDriverClient client;

        private JavaDriverRun(JavaDriverClient client) {
            super(SchemaInsert.this);
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            ArrayList<BoundStatement> stmts = new ArrayList<BoundStatement>();
            this.partitionCount = SchemaInsert.this.partitions.size();
            for (PartitionIterator iterator : SchemaInsert.this.partitions) {
                while (iterator.hasNext()) {
                    stmts.add(SchemaInsert.this.bindRow((Row)iterator.next()));
                }
            }
            this.rowCount += stmts.size();
            for (int j = 0; j < stmts.size(); j += 65535) {
                Statement stmt;
                List substmts = stmts.subList(j, Math.min(j + stmts.size(), j + 65535));
                if (stmts.size() == 1) {
                    stmt = (Statement)substmts.get(0);
                } else {
                    BatchStatement batch = new BatchStatement(SchemaInsert.this.batchType);
                    batch.setConsistencyLevel(JavaDriverClient.from(SchemaInsert.this.cl));
                    batch.addAll(substmts);
                    stmt = batch;
                }
                this.client.getSession().execute(stmt);
            }
            return true;
        }
    }
}

