/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth.jmx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationProxy
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationProxy.class);
    private MBeanServer mbs;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getMBeanServer".equals(methodName)) {
            throw new SecurityException("Access denied");
        }
        if (methodName.equals("invoke") && args.length == 4) {
            this.checkVulnerableMethods(args);
        }
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if ("setMBeanServer".equals(methodName)) {
            if (subject != null) {
                throw new SecurityException("Access denied");
            }
            if (args[0] == null) {
                throw new IllegalArgumentException("Null MBeanServer");
            }
            if (this.mbs != null) {
                throw new IllegalArgumentException("MBeanServer already initialized");
            }
            this.mbs = (MBeanServer)args[0];
            return null;
        }
        return this.invoke(method, args);
    }

    private Object invoke(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.mbs, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            throw t;
        }
    }

    private void checkVulnerableMethods(Object[] args) {
        String operationName;
        ObjectName name;
        assert (args.length == 4);
        try {
            name = (ObjectName)args[0];
            operationName = (String)args[1];
            Object[] params = (Object[])args[2];
            String[] signature = (String[])args[3];
        }
        catch (ClassCastException cce) {
            logger.warn("Could not interpret arguments to check vulnerable MBean invocations; did the MBeanServer interface change?", (Throwable)cce);
            return;
        }
        this.checkCompilerDirectiveAddMethods(name, operationName);
        this.checkJvmtiLoad(name, operationName);
        this.checkMLetMethods(name, operationName);
    }

    private void checkCompilerDirectiveAddMethods(ObjectName name, String operation) {
        if (name.getCanonicalName().equals("com.sun.management:type=DiagnosticCommand") && operation.equals("compilerDirectivesAdd")) {
            throw new SecurityException("Access is denied!");
        }
    }

    private void checkJvmtiLoad(ObjectName name, String operation) {
        if (name.getCanonicalName().equals("com.sun.management:type=DiagnosticCommand") && operation.equals("jvmtiAgentLoad")) {
            throw new SecurityException("Access is denied!");
        }
    }

    private void checkMLetMethods(ObjectName name, String operation) {
        if (operation == null) {
            return;
        }
        try {
            if (!this.mbs.isInstanceOf(name, "javax.management.loading.MLet")) {
                return;
            }
        }
        catch (InstanceNotFoundException infe) {
            return;
        }
        if (operation.equals("addURL") || operation.equals("getMBeansFromURL")) {
            throw new SecurityException("Access is denied!");
        }
    }
}

