/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;

public class FilteredPartition
extends ImmutableBTreePartition {
    public FilteredPartition(RowIterator rows) {
        super(rows.metadata(), rows.partitionKey(), FilteredPartition.build(rows, DeletionInfo.LIVE, false, 16));
    }

    public static FilteredPartition create(RowIterator iterator) {
        return new FilteredPartition(iterator);
    }

    public RowIterator rowIterator() {
        final Iterator<Row> iter = this.iterator();
        return new RowIterator(){

            @Override
            public CFMetaData metadata() {
                return FilteredPartition.this.metadata;
            }

            @Override
            public boolean isReverseOrder() {
                return false;
            }

            @Override
            public PartitionColumns columns() {
                return FilteredPartition.this.columns();
            }

            @Override
            public DecoratedKey partitionKey() {
                return FilteredPartition.this.partitionKey;
            }

            @Override
            public Row staticRow() {
                return FilteredPartition.this.staticRow();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Row next() {
                return (Row)iter.next();
            }

            @Override
            public boolean isEmpty() {
                return this.staticRow().isEmpty() && !FilteredPartition.this.hasRows();
            }
        };
    }
}

