/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class LatencyMetrics {
    public final Timer latency;
    public final Counter totalLatency;
    private List<LatencyMetrics> parents = Lists.newArrayList();
    protected final MetricNameFactory factory;
    protected final MetricNameFactory aliasFactory;
    protected final String namePrefix;

    public LatencyMetrics(String type, String scope) {
        this(type, "", scope);
    }

    public LatencyMetrics(String type, String namePrefix, String scope) {
        this(new DefaultNameFactory(type, scope), namePrefix);
    }

    public LatencyMetrics(MetricNameFactory factory, String namePrefix) {
        this(factory, null, namePrefix);
    }

    public LatencyMetrics(MetricNameFactory factory, MetricNameFactory aliasFactory, String namePrefix) {
        this.factory = factory;
        this.aliasFactory = aliasFactory;
        this.namePrefix = namePrefix;
        if (aliasFactory == null) {
            this.latency = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName(namePrefix + "Latency"));
            this.totalLatency = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName(namePrefix + "TotalLatency"));
        } else {
            this.latency = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName(namePrefix + "Latency"), aliasFactory.createMetricName(namePrefix + "Latency"));
            this.totalLatency = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName(namePrefix + "TotalLatency"), aliasFactory.createMetricName(namePrefix + "TotalLatency"));
        }
    }

    public LatencyMetrics(MetricNameFactory factory, String namePrefix, LatencyMetrics ... parents) {
        this(factory, null, namePrefix);
        this.parents.addAll((Collection<LatencyMetrics>)ImmutableList.copyOf((Object[])parents));
    }

    public void addNano(long nanos) {
        this.latency.update(nanos, TimeUnit.NANOSECONDS);
        this.totalLatency.inc(nanos / 1000L);
        for (LatencyMetrics parent : this.parents) {
            parent.addNano(nanos);
        }
    }

    public void release() {
        if (this.aliasFactory == null) {
            CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "Latency"));
            CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "TotalLatency"));
        } else {
            CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "Latency"), this.aliasFactory.createMetricName(this.namePrefix + "Latency"));
            CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "TotalLatency"), this.aliasFactory.createMetricName(this.namePrefix + "TotalLatency"));
        }
    }
}

