/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.base.Objects;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.TableParams;

public final class SpeculativeRetryParam {
    public static final SpeculativeRetryParam NONE = SpeculativeRetryParam.none();
    public static final SpeculativeRetryParam ALWAYS = SpeculativeRetryParam.always();
    public static final SpeculativeRetryParam DEFAULT = SpeculativeRetryParam.percentile(99.0);
    private final Kind kind;
    private final double value;
    private final double threshold;

    private SpeculativeRetryParam(Kind kind, double value) {
        this.kind = kind;
        this.value = value;
        this.threshold = kind == Kind.PERCENTILE ? value / 100.0 : (kind == Kind.CUSTOM ? (double)TimeUnit.MILLISECONDS.toNanos((long)value) : value);
    }

    public Kind kind() {
        return this.kind;
    }

    public double threshold() {
        return this.threshold;
    }

    public static SpeculativeRetryParam none() {
        return new SpeculativeRetryParam(Kind.NONE, 0.0);
    }

    public static SpeculativeRetryParam always() {
        return new SpeculativeRetryParam(Kind.ALWAYS, 0.0);
    }

    public static SpeculativeRetryParam custom(double value) {
        return new SpeculativeRetryParam(Kind.CUSTOM, value);
    }

    public static SpeculativeRetryParam percentile(double value) {
        return new SpeculativeRetryParam(Kind.PERCENTILE, value);
    }

    public static SpeculativeRetryParam fromString(String value) {
        String upperCaseValue = value.toUpperCase(Locale.ENGLISH);
        if (upperCaseValue.endsWith("MS")) {
            try {
                return SpeculativeRetryParam.custom(Double.parseDouble(value.substring(0, value.length() - "ms".length())));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.format("Invalid value %s for option '%s'", new Object[]{value, TableParams.Option.SPECULATIVE_RETRY}));
            }
        }
        if (upperCaseValue.endsWith(Kind.PERCENTILE.toString())) {
            double threshold;
            try {
                threshold = Double.parseDouble(value.substring(0, value.length() - Kind.PERCENTILE.toString().length()));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.format("Invalid value %s for option '%s'", new Object[]{value, TableParams.Option.SPECULATIVE_RETRY}));
            }
            if (threshold >= 0.0 && threshold <= 100.0) {
                return SpeculativeRetryParam.percentile(threshold);
            }
            throw new ConfigurationException(String.format("Invalid value %s for PERCENTILE option '%s': must be between 0.0 and 100.0", new Object[]{value, TableParams.Option.SPECULATIVE_RETRY}));
        }
        if (upperCaseValue.equals(Kind.NONE.toString())) {
            return NONE;
        }
        if (upperCaseValue.equals(Kind.ALWAYS.toString())) {
            return ALWAYS;
        }
        throw new ConfigurationException(String.format("Invalid value %s for option '%s'", new Object[]{value, TableParams.Option.SPECULATIVE_RETRY}));
    }

    public boolean equals(Object o) {
        if (!(o instanceof SpeculativeRetryParam)) {
            return false;
        }
        SpeculativeRetryParam srp = (SpeculativeRetryParam)o;
        return this.kind == srp.kind && this.threshold == srp.threshold;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.kind, this.threshold});
    }

    public String toString() {
        switch (this.kind) {
            case CUSTOM: {
                return String.format("%sms", this.value);
            }
            case PERCENTILE: {
                return String.format("%sPERCENTILE", new DecimalFormat("#.#####").format(this.value));
            }
        }
        return this.kind.toString();
    }

    public static enum Kind {
        NONE,
        CUSTOM,
        PERCENTILE,
        ALWAYS;

    }
}

