/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.airlift.command.Accessor;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.airlift.command.OptionType;
import io.airlift.command.Suggester;
import io.airlift.command.model.ArgumentsMetadata;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.GlobalMetadata;
import io.airlift.command.model.OptionMetadata;
import io.airlift.command.model.SuggesterMetadata;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class MetadataLoader {
    public static GlobalMetadata loadGlobal(String name, String description, CommandMetadata defaultCommand, Iterable<CommandMetadata> defaultGroupCommands, Iterable<CommandGroupMetadata> groups) {
        ImmutableList.Builder globalOptionsBuilder = ImmutableList.builder();
        if (defaultCommand != null) {
            globalOptionsBuilder.addAll(defaultCommand.getGlobalOptions());
        }
        for (CommandMetadata command : defaultGroupCommands) {
            globalOptionsBuilder.addAll(command.getGlobalOptions());
        }
        for (CommandGroupMetadata group : groups) {
            for (CommandMetadata command : group.getCommands()) {
                globalOptionsBuilder.addAll(command.getGlobalOptions());
            }
        }
        List<OptionMetadata> globalOptions = MetadataLoader.mergeOptionSet((List<OptionMetadata>)globalOptionsBuilder.build());
        return new GlobalMetadata(name, description, globalOptions, defaultCommand, defaultGroupCommands, groups);
    }

    public static CommandGroupMetadata loadCommandGroup(String name, String description, CommandMetadata defaultCommand, Iterable<CommandMetadata> commands) {
        ImmutableList.Builder groupOptionsBuilder = ImmutableList.builder();
        if (defaultCommand != null) {
            groupOptionsBuilder.addAll(defaultCommand.getGroupOptions());
        }
        for (CommandMetadata command : commands) {
            groupOptionsBuilder.addAll(command.getGroupOptions());
        }
        List<OptionMetadata> groupOptions = MetadataLoader.mergeOptionSet((List<OptionMetadata>)groupOptionsBuilder.build());
        return new CommandGroupMetadata(name, description, groupOptions, defaultCommand, commands);
    }

    public static <T> ImmutableList<CommandMetadata> loadCommands(Iterable<Class<? extends T>> defaultCommands) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(defaultCommands, (Function)new Function<Class<?>, CommandMetadata>(){

            public CommandMetadata apply(Class<?> commandType) {
                return MetadataLoader.loadCommand(commandType);
            }
        }));
    }

    public static CommandMetadata loadCommand(Class<?> commandType) {
        Command command = null;
        Class<?> cls = commandType;
        while (command == null && !Object.class.equals(cls)) {
            command = cls.getAnnotation(Command.class);
            cls = cls.getSuperclass();
        }
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (String)"Command %s is not annotated with @Command", (Object[])new Object[]{commandType.getName()});
        String name = command.name();
        String description = command.description().isEmpty() ? null : command.description();
        boolean hidden = command.hidden();
        InjectionMetadata injectionMetadata = MetadataLoader.loadInjectionMetadata(commandType);
        CommandMetadata commandMetadata = new CommandMetadata(name, description, hidden, injectionMetadata.globalOptions, injectionMetadata.groupOptions, injectionMetadata.commandOptions, (ArgumentsMetadata)Iterables.getFirst((Iterable)injectionMetadata.arguments, null), injectionMetadata.metadataInjections, commandType);
        return commandMetadata;
    }

    public static SuggesterMetadata loadSuggester(Class<? extends Suggester> suggesterClass) {
        InjectionMetadata injectionMetadata = MetadataLoader.loadInjectionMetadata(suggesterClass);
        return new SuggesterMetadata(suggesterClass, injectionMetadata.metadataInjections);
    }

    public static InjectionMetadata loadInjectionMetadata(Class<?> type) {
        InjectionMetadata injectionMetadata = new InjectionMetadata();
        MetadataLoader.loadInjectionMetadata(type, injectionMetadata, (List<Field>)ImmutableList.of());
        injectionMetadata.compact();
        return injectionMetadata;
    }

    public static void loadInjectionMetadata(Class<?> type, InjectionMetadata injectionMetadata, List<Field> fields) {
        Class<?> cls = type;
        while (!Object.class.equals(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                Option optionAnnotation;
                field.setAccessible(true);
                ImmutableList<Field> path = MetadataLoader.concat(fields, field);
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                if (injectAnnotation != null) {
                    if (field.getType().equals(GlobalMetadata.class) || field.getType().equals(CommandGroupMetadata.class) || field.getType().equals(CommandMetadata.class)) {
                        injectionMetadata.metadataInjections.add(new Accessor((Iterable<Field>)path));
                    } else {
                        MetadataLoader.loadInjectionMetadata(field.getType(), injectionMetadata, path);
                    }
                }
                if ((optionAnnotation = field.getAnnotation(Option.class)) != null) {
                    Class<?> fieldType;
                    OptionType optionType = optionAnnotation.type();
                    String name = !optionAnnotation.title().isEmpty() ? optionAnnotation.title() : field.getName();
                    ImmutableList options = ImmutableList.copyOf((Object[])optionAnnotation.name());
                    String description = optionAnnotation.description();
                    int arity = optionAnnotation.arity();
                    Preconditions.checkArgument((arity >= 0 || arity == Integer.MIN_VALUE ? 1 : 0) != 0, (String)"Invalid arity for option %s", (Object[])new Object[]{name});
                    arity = optionAnnotation.arity() >= 0 ? optionAnnotation.arity() : (Boolean.class.isAssignableFrom(fieldType = field.getType()) || Boolean.TYPE.isAssignableFrom(fieldType) ? 0 : 1);
                    boolean required = optionAnnotation.required();
                    boolean hidden = optionAnnotation.hidden();
                    ImmutableList allowedValues = ImmutableList.copyOf((Object[])optionAnnotation.allowedValues());
                    if (allowedValues.isEmpty()) {
                        allowedValues = null;
                    }
                    OptionMetadata optionMetadata = new OptionMetadata(optionType, (Iterable<String>)options, name, description, arity, required, hidden, (Iterable<String>)allowedValues, (Iterable<Field>)path);
                    switch (optionType) {
                        case GLOBAL: {
                            injectionMetadata.globalOptions.add(optionMetadata);
                            break;
                        }
                        case GROUP: {
                            injectionMetadata.groupOptions.add(optionMetadata);
                            break;
                        }
                        case COMMAND: {
                            injectionMetadata.commandOptions.add(optionMetadata);
                        }
                    }
                }
                Arguments argumentsAnnotation = field.getAnnotation(Arguments.class);
                if (!field.isAnnotationPresent(Arguments.class)) continue;
                String title = !argumentsAnnotation.title().isEmpty() ? argumentsAnnotation.title() : field.getName();
                String description = argumentsAnnotation.description();
                String usage = argumentsAnnotation.usage();
                boolean required = argumentsAnnotation.required();
                injectionMetadata.arguments.add(new ArgumentsMetadata(title, description, usage, required, (Iterable<Field>)path));
            }
            cls = cls.getSuperclass();
        }
    }

    private static List<OptionMetadata> mergeOptionSet(List<OptionMetadata> options) {
        ArrayListMultimap metadataIndex = ArrayListMultimap.create();
        for (OptionMetadata option : options) {
            metadataIndex.put((Object)option, (Object)option);
        }
        options = ImmutableList.copyOf((Iterable)Iterables.transform(metadataIndex.asMap().values(), (Function)new Function<Collection<OptionMetadata>, OptionMetadata>(){

            public OptionMetadata apply(@Nullable Collection<OptionMetadata> options) {
                return new OptionMetadata(options);
            }
        }));
        HashMap optionIndex = Maps.newHashMap();
        for (OptionMetadata option : options) {
            for (String optionName : option.getOptions()) {
                if (optionIndex.containsKey(optionName)) {
                    throw new IllegalArgumentException(String.format("Fields %s and %s have conflicting definitions of option %s", ((OptionMetadata)optionIndex.get(optionName)).getAccessors().iterator().next(), option.getAccessors().iterator().next(), optionName));
                }
                optionIndex.put(optionName, option);
            }
        }
        return options;
    }

    private static <T> ImmutableList<T> concat(Iterable<T> iterable, T item) {
        return ImmutableList.builder().addAll(iterable).add(item).build();
    }

    private static class InjectionMetadata {
        private List<OptionMetadata> globalOptions = Lists.newArrayList();
        private List<OptionMetadata> groupOptions = Lists.newArrayList();
        private List<OptionMetadata> commandOptions = Lists.newArrayList();
        private List<ArgumentsMetadata> arguments = Lists.newArrayList();
        private List<Accessor> metadataInjections = Lists.newArrayList();

        private InjectionMetadata() {
        }

        private void compact() {
            this.globalOptions = MetadataLoader.mergeOptionSet(this.globalOptions);
            this.groupOptions = MetadataLoader.mergeOptionSet(this.groupOptions);
            this.commandOptions = MetadataLoader.mergeOptionSet(this.commandOptions);
            if (this.arguments.size() > 1) {
                this.arguments = ImmutableList.of((Object)new ArgumentsMetadata(this.arguments));
            }
        }
    }
}

