/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.RepairResult;
import org.apache.cassandra.repair.RepairSessionResult;
import org.apache.cassandra.repair.SyncStat;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.streaming.SessionSummary;
import org.apache.cassandra.streaming.StreamSummary;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;

public class SyncStatSummary {
    private final Map<Pair<String, String>, Table> summaries = new HashMap<Pair<String, String>, Table>();
    private final boolean isEstimate;
    private int files = -1;
    private long bytes = -1L;
    private Set<Range<Token>> ranges = new HashSet<Range<Token>>();
    private boolean totalsCalculated = false;

    public SyncStatSummary(boolean isEstimate) {
        this.isEstimate = isEstimate;
    }

    public void consumeRepairResult(RepairResult result) {
        Pair<String, String> cf = Pair.create(result.desc.keyspace, result.desc.columnFamily);
        if (!this.summaries.containsKey(cf)) {
            this.summaries.put(cf, new Table((String)cf.left, (String)cf.right));
        }
        this.summaries.get(cf).consumeStats(result.stats);
    }

    public void consumeSessionResults(Optional<List<RepairSessionResult>> results) {
        if (results.isPresent()) {
            Iterables.filter((Iterable)results.get(), Objects::nonNull).forEach(r -> Iterables.filter(r.repairJobResults, Objects::nonNull).forEach(this::consumeRepairResult));
        }
    }

    public boolean isEmpty() {
        this.calculateTotals();
        return this.files == 0 && this.bytes == 0L && this.ranges.isEmpty();
    }

    private void calculateTotals() {
        this.files = 0;
        this.bytes = 0L;
        this.ranges = new HashSet<Range<Token>>();
        this.summaries.values().forEach(Table::calculateTotals);
        for (Table table : this.summaries.values()) {
            if (table.isCounter()) continue;
            table.calculateTotals();
            this.files += table.files;
            this.bytes += table.bytes;
            this.ranges.addAll(table.ranges);
        }
        this.totalsCalculated = true;
    }

    public String toString() {
        ArrayList tables = Lists.newArrayList(this.summaries.keySet());
        tables.sort((o1, o2) -> {
            int ks = ((String)o1.left).compareTo((String)o2.left);
            return ks != 0 ? ks : ((String)o1.right).compareTo((String)o2.right);
        });
        this.calculateTotals();
        StringBuilder output = new StringBuilder();
        if (this.isEstimate) {
            output.append(String.format("Total estimated streaming: %s ranges, %s sstables, %s bytes\n", this.ranges.size(), this.files, FBUtilities.prettyPrintMemory(this.bytes)));
        } else {
            output.append(String.format("Total streaming: %s ranges, %s sstables, %s bytes\n", this.ranges.size(), this.files, FBUtilities.prettyPrintMemory(this.bytes)));
        }
        for (Pair tableName : tables) {
            Table table = this.summaries.get(tableName);
            output.append(table.toString()).append('\n');
        }
        return output.toString();
    }

    private static class Table {
        final String keyspace;
        final String table;
        int files = -1;
        long bytes = -1L;
        Collection<Range<Token>> ranges = new HashSet<Range<Token>>();
        boolean totalsCalculated = false;
        final Map<Pair<InetSocketAddress, InetSocketAddress>, Session> sessions = new HashMap<Pair<InetSocketAddress, InetSocketAddress>, Session>();

        Table(String keyspace, String table) {
            this.keyspace = keyspace;
            this.table = table;
        }

        Session getOrCreate(InetSocketAddress from, InetSocketAddress to) {
            Pair<InetSocketAddress, InetSocketAddress> k = Pair.create(from, to);
            if (!this.sessions.containsKey(k)) {
                this.sessions.put(k, new Session(from, to));
            }
            return this.sessions.get(k);
        }

        void consumeStat(SyncStat stat) {
            for (SessionSummary summary : stat.summaries) {
                this.getOrCreate(summary.coordinator, summary.peer).consumeSummaries(summary.sendingSummaries, stat.differences);
                this.getOrCreate(summary.peer, summary.coordinator).consumeSummaries(summary.receivingSummaries, stat.differences);
            }
        }

        void consumeStats(List<SyncStat> stats) {
            Iterables.filter(stats, s -> s.summaries != null).forEach(this::consumeStat);
        }

        void calculateTotals() {
            this.files = 0;
            this.bytes = 0L;
            this.ranges = new HashSet<Range<Token>>();
            for (Session session : this.sessions.values()) {
                this.files += session.files;
                this.bytes += session.bytes;
                this.ranges.addAll(session.ranges);
            }
            this.totalsCalculated = true;
        }

        boolean isCounter() {
            TableMetadata tmd = Schema.instance.getTableMetadata(this.keyspace, this.table);
            return tmd != null && tmd.isCounter();
        }

        public String toString() {
            if (!this.totalsCalculated) {
                this.calculateTotals();
            }
            StringBuilder output = new StringBuilder();
            output.append(String.format("%s.%s - %s ranges, %s sstables, %s bytes\n", this.keyspace, this.table, this.ranges.size(), this.files, FBUtilities.prettyPrintMemory(this.bytes)));
            if (this.ranges.size() > 0) {
                int i;
                output.append("    Mismatching ranges: ");
                Iterator<Range<Token>> rangeIterator = this.ranges.iterator();
                for (i = 0; rangeIterator.hasNext() && i < 30; ++i) {
                    Range<Token> r = rangeIterator.next();
                    output.append('(').append(r.left).append(',').append(r.right).append("],");
                }
                if (i == 30) {
                    output.append("...");
                }
                output.append(System.lineSeparator());
            }
            for (Session session : this.sessions.values()) {
                output.append("    ").append(session.toString()).append(System.lineSeparator());
            }
            return output.toString();
        }
    }

    private static class Session {
        final InetSocketAddress src;
        final InetSocketAddress dst;
        int files = 0;
        long bytes = 0L;
        Set<Range<Token>> ranges = new HashSet<Range<Token>>();

        Session(InetSocketAddress src, InetSocketAddress dst) {
            this.src = src;
            this.dst = dst;
        }

        void consumeSummary(StreamSummary summary) {
            this.files += summary.files;
            this.bytes += summary.totalSize;
        }

        void consumeSummaries(Collection<StreamSummary> summaries, Collection<Range<Token>> ranges) {
            summaries.forEach(this::consumeSummary);
            this.ranges.addAll(ranges);
        }

        public String toString() {
            return String.format("%s -> %s: %s ranges, %s sstables, %s bytes", this.src, this.dst, this.ranges.size(), this.files, FBUtilities.prettyPrintMemory(this.bytes));
        }
    }
}

