/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.stress.util.ResultLogger;

public class SettingsCredentials
implements Serializable {
    public static final String CQL_USERNAME_PROPERTY_KEY = "cql.username";
    public static final String CQL_PASSWORD_PROPERTY_KEY = "cql.password";
    public static final String JMX_USERNAME_PROPERTY_KEY = "jmx.username";
    public static final String JMX_PASSWORD_PROPERTY_KEY = "jmx.password";
    public static final String TRANSPORT_TRUSTSTORE_PASSWORD_PROPERTY_KEY = "transport.truststore.password";
    public static final String TRANSPORT_KEYSTORE_PASSWORD_PROPERTY_KEY = "transport.keystore.password";
    private final String file;
    public final String cqlUsername;
    public final String cqlPassword;
    public final String jmxUsername;
    public final String jmxPassword;
    public final String transportTruststorePassword;
    public final String transportKeystorePassword;

    public SettingsCredentials(String file) {
        this.file = file;
        if (file == null) {
            this.cqlUsername = null;
            this.cqlPassword = null;
            this.jmxUsername = null;
            this.jmxPassword = null;
            this.transportTruststorePassword = null;
            this.transportKeystorePassword = null;
            return;
        }
        try {
            Properties properties = new Properties();
            try (FileInputStream is = new FileInputStream(new File(file).toJavaIOFile());){
                properties.load(is);
                this.cqlUsername = properties.getProperty(CQL_USERNAME_PROPERTY_KEY);
                this.cqlPassword = properties.getProperty(CQL_PASSWORD_PROPERTY_KEY);
                this.jmxUsername = properties.getProperty(JMX_USERNAME_PROPERTY_KEY);
                this.jmxPassword = properties.getProperty(JMX_PASSWORD_PROPERTY_KEY);
                this.transportTruststorePassword = properties.getProperty(TRANSPORT_TRUSTSTORE_PASSWORD_PROPERTY_KEY);
                this.transportKeystorePassword = properties.getProperty(TRANSPORT_KEYSTORE_PASSWORD_PROPERTY_KEY);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void printSettings(ResultLogger out) {
        out.printf("  File: %s%n", this.file == null ? "*not set*" : this.file);
        out.printf("  CQL username: %s%n", this.cqlUsername == null ? "*not set*" : this.cqlUsername);
        out.printf("  CQL password: %s%n", this.cqlPassword == null ? "*not set*" : "*suppressed*");
        out.printf("  JMX username: %s%n", this.jmxUsername == null ? "*not set*" : this.jmxUsername);
        out.printf("  JMX password: %s%n", this.jmxPassword == null ? "*not set*" : "*suppressed*");
        out.printf("  Transport truststore password: %s%n", this.transportTruststorePassword == null ? "*not set*" : "*suppressed*");
        out.printf("  Transport keystore password: %s%n", this.transportKeystorePassword == null ? "*not set*" : "*suppressed*");
    }

    public static SettingsCredentials get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-credentials-file");
        if (params == null) {
            return new SettingsCredentials(null);
        }
        if (params.length != 1) {
            SettingsCredentials.printHelp();
            System.out.println("Invalid -credentials-file option provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsCredentials(params[0]);
    }

    public static void printHelp() {
        System.out.println("Usage: -credentials-file <file> ");
        System.out.printf("File is supposed to be a standard property file with '%s', '%s', '%s', '%s', '%s', and '%s' as keys. The values for these keys will be overriden by their command-line counterparts when specified.%n", CQL_USERNAME_PROPERTY_KEY, CQL_PASSWORD_PROPERTY_KEY, JMX_USERNAME_PROPERTY_KEY, JMX_PASSWORD_PROPERTY_KEY, TRANSPORT_KEYSTORE_PASSWORD_PROPERTY_KEY, TRANSPORT_TRUSTSTORE_PASSWORD_PROPERTY_KEY);
    }

    public static Runnable helpPrinter() {
        return SettingsCredentials::printHelp;
    }
}

