/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaBeanMapDecorator;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class DynaBeanMapDecoratorTestCase
extends TestCase {
    private static final DynaProperty stringProp = new DynaProperty("stringProp", String.class);
    private static final DynaProperty nullProp = new DynaProperty("nullProp", String.class);
    private static final DynaProperty intProp = new DynaProperty("intProp", Integer.class);
    private static final DynaProperty dateProp = new DynaProperty("dateProp", Date.class);
    private static final DynaProperty mapProp = new DynaProperty("mapProp", Map.class);
    private static final DynaProperty[] properties = new DynaProperty[]{stringProp, nullProp, intProp, dateProp, mapProp};
    private static final DynaClass dynaClass = new BasicDynaClass("testDynaClass", BasicDynaBean.class, properties);
    private static String stringVal = "somevalue";
    private static Integer intVal = 5;
    private static Date dateVal = new Date();
    private static final Map<Object, Object> emptyMap = new DynaBeanMapDecorator((DynaBean)new BasicDynaBean((DynaClass)new BasicDynaClass()));
    private final Map<Object, Object> mapVal = new HashMap<Object, Object>();
    private final Object[] values = new Object[]{stringVal, null, intVal, dateVal, this.mapVal};
    private BasicDynaBean dynaBean;
    private Map<Object, Object> decoratedMap;
    private Map<Object, Object> modifiableMap;

    public static void main(String[] args) {
        TestRunner.run((Test)DynaBeanMapDecoratorTestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(DynaBeanMapDecoratorTestCase.class);
    }

    public DynaBeanMapDecoratorTestCase(String name) {
        super(name);
    }

    private <E> void checkUnmodifiable(String desc, Collection<E> collection, E addElem) {
        try {
            collection.add(addElem);
            DynaBeanMapDecoratorTestCase.fail((String)(desc + ".add()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ArrayList<E> list = new ArrayList<E>(1);
        list.add(addElem);
        try {
            collection.addAll(list);
            DynaBeanMapDecoratorTestCase.fail((String)(desc + ".addAll()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            collection.clear();
            DynaBeanMapDecoratorTestCase.fail((String)(desc + ".clear()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            collection.remove("abc");
            DynaBeanMapDecoratorTestCase.fail((String)(desc + ".remove()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            collection.removeAll(list);
            DynaBeanMapDecoratorTestCase.fail((String)(desc + ".removeAll()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            collection.retainAll(list);
            DynaBeanMapDecoratorTestCase.fail((String)(desc + ".retainAll()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void setUp() throws Exception {
        this.mapVal.clear();
        this.mapVal.put("key1", "key1Value");
        this.mapVal.put("key2", "key2Value");
        this.dynaBean = new BasicDynaBean(dynaClass);
        for (int i = 0; i < properties.length; ++i) {
            this.dynaBean.set(properties[i].getName(), this.values[i]);
        }
        this.decoratedMap = new DynaBeanMapDecorator((DynaBean)this.dynaBean);
        this.modifiableMap = new DynaBeanMapDecorator((DynaBean)this.dynaBean, false);
    }

    public void tearDown() {
        this.dynaBean = null;
        this.decoratedMap = null;
        this.modifiableMap = null;
    }

    public void testClear() {
        try {
            this.decoratedMap.clear();
            DynaBeanMapDecoratorTestCase.fail((String)"decoratedMap.clear()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.modifiableMap.clear();
            DynaBeanMapDecoratorTestCase.fail((String)"modifiableMap.clear()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testContainsKey() {
        DynaBeanMapDecoratorTestCase.assertTrue((String)"decoratedMap true", (boolean)this.decoratedMap.containsKey(stringProp.getName()));
        DynaBeanMapDecoratorTestCase.assertFalse((String)"decoratedMap false", (boolean)this.decoratedMap.containsKey("xyz"));
    }

    public void testContainsValue() {
        DynaBeanMapDecoratorTestCase.assertTrue((String)"decoratedMap true", (boolean)this.decoratedMap.containsValue(stringVal));
        DynaBeanMapDecoratorTestCase.assertFalse((String)"decoratedMap false", (boolean)this.decoratedMap.containsValue("xyz"));
    }

    public void testEntrySet() {
        Set<Map.Entry<Object, Object>> set = this.modifiableMap.entrySet();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("key", "value");
        this.checkUnmodifiable("entrySet()", set, m.entrySet().iterator().next());
        DynaBeanMapDecoratorTestCase.assertEquals((String)"entrySet size", (int)properties.length, (int)set.size());
        ArrayList<String> namesList = new ArrayList<String>();
        int i = 0;
        for (Map.Entry<Object, Object> entry : set) {
            String name = (String)entry.getKey();
            namesList.add(name);
            Object expectValue = this.decoratedMap.get(name);
            DynaBeanMapDecoratorTestCase.assertEquals((String)("entrySet(" + i + ") val"), (Object)expectValue, (Object)entry.getValue());
            ++i;
        }
        for (int j = 0; j < properties.length; ++j) {
            String name = properties[j].getName();
            DynaBeanMapDecoratorTestCase.assertTrue((String)("Check property[" + j + "]"), (boolean)namesList.contains(name));
        }
    }

    public void testGet() {
        DynaBeanMapDecoratorTestCase.assertEquals((String)"decoratedMap valid", (Object)stringVal, (Object)this.decoratedMap.get(stringProp.getName()));
        try {
            this.decoratedMap.get("xyz");
            DynaBeanMapDecoratorTestCase.fail((String)"decoratedMap invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsEmpty() {
        DynaBeanMapDecoratorTestCase.assertTrue((String)"Empty", (boolean)emptyMap.isEmpty());
        DynaBeanMapDecoratorTestCase.assertFalse((String)"Not Empty", (boolean)this.decoratedMap.isEmpty());
    }

    public void testIsReadOnly() {
        DynaBeanMapDecoratorTestCase.assertTrue((String)"decoratedMap true", (boolean)((DynaBeanMapDecorator)this.decoratedMap).isReadOnly());
        DynaBeanMapDecoratorTestCase.assertFalse((String)"modifiableMap false", (boolean)((DynaBeanMapDecorator)this.modifiableMap).isReadOnly());
    }

    public void testKeySet() {
        Set<Object> set = this.modifiableMap.keySet();
        this.checkUnmodifiable("keySet()", set, "xyz");
        DynaBeanMapDecoratorTestCase.assertEquals((String)"keySet size", (int)properties.length, (int)set.size());
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i].getName();
            DynaBeanMapDecoratorTestCase.assertTrue((String)("Check property[" + i + "]"), (boolean)set.contains(name));
        }
    }

    public void testPut() {
        String newValue = "ABC";
        try {
            this.decoratedMap.put(stringProp.getName(), "ABC");
            DynaBeanMapDecoratorTestCase.fail((String)"Not read only");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        DynaBeanMapDecoratorTestCase.assertEquals((String)"modifiableMap put", (Object)stringVal, (Object)this.modifiableMap.put(stringProp.getName(), "ABC"));
        DynaBeanMapDecoratorTestCase.assertEquals((String)"dynaBean get", (Object)"ABC", (Object)this.dynaBean.get(stringProp.getName()));
        DynaBeanMapDecoratorTestCase.assertEquals((String)"modifiableMap get", (Object)"ABC", (Object)this.modifiableMap.get(stringProp.getName()));
    }

    public void testPutAll() {
        String newValue = "ABC";
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put(stringProp.getName(), "ABC");
        try {
            this.decoratedMap.putAll(newMap);
            DynaBeanMapDecoratorTestCase.fail((String)"Not read only");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        DynaBeanMapDecoratorTestCase.assertEquals((String)"before putAll", (Object)stringVal, (Object)this.dynaBean.get(stringProp.getName()));
        this.modifiableMap.putAll(newMap);
        DynaBeanMapDecoratorTestCase.assertEquals((String)"after putAll", (Object)"ABC", (Object)this.dynaBean.get(stringProp.getName()));
    }

    public void testRemove() {
        try {
            this.decoratedMap.remove(stringProp.getName());
            DynaBeanMapDecoratorTestCase.fail((String)"decoratedMap.remove()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.modifiableMap.remove(stringProp.getName());
            DynaBeanMapDecoratorTestCase.fail((String)"modifiableMap.remove()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testSize() {
        DynaBeanMapDecoratorTestCase.assertEquals((String)"Empty", (int)0, (int)emptyMap.size());
        DynaBeanMapDecoratorTestCase.assertEquals((String)"Not Empty", (int)properties.length, (int)this.decoratedMap.size());
    }

    public void testValues() {
        Collection<Object> collection = this.modifiableMap.values();
        this.checkUnmodifiable("values()", collection, "xyz");
        DynaBeanMapDecoratorTestCase.assertEquals((String)"values size", (int)this.values.length, (int)collection.size());
        int i = 0;
        for (Object element : collection) {
            DynaBeanMapDecoratorTestCase.assertEquals((String)("values(" + i + ")"), (Object)this.values[i], (Object)element);
            ++i;
        }
    }
}

