/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestCase;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;
import org.apache.commons.beanutils.converters.BooleanArrayConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;

public class BooleanArrayConverterTestCase
extends TestCase {
    public static final String[] STANDARD_TRUES = new String[]{"yes", "y", "true", "on", "1"};
    public static final String[] STANDARD_FALSES = new String[]{"no", "n", "false", "off", "0"};

    public BooleanArrayConverterTestCase(String name) {
        super(name);
    }

    public void testAdditionalStrings() {
        String[] trueStrings = new String[]{"sure"};
        String[] falseStrings = new String[]{"nope"};
        BooleanConverter bc = new BooleanConverter(trueStrings, falseStrings, BooleanConverter.NO_DEFAULT);
        BooleanArrayConverter converter = new BooleanArrayConverter(bc, AbstractArrayConverter.NO_DEFAULT);
        boolean[] results = (boolean[])converter.convert(null, (Object)"NOPE, sure, sure");
        BooleanArrayConverterTestCase.assertNotNull((Object)results);
        BooleanArrayConverterTestCase.assertEquals((int)3, (int)results.length);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[0]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[1]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[2]);
        try {
            converter.convert(null, (Object)"true");
            BooleanArrayConverterTestCase.fail((String)"Converting invalid string should have generated an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testElementDefault() {
        boolean[] defaults = new boolean[1];
        BooleanConverter bc = new BooleanConverter((Object)Boolean.TRUE);
        BooleanArrayConverter converter = new BooleanArrayConverter(bc, (Object)defaults);
        boolean[] results = (boolean[])converter.convert(null, (Object)"true,bogus");
        BooleanArrayConverterTestCase.assertEquals((int)2, (int)results.length);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[0]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[1]);
    }

    public void testInvalidElementWithDefault() {
        boolean[] defaults = new boolean[1];
        BooleanArrayConverter converter = new BooleanArrayConverter((Object)defaults);
        Object o = converter.convert(null, (Object)"true,bogus");
        BooleanArrayConverterTestCase.assertSame((String)"Unexpected object returned for failed conversion", (Object)o, (Object)defaults);
    }

    public void testInvalidElementWithoutDefault() {
        BooleanArrayConverter converter = new BooleanArrayConverter();
        try {
            converter.convert(null, (Object)"true,bogus");
            BooleanArrayConverterTestCase.fail((String)"Converting invalid string should have generated an exception");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testInvalidStringWithDefault() {
        boolean[] defaults = new boolean[1];
        BooleanArrayConverter converter = new BooleanArrayConverter((Object)defaults);
        Object o = converter.convert(null, (Object)"true!");
        BooleanArrayConverterTestCase.assertSame((String)"Unexpected object returned for failed conversion", (Object)o, (Object)defaults);
    }

    public void testInvalidStringWithoutDefault() {
        BooleanArrayConverter converter = new BooleanArrayConverter();
        try {
            converter.convert(null, (Object)"true!");
            BooleanArrayConverterTestCase.fail((String)"Converting invalid string should have generated an exception");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testRegistration() {
        String[] trueStrings = new String[]{"sure"};
        String[] falseStrings = new String[]{"nope"};
        BooleanConverter bc = new BooleanConverter(trueStrings, falseStrings, BooleanConverter.NO_DEFAULT);
        BooleanArrayConverter converter = new BooleanArrayConverter(bc, AbstractArrayConverter.NO_DEFAULT);
        ConvertUtils.register((Converter)converter, (Class)BooleanArrayConverter.MODEL);
        boolean[] sample = new boolean[]{};
        boolean[] results = (boolean[])ConvertUtils.convert((String)"sure,nope", sample.getClass());
        BooleanArrayConverterTestCase.assertEquals((int)2, (int)results.length);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[0]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[1]);
    }

    public void testStandardStringArrayConversion() {
        String[] values = new String[]{"true", "false", "yes", "no", "y", "n", "1", "0"};
        BooleanArrayConverter converter = new BooleanArrayConverter();
        boolean[] results = (boolean[])converter.convert(null, (Object)values);
        BooleanArrayConverterTestCase.assertNotNull((Object)results);
        BooleanArrayConverterTestCase.assertEquals((int)8, (int)results.length);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[0]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[1]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[2]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[3]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[4]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[5]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[6]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[7]);
    }

    public void testStandardStringConversion() {
        BooleanArrayConverter converter = new BooleanArrayConverter();
        StringBuilder input = new StringBuilder();
        input.setLength(0);
        input.append("{true, 'yes', Y, 1, 'FALSE', \"no\", 'n', 0}");
        boolean[] results = (boolean[])converter.convert(null, (Object)input);
        BooleanArrayConverterTestCase.assertNotNull((Object)results);
        BooleanArrayConverterTestCase.assertEquals((int)8, (int)results.length);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[0]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[1]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[2]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[3]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[4]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[5]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[6]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[7]);
        input.setLength(0);
        input.append("'falsE', 'no', 'N', 0, \"truE\", yeS, 'y', '1'");
        results = (boolean[])converter.convert(null, (Object)input);
        BooleanArrayConverterTestCase.assertNotNull((Object)results);
        BooleanArrayConverterTestCase.assertEquals((int)8, (int)results.length);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[0]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[1]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[2]);
        BooleanArrayConverterTestCase.assertFalse((boolean)results[3]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[4]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[5]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[6]);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[7]);
        input.setLength(0);
        input.append("y");
        results = (boolean[])converter.convert(null, (Object)input);
        BooleanArrayConverterTestCase.assertNotNull((Object)results);
        BooleanArrayConverterTestCase.assertEquals((int)1, (int)results.length);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[0]);
        input.setLength(0);
        input.append("\"1\"");
        results = (boolean[])converter.convert(null, (Object)input);
        BooleanArrayConverterTestCase.assertNotNull((Object)results);
        BooleanArrayConverterTestCase.assertEquals((int)1, (int)results.length);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[0]);
        results = (boolean[])converter.convert(null, (Object)"'yes'");
        BooleanArrayConverterTestCase.assertNotNull((Object)results);
        BooleanArrayConverterTestCase.assertEquals((int)1, (int)results.length);
        BooleanArrayConverterTestCase.assertTrue((boolean)results[0]);
    }
}

