/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPoolingDataSource
extends TestConnectionPool {
    protected PoolingDataSource<PoolableConnection> ds;
    private GenericObjectPool<PoolableConnection> pool;

    @Override
    protected Connection getConnection() throws Exception {
        return this.ds.getConnection();
    }

    @BeforeEach
    public void setUp() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("user", "userName");
        properties.setProperty("password", "password");
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", properties), null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
        this.pool.setMaxTotal(this.getMaxTotal());
        this.pool.setMaxWait(this.getMaxWaitDuration());
        this.ds = new PoolingDataSource(this.pool);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.ds.close();
        super.tearDown();
    }

    @Test
    public void testClose() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("user", "userName");
        properties.setProperty("password", "password");
        PoolableConnectionFactory f = new PoolableConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", properties), null);
        f.setValidationQuery("SELECT DUMMY FROM DUAL");
        f.setDefaultReadOnly(Boolean.TRUE);
        f.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool p = new GenericObjectPool((PooledObjectFactory)f);
        p.setMaxTotal(this.getMaxTotal());
        p.setMaxWait(this.getMaxWaitDuration());
        try (PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)p);){
            Connection connection = dataSource.getConnection();
            Assertions.assertNotNull((Object)connection);
            connection.close();
        }
        Assertions.assertTrue((boolean)p.isClosed());
        Assertions.assertEquals((int)0, (int)p.getNumIdle());
        Assertions.assertEquals((int)0, (int)p.getNumActive());
    }

    @Test
    public void testFixFactoryConfig() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("user", "userName");
        properties.setProperty("password", "password");
        PoolableConnectionFactory f = new PoolableConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", properties), null);
        f.setValidationQuery("SELECT DUMMY FROM DUAL");
        f.setDefaultReadOnly(Boolean.TRUE);
        f.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool p = new GenericObjectPool((PooledObjectFactory)f);
        p.setMaxTotal(this.getMaxTotal());
        p.setMaxWait(this.getMaxWaitDuration());
        this.ds = new PoolingDataSource((ObjectPool)p);
        Assertions.assertEquals((Object)f.getPool(), (Object)p);
        this.ds.getConnection();
    }

    @Test
    public void testIsWrapperFor() throws Exception {
        Assertions.assertTrue((boolean)this.ds.isWrapperFor(PoolingDataSource.class));
        Assertions.assertTrue((boolean)this.ds.isWrapperFor(AutoCloseable.class));
        Assertions.assertFalse((boolean)this.ds.isWrapperFor(String.class));
        Assertions.assertFalse((boolean)this.ds.isWrapperFor(null));
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualInnermost() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        DelegatingConnection con = (DelegatingConnection)this.ds.getConnection();
        Connection inner = con.getInnermostDelegate();
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        DelegatingConnection con2 = new DelegatingConnection(inner);
        Assertions.assertNotEquals((Object)con2, (Object)con);
        Assertions.assertTrue((boolean)con.innermostDelegateEquals(con2.getInnermostDelegate()));
        Assertions.assertTrue((boolean)con2.innermostDelegateEquals(inner));
        Assertions.assertNotEquals((Object)con, (Object)con2);
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualsFail() throws Exception {
        Connection con1 = this.ds.getConnection();
        Connection con2 = this.ds.getConnection();
        Assertions.assertNotEquals((Object)con1, (Object)con2);
        con1.close();
        con2.close();
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualsNull() throws Exception {
        Connection con1 = this.ds.getConnection();
        Object con2 = null;
        Assertions.assertNotEquals(con2, (Object)con1);
        con1.close();
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualsReflexive() throws Exception {
        Connection con;
        Connection con2 = con = this.ds.getConnection();
        Assertions.assertEquals((Object)con2, (Object)con);
        Assertions.assertEquals((Object)con, (Object)con2);
        con.close();
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualsSameDelegate() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        ((DelegatingConnection)c[0]).getDelegate().close();
        Connection con = this.newConnection();
        Assertions.assertNotEquals((Object)c[0], (Object)con);
        Assertions.assertEquals((Object)((DelegatingConnection)c[0]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)con).getInnermostDelegateInternal());
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testPoolGuardConnectionWrapperEqualsType() throws Exception {
        Connection con1 = this.ds.getConnection();
        Integer con2 = 0;
        Assertions.assertNotEquals((Object)con2, (Object)con1);
        con1.close();
    }

    @Test
    public void testUnwrap() throws Exception {
        Assertions.assertSame((Object)this.ds.unwrap(PoolingDataSource.class), this.ds);
        Assertions.assertSame((Object)this.ds.unwrap(AutoCloseable.class), this.ds);
        Assertions.assertThrows(SQLException.class, () -> this.ds.unwrap(String.class));
        Assertions.assertThrows(SQLException.class, () -> this.ds.unwrap(null));
    }
}

