/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.struct;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.jcs3.utils.struct.LRUMap;

public class LRUMapConcurrentUnitTest
extends TestCase {
    private static final int items = 20000;

    public LRUMapConcurrentUnitTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LRUMapConcurrentUnitTest.class);
        final LRUMap map = new LRUMap(2000);
        suite.addTest((Test)new LRUMapConcurrentUnitTest("conc1"){

            public void runTest() throws Exception {
                this.runConcurrentPutGetTests((LRUMap<String, String>)map, 2000);
            }
        });
        suite.addTest((Test)new LRUMapConcurrentUnitTest("conc2"){

            public void runTest() throws Exception {
                this.runConcurrentPutGetTests((LRUMap<String, String>)map, 2000);
            }
        });
        suite.addTest((Test)new LRUMapConcurrentUnitTest("conc3"){

            public void runTest() throws Exception {
                this.runConcurrentPutGetTests((LRUMap<String, String>)map, 2000);
            }
        });
        int max2 = 20000;
        final LRUMap map2 = new LRUMap(20000);
        suite.addTest((Test)new LRUMapConcurrentUnitTest("concB1"){

            public void runTest() throws Exception {
                this.runConcurrentRangeTests((LRUMap<String, String>)map2, 10000, 20000);
            }
        });
        suite.addTest((Test)new LRUMapConcurrentUnitTest("concB1"){

            public void runTest() throws Exception {
                this.runConcurrentRangeTests((LRUMap<String, String>)map2, 0, 9999);
            }
        });
        return suite;
    }

    public void testSimpleLoad() throws Exception {
        int i;
        LRUMap map = new LRUMap(20000);
        for (i = 0; i < 20000; ++i) {
            map.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = 19999; i >= 0; --i) {
            String res = (String)map.get((Object)(i + ":key"));
            LRUMapConcurrentUnitTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        map.remove((Object)"300:key");
        LRUMapConcurrentUnitTest.assertNull((Object)map.get((Object)"300:key"));
    }

    public void testLRURemoval() throws Exception {
        int total = 10;
        LRUMap map = new LRUMap(10);
        for (int i = 0; i < 10; ++i) {
            map.put((Object)(i + ":key"), (Object)("data" + i));
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            LRUMapConcurrentUnitTest.assertNotNull(it.next());
        }
        for (int i = 9; i >= 0; --i) {
            String res = (String)map.get((Object)(i + ":key"));
            LRUMapConcurrentUnitTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        map.put((Object)"10:key", (Object)"data10");
        LRUMapConcurrentUnitTest.assertNull((Object)map.get((Object)"9:key"));
    }

    public void testLRURemovalAgain() throws Exception {
        int i;
        int total = 10000;
        LRUMap map = new LRUMap(10000);
        for (i = 0; i < 20000; ++i) {
            map.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = 9999; i >= 0; --i) {
            LRUMapConcurrentUnitTest.assertNull((Object)map.get((Object)(i + ":key")));
        }
        for (i = 19999; i >= 10000; --i) {
            String res = (String)map.get((Object)(i + ":key"));
            LRUMapConcurrentUnitTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
    }

    public void runConcurrentPutGetTests(LRUMap<String, String> map, int items) throws Exception {
        int i;
        for (i = 0; i < items; ++i) {
            map.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = items - 1; i >= 0; --i) {
            String res = (String)map.get((Object)(i + ":key"));
            LRUMapConcurrentUnitTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
    }

    public void runConcurrentRangeTests(LRUMap<String, String> map, int start, int end) throws Exception {
        int i;
        for (i = start; i < end; ++i) {
            map.put((Object)(i + ":key"), (Object)("data" + i));
        }
        for (i = end - 1; i >= start; --i) {
            String res = (String)map.get((Object)(i + ":key"));
            LRUMapConcurrentUnitTest.assertNotNull((String)("[" + i + ":key] should not be null"), (Object)res);
        }
        map.remove((Object)(start + ":key"));
        LRUMapConcurrentUnitTest.assertNull((Object)map.get((Object)(start + ":key")));
    }
}

