/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.text.StrLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
class StrLookupTest
extends AbstractLangTest {
    StrLookupTest() {
    }

    @Test
    void testMapLookup() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", "value");
        map.put("number", 2);
        Assertions.assertEquals((Object)"value", (Object)StrLookup.mapLookup(map).lookup("key"));
        Assertions.assertEquals((Object)"2", (Object)StrLookup.mapLookup(map).lookup("number"));
        Assertions.assertNull((Object)StrLookup.mapLookup(map).lookup(null));
        Assertions.assertNull((Object)StrLookup.mapLookup(map).lookup(""));
        Assertions.assertNull((Object)StrLookup.mapLookup(map).lookup("other"));
    }

    @Test
    void testMapLookup_nullMap() {
        Map map = null;
        Assertions.assertNull((Object)StrLookup.mapLookup(map).lookup(null));
        Assertions.assertNull((Object)StrLookup.mapLookup(map).lookup(""));
        Assertions.assertNull((Object)StrLookup.mapLookup(map).lookup("any"));
    }

    @Test
    void testNoneLookup() {
        Assertions.assertNull((Object)StrLookup.noneLookup().lookup(null));
        Assertions.assertNull((Object)StrLookup.noneLookup().lookup(""));
        Assertions.assertNull((Object)StrLookup.noneLookup().lookup("any"));
    }

    @Test
    void testSystemPropertiesLookup() {
        Assertions.assertEquals((Object)System.getProperty("os.name"), (Object)StrLookup.systemPropertiesLookup().lookup("os.name"));
        Assertions.assertNull((Object)StrLookup.systemPropertiesLookup().lookup(""));
        Assertions.assertNull((Object)StrLookup.systemPropertiesLookup().lookup("other"));
        Assertions.assertNull((Object)StrLookup.systemPropertiesLookup().lookup(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSystemPropertiesLookupReplacedProperties() {
        Properties oldProperties = System.getProperties();
        String osName = "os.name";
        String newOsName = oldProperties.getProperty("os.name") + "_changed";
        StrLookup sysLookup = StrLookup.systemPropertiesLookup();
        Properties newProps = new Properties();
        newProps.setProperty("os.name", newOsName);
        System.setProperties(newProps);
        try {
            Assertions.assertEquals((Object)newOsName, (Object)sysLookup.lookup("os.name"), (String)"Changed properties not detected");
        }
        finally {
            System.setProperties(oldProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSystemPropertiesLookupUpdatedProperty() {
        String osName = "os.name";
        String oldOs = System.getProperty("os.name");
        String newOsName = oldOs + "_changed";
        StrLookup sysLookup = StrLookup.systemPropertiesLookup();
        System.setProperty("os.name", newOsName);
        try {
            Assertions.assertEquals((Object)newOsName, (Object)sysLookup.lookup("os.name"), (String)"Changed properties not detected");
        }
        finally {
            System.setProperty("os.name", oldOs);
        }
    }
}

