/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.events.EventHandler;

public abstract class TestProblemAbstract
implements FirstOrderDifferentialEquations {
    private int n = 0;
    private int calls = 0;
    private double t0 = 0.0;
    private double[] y0 = null;
    private double t1 = 0.0;
    private double[] errorScale = null;

    protected TestProblemAbstract() {
    }

    protected void setInitialConditions(double t0, double[] y0) {
        this.calls = 0;
        this.n = y0.length;
        this.t0 = t0;
        this.y0 = (double[])y0.clone();
    }

    protected void setFinalConditions(double t1) {
        this.t1 = t1;
    }

    protected void setErrorScale(double[] errorScale) {
        this.errorScale = (double[])errorScale.clone();
    }

    public int getDimension() {
        return this.n;
    }

    public double getInitialTime() {
        return this.t0;
    }

    public double[] getInitialState() {
        return this.y0;
    }

    public double getFinalTime() {
        return this.t1;
    }

    public double[] getErrorScale() {
        return this.errorScale;
    }

    public EventHandler[] getEventsHandlers() {
        return new EventHandler[0];
    }

    public double[] getTheoreticalEventsTimes() {
        return new double[0];
    }

    public int getCalls() {
        return this.calls;
    }

    public void computeDerivatives(double t, double[] y, double[] yDot) {
        ++this.calls;
        this.doComputeDerivatives(t, y, yDot);
    }

    public abstract void doComputeDerivatives(double var1, double[] var3, double[] var4);

    public abstract double[] computeTheoreticalState(double var1);
}

