/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.util;

public final class NumberFactory {
    private static final float FLOAT_MULTIPLIER = 5.9604645E-8f;
    private static final double DOUBLE_MULTIPLIER = (double)1.110223E-16f;
    private static final long LONG_LOWEST_BYTE_MASK = 255L;
    private static final int LONG_SIZE = 8;
    private static final int INT_LOWEST_BYTE_MASK = 255;
    private static final int INT_SIZE = 4;

    private NumberFactory() {
    }

    @Deprecated
    public static boolean makeBoolean(int v) {
        return v < 0;
    }

    @Deprecated
    public static boolean makeBoolean(long v) {
        return v < 0L;
    }

    public static double makeDouble(long v) {
        return (double)(v >>> 11) * (double)1.110223E-16f;
    }

    public static double makeDouble(int v, int w) {
        long high = (long)(v >>> 6) << 27;
        int low = w >>> 5;
        return (double)(high | (long)low) * (double)1.110223E-16f;
    }

    public static float makeFloat(int v) {
        return (float)(v >>> 8) * 5.9604645E-8f;
    }

    public static long makeLong(int v, int w) {
        return (long)v << 32 | (long)w & 0xFFFFFFFFL;
    }

    @Deprecated
    public static int makeInt(long v) {
        return NumberFactory.extractHi(v) ^ NumberFactory.extractLo(v);
    }

    public static int extractHi(long v) {
        return (int)(v >>> 32);
    }

    public static int extractLo(long v) {
        return (int)v;
    }

    public static byte[] makeByteArray(long v) {
        byte[] b = new byte[8];
        NumberFactory.putLong(v, b, 0);
        return b;
    }

    private static void putLong(long v, byte[] buffer, int index) {
        buffer[index] = (byte)(v & 0xFFL);
        buffer[index + 1] = (byte)(v >>> 8 & 0xFFL);
        buffer[index + 2] = (byte)(v >>> 16 & 0xFFL);
        buffer[index + 3] = (byte)(v >>> 24 & 0xFFL);
        buffer[index + 4] = (byte)(v >>> 32 & 0xFFL);
        buffer[index + 5] = (byte)(v >>> 40 & 0xFFL);
        buffer[index + 6] = (byte)(v >>> 48 & 0xFFL);
        buffer[index + 7] = (byte)(v >>> 56);
    }

    public static long makeLong(byte[] input) {
        NumberFactory.checkSize(8, input.length);
        return NumberFactory.getLong(input, 0);
    }

    private static long getLong(byte[] input, int index) {
        return (long)input[index] & 0xFFL | ((long)input[index + 1] & 0xFFL) << 8 | ((long)input[index + 2] & 0xFFL) << 16 | ((long)input[index + 3] & 0xFFL) << 24 | ((long)input[index + 4] & 0xFFL) << 32 | ((long)input[index + 5] & 0xFFL) << 40 | ((long)input[index + 6] & 0xFFL) << 48 | ((long)input[index + 7] & 0xFFL) << 56;
    }

    public static byte[] makeByteArray(long[] input) {
        int size = input.length * 8;
        byte[] b = new byte[size];
        for (int i = 0; i < input.length; ++i) {
            NumberFactory.putLong(input[i], b, i * 8);
        }
        return b;
    }

    public static long[] makeLongArray(byte[] input) {
        int size = input.length;
        int num = size / 8;
        NumberFactory.checkSize(num * 8, size);
        long[] output = new long[num];
        for (int i = 0; i < num; ++i) {
            output[i] = NumberFactory.getLong(input, i * 8);
        }
        return output;
    }

    public static byte[] makeByteArray(int v) {
        byte[] b = new byte[4];
        NumberFactory.putInt(v, b, 0);
        return b;
    }

    private static void putInt(int v, byte[] buffer, int index) {
        buffer[index] = (byte)(v & 0xFF);
        buffer[index + 1] = (byte)(v >>> 8 & 0xFF);
        buffer[index + 2] = (byte)(v >>> 16 & 0xFF);
        buffer[index + 3] = (byte)(v >>> 24);
    }

    public static int makeInt(byte[] input) {
        NumberFactory.checkSize(4, input.length);
        return NumberFactory.getInt(input, 0);
    }

    private static int getInt(byte[] input, int index) {
        return input[index] & 0xFF | (input[index + 1] & 0xFF) << 8 | (input[index + 2] & 0xFF) << 16 | (input[index + 3] & 0xFF) << 24;
    }

    public static byte[] makeByteArray(int[] input) {
        int size = input.length * 4;
        byte[] b = new byte[size];
        for (int i = 0; i < input.length; ++i) {
            NumberFactory.putInt(input[i], b, i * 4);
        }
        return b;
    }

    public static int[] makeIntArray(byte[] input) {
        int size = input.length;
        int num = size / 4;
        NumberFactory.checkSize(num * 4, size);
        int[] output = new int[num];
        for (int i = 0; i < num; ++i) {
            output[i] = NumberFactory.getInt(input, i * 4);
        }
        return output;
    }

    private static void checkSize(int expected, int actual) {
        if (expected != actual) {
            throw new IllegalArgumentException("Array size: Expected " + expected + " but was " + actual);
        }
    }
}

