/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import org.apache.commons.rng.UniformRandomProvider;

public final class ArraySampler {
    private ArraySampler() {
    }

    public static boolean[] shuffle(UniformRandomProvider rng, boolean[] array) {
        for (int i = array.length; i > 1; --i) {
            ArraySampler.swap(array, i - 1, rng.nextInt(i));
        }
        return array;
    }

    public static byte[] shuffle(UniformRandomProvider rng, byte[] array) {
        for (int i = array.length; i > 1; --i) {
            ArraySampler.swap(array, i - 1, rng.nextInt(i));
        }
        return array;
    }

    public static char[] shuffle(UniformRandomProvider rng, char[] array) {
        for (int i = array.length; i > 1; --i) {
            ArraySampler.swap(array, i - 1, rng.nextInt(i));
        }
        return array;
    }

    public static double[] shuffle(UniformRandomProvider rng, double[] array) {
        for (int i = array.length; i > 1; --i) {
            ArraySampler.swap(array, i - 1, rng.nextInt(i));
        }
        return array;
    }

    public static float[] shuffle(UniformRandomProvider rng, float[] array) {
        for (int i = array.length; i > 1; --i) {
            ArraySampler.swap(array, i - 1, rng.nextInt(i));
        }
        return array;
    }

    public static int[] shuffle(UniformRandomProvider rng, int[] array) {
        for (int i = array.length; i > 1; --i) {
            ArraySampler.swap(array, i - 1, rng.nextInt(i));
        }
        return array;
    }

    public static long[] shuffle(UniformRandomProvider rng, long[] array) {
        for (int i = array.length; i > 1; --i) {
            ArraySampler.swap(array, i - 1, rng.nextInt(i));
        }
        return array;
    }

    public static short[] shuffle(UniformRandomProvider rng, short[] array) {
        for (int i = array.length; i > 1; --i) {
            ArraySampler.swap(array, i - 1, rng.nextInt(i));
        }
        return array;
    }

    public static <T> T[] shuffle(UniformRandomProvider rng, T[] array) {
        for (int i = array.length; i > 1; --i) {
            ArraySampler.swap(array, i - 1, rng.nextInt(i));
        }
        return array;
    }

    public static boolean[] shuffle(UniformRandomProvider rng, boolean[] array, int from, int to) {
        int length;
        for (int i = length = to - ArraySampler.checkFromToIndex(from, to, array.length); i > 1; --i) {
            ArraySampler.swap(array, from + i - 1, from + rng.nextInt(i));
        }
        return array;
    }

    public static byte[] shuffle(UniformRandomProvider rng, byte[] array, int from, int to) {
        int length;
        for (int i = length = to - ArraySampler.checkFromToIndex(from, to, array.length); i > 1; --i) {
            ArraySampler.swap(array, from + i - 1, from + rng.nextInt(i));
        }
        return array;
    }

    public static char[] shuffle(UniformRandomProvider rng, char[] array, int from, int to) {
        int length;
        for (int i = length = to - ArraySampler.checkFromToIndex(from, to, array.length); i > 1; --i) {
            ArraySampler.swap(array, from + i - 1, from + rng.nextInt(i));
        }
        return array;
    }

    public static double[] shuffle(UniformRandomProvider rng, double[] array, int from, int to) {
        int length;
        for (int i = length = to - ArraySampler.checkFromToIndex(from, to, array.length); i > 1; --i) {
            ArraySampler.swap(array, from + i - 1, from + rng.nextInt(i));
        }
        return array;
    }

    public static float[] shuffle(UniformRandomProvider rng, float[] array, int from, int to) {
        int length;
        for (int i = length = to - ArraySampler.checkFromToIndex(from, to, array.length); i > 1; --i) {
            ArraySampler.swap(array, from + i - 1, from + rng.nextInt(i));
        }
        return array;
    }

    public static int[] shuffle(UniformRandomProvider rng, int[] array, int from, int to) {
        int length;
        for (int i = length = to - ArraySampler.checkFromToIndex(from, to, array.length); i > 1; --i) {
            ArraySampler.swap(array, from + i - 1, from + rng.nextInt(i));
        }
        return array;
    }

    public static long[] shuffle(UniformRandomProvider rng, long[] array, int from, int to) {
        int length;
        for (int i = length = to - ArraySampler.checkFromToIndex(from, to, array.length); i > 1; --i) {
            ArraySampler.swap(array, from + i - 1, from + rng.nextInt(i));
        }
        return array;
    }

    public static short[] shuffle(UniformRandomProvider rng, short[] array, int from, int to) {
        int length;
        for (int i = length = to - ArraySampler.checkFromToIndex(from, to, array.length); i > 1; --i) {
            ArraySampler.swap(array, from + i - 1, from + rng.nextInt(i));
        }
        return array;
    }

    public static <T> T[] shuffle(UniformRandomProvider rng, T[] array, int from, int to) {
        int length;
        for (int i = length = to - ArraySampler.checkFromToIndex(from, to, array.length); i > 1; --i) {
            ArraySampler.swap(array, from + i - 1, from + rng.nextInt(i));
        }
        return array;
    }

    private static void swap(boolean[] array, int i, int j) {
        boolean tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static void swap(byte[] array, int i, int j) {
        byte tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static void swap(char[] array, int i, int j) {
        char tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static void swap(double[] array, int i, int j) {
        double tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static void swap(float[] array, int i, int j) {
        float tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static void swap(int[] array, int i, int j) {
        int tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static void swap(long[] array, int i, int j) {
        long tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static void swap(short[] array, int i, int j) {
        short tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static void swap(Object[] array, int i, int j) {
        Object tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    private static int checkFromToIndex(int fromIndex, int toIndex, int length) {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > length) {
            throw new IndexOutOfBoundsException(String.format("Range [%d, %d) out of bounds for length %d", fromIndex, toIndex, length));
        }
        return fromIndex;
    }
}

