/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.SizeFileFilter;
import org.apache.commons.vfs2.filter.SizeRangeFileFilter;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SizeFileFilterTest
extends BaseFilterTest {
    private static File testDir;
    private static File minFile;
    private static FileSelectInfo minFileInfo;
    private static File optFile;
    private static FileSelectInfo optFileInfo;
    private static File maxFile;
    private static FileSelectInfo maxFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @AfterAll
    public static void afterClass() throws IOException {
        minFileInfo = null;
        minFile = null;
        optFileInfo = null;
        optFile = null;
        maxFileInfo = null;
        maxFile = null;
        IOUtils.close((Closeable)zipFileObj);
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @BeforeAll
    public static void beforeClass() throws IOException {
        testDir = SizeFileFilterTest.getTestDir(SizeFileFilterTest.class.getName());
        minFile = new File(testDir, "min.txt");
        FileUtils.write((File)minFile, (CharSequence)"12");
        minFileInfo = SizeFileFilterTest.createFileSelectInfo(minFile);
        optFile = new File(testDir, "opt.txt");
        FileUtils.write((File)optFile, (CharSequence)"1234");
        optFileInfo = SizeFileFilterTest.createFileSelectInfo(optFile);
        maxFile = new File(testDir, "max.txt");
        FileUtils.write((File)maxFile, (CharSequence)"123456");
        maxFileInfo = SizeFileFilterTest.createFileSelectInfo(maxFile);
        zipFile = new File(SizeFileFilterTest.getTempDir(), SizeFileFilterTest.class.getName() + ".zip");
        SizeFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = SizeFileFilterTest.getZipFileObject(zipFile);
    }

    @Test
    public void testSizeFileFilterLong() throws FileSystemException {
        SizeFileFilter testee = new SizeFileFilter(4L);
        Assertions.assertFalse((boolean)testee.accept(minFileInfo));
        Assertions.assertTrue((boolean)testee.accept(optFileInfo));
        Assertions.assertTrue((boolean)testee.accept(maxFileInfo));
    }

    @Test
    public void testSizeFileFilterLongBoolean() throws FileSystemException {
        SizeFileFilter testee = new SizeFileFilter(4L, true);
        Assertions.assertFalse((boolean)testee.accept(minFileInfo));
        Assertions.assertTrue((boolean)testee.accept(optFileInfo));
        Assertions.assertTrue((boolean)testee.accept(maxFileInfo));
        testee = new SizeFileFilter(4L, false);
        Assertions.assertTrue((boolean)testee.accept(minFileInfo));
        Assertions.assertFalse((boolean)testee.accept(optFileInfo));
        Assertions.assertFalse((boolean)testee.accept(maxFileInfo));
    }

    @Test
    public void testSizeFileFilterZipDir() throws FileSystemException {
        FileObject[] files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeFileFilter(4L, true)));
        this.assertContains(files, optFile.getName(), maxFile.getName());
        Assertions.assertEquals((int)2, (int)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeFileFilter(4L, false)));
        this.assertContains(files, minFile.getName());
        Assertions.assertEquals((int)1, (int)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeRangeFileFilter(2L, 6L)));
        this.assertContains(files, minFile.getName(), optFile.getName(), maxFile.getName());
        Assertions.assertEquals((int)3, (int)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeRangeFileFilter(3L, 6L)));
        this.assertContains(files, optFile.getName(), maxFile.getName());
        Assertions.assertEquals((int)2, (int)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeRangeFileFilter(2L, 5L)));
        this.assertContains(files, minFile.getName(), optFile.getName());
        Assertions.assertEquals((int)2, (int)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeRangeFileFilter(3L, 5L)));
        this.assertContains(files, optFile.getName());
        Assertions.assertEquals((int)1, (int)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector((FileFilter)new SizeRangeFileFilter(4L, 4L)));
        this.assertContains(files, optFile.getName());
        Assertions.assertEquals((int)1, (int)files.length);
    }

    @Test
    public void testSizeRangeFileFilter() throws FileSystemException {
        SizeRangeFileFilter testee = new SizeRangeFileFilter(2L, 6L);
        Assertions.assertTrue((boolean)testee.accept(minFileInfo));
        Assertions.assertTrue((boolean)testee.accept(optFileInfo));
        Assertions.assertTrue((boolean)testee.accept(maxFileInfo));
        testee = new SizeRangeFileFilter(3L, 6L);
        Assertions.assertFalse((boolean)testee.accept(minFileInfo));
        Assertions.assertTrue((boolean)testee.accept(optFileInfo));
        Assertions.assertTrue((boolean)testee.accept(maxFileInfo));
        testee = new SizeRangeFileFilter(2L, 5L);
        Assertions.assertTrue((boolean)testee.accept(minFileInfo));
        Assertions.assertTrue((boolean)testee.accept(optFileInfo));
        Assertions.assertFalse((boolean)testee.accept(maxFileInfo));
        testee = new SizeRangeFileFilter(3L, 5L);
        Assertions.assertFalse((boolean)testee.accept(minFileInfo));
        Assertions.assertTrue((boolean)testee.accept(optFileInfo));
        Assertions.assertFalse((boolean)testee.accept(maxFileInfo));
        testee = new SizeRangeFileFilter(4L, 4L);
        Assertions.assertFalse((boolean)testee.accept(minFileInfo));
        Assertions.assertTrue((boolean)testee.accept(optFileInfo));
        Assertions.assertFalse((boolean)testee.accept(maxFileInfo));
    }
}

