/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.utils.ExtendedIterator;

public final class ExclusionUtils {
    public static final List<String> COMMENT_PREFIXES = Arrays.asList("#", "##", "//", "/**", "/*");
    public static final Predicate<String> NOT_MATCH_FILTER = s -> s.startsWith("!");
    public static final Predicate<String> MATCH_FILTER = s -> !s.startsWith("!");

    private ExclusionUtils() {
    }

    public static Predicate<String> commentFilter(Iterable<String> commentPrefixes) {
        return s -> {
            if (StringUtils.isNotBlank(s)) {
                int i2 = 1;
                while (StringUtils.isBlank(s.substring(0, i2))) {
                    ++i2;
                }
                String trimmed = i2 > 0 ? s.substring(i2 - 1) : s;
                for (String prefix : commentPrefixes) {
                    if (!trimmed.startsWith(prefix)) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    public static Predicate<String> commentFilter(String commentPrefix) {
        return s -> {
            if (StringUtils.isNotBlank(s)) {
                int i2 = 1;
                while (StringUtils.isBlank(s.substring(0, i2))) {
                    ++i2;
                }
                String trimmed = i2 > 0 ? s.substring(i2 - 1) : s;
                return !trimmed.startsWith(commentPrefix);
            }
            return false;
        };
    }

    public static FileFilter asFileFilter(DocumentName parent, DocumentNameMatcher nameMatcher) {
        return file -> nameMatcher.matches(new DocumentName(file, parent));
    }

    public static ExtendedIterator<String> asIterator(File patternFile, Predicate<String> commentFilters) {
        ExclusionUtils.verifyFile(patternFile);
        Objects.requireNonNull(commentFilters, "commentFilters");
        try {
            return ExtendedIterator.create(IOUtils.lineIterator(new FileReader(patternFile))).filter(commentFilters);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(String.format("%s is not a valid file.", patternFile));
        }
    }

    public static Iterable<String> asIterable(File patternFile, String commentPrefix) {
        return ExclusionUtils.asIterable(patternFile, ExclusionUtils.commentFilter(commentPrefix));
    }

    public static Iterable<String> asIterable(File patternFile, final Predicate<String> commentFilters) {
        ArrayList<String> arrayList;
        ExclusionUtils.verifyFile(patternFile);
        Objects.requireNonNull(commentFilters, "commentFilters");
        FileReader reader = new FileReader(patternFile);
        try {
            ArrayList<String> result = new ArrayList<String>();
            LineIterator iter = new LineIterator(reader){

                @Override
                protected boolean isValidLine(String line) {
                    return commentFilters.test(line);
                }
            };
            iter.forEachRemaining(result::add);
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to read file " + patternFile, e);
            }
        }
        reader.close();
        return arrayList;
    }

    public static boolean isHidden(File f) {
        String s = f.getName();
        return s.startsWith(".") && !s.equals(".") && !s.equals("..");
    }

    private static void verifyFile(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new ConfigurationException(String.format("%s is not a valid file.", file));
        }
    }
}

