/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.source;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SourceTransformerSaxHandler
extends DefaultHandler {
    private static Log log = LogFactory.getLog(DefaultHandler.class);
    private SourceTransformer sourceTransformer;
    private String elements;
    private int level = 0;
    private String propertyName;
    private StringBuilder simplePropertyValue;
    private ArrayList<String> listPropertyValue;
    private StringBuilder listPropertyEntry;

    public SourceTransformerSaxHandler(ConfigurationProvider configurationProvider, ProjectPaths projectPaths) {
        if (configurationProvider == null) {
            throw new NullPointerException("configurationProvider must not be null");
        }
        if (projectPaths == null) {
            throw new NullPointerException("projectPaths must not be null");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (this.level == 0) {
            ++this.level;
            if (!rawName.equals("transformer")) throw new SAXException("Unknown element " + rawName);
            String className = attributes.getValue("class");
            if (className == null) {
                throw new SAXException("The attribute class must not be null for the element transformer");
            }
            this.elements = attributes.getValue("elements");
            this.sourceTransformer = SourceTransformerSaxHandler.createJavaSourceTransformer(className);
            return;
        } else if (this.level == 1) {
            ++this.level;
            this.propertyName = rawName;
            this.simplePropertyValue = new StringBuilder();
            return;
        } else {
            if (this.level != 2) throw new SAXException("unknown Element " + rawName);
            ++this.level;
            if (this.simplePropertyValue.length() > 0 && !StringUtils.isWhitespace((String)this.simplePropertyValue.toString())) {
                throw new SAXException("Cannot parse both text content and child elements  in element " + this.propertyName);
            }
            this.simplePropertyValue = null;
            if (this.listPropertyValue == null) {
                this.listPropertyValue = new ArrayList();
            }
            this.listPropertyEntry = new StringBuilder();
        }
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        --this.level;
        if (this.level == 2) {
            this.listPropertyValue.add(this.listPropertyEntry.toString());
            this.listPropertyEntry = null;
        } else if (this.level == 1) {
            if (!PropertyUtils.isWriteable((Object)this.sourceTransformer, (String)this.propertyName)) {
                throw new SAXException("No setter found for property " + this.propertyName + " in class " + this.sourceTransformer.getClass().getName());
            }
            Object propertyValue = this.simplePropertyValue != null ? this.simplePropertyValue.toString() : this.listPropertyValue;
            try {
                BeanUtils.copyProperty((Object)this.sourceTransformer, (String)this.propertyName, (Object)propertyValue);
            }
            catch (InvocationTargetException e) {
                throw new SAXException("error while setting Property " + this.propertyName + " for java transformer " + this.sourceTransformer.getClass().getName() + " with value " + propertyValue.toString(), e);
            }
            catch (IllegalAccessException e) {
                throw new SAXException("error while setting Property " + this.propertyName + " for java transformer " + this.sourceTransformer.getClass().getName() + " with value " + propertyValue.toString(), e);
            }
            this.propertyName = null;
            propertyValue = null;
        } else if (this.level != 0) {
            throw new SAXException("endElemend reached Level " + this.level);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.simplePropertyValue != null) {
            for (int i = start; i < start + length; ++i) {
                this.simplePropertyValue.append(ch[i]);
            }
            return;
        }
        if (this.listPropertyEntry != null) {
            for (int i = start; i < start + length; ++i) {
                this.listPropertyEntry.append(ch[i]);
            }
            return;
        }
    }

    public SourceTransformer getSourceTransformer() {
        return this.sourceTransformer;
    }

    public String getElements() {
        return this.elements;
    }

    public boolean isFinished() {
        return this.sourceTransformer != null && this.level == 0;
    }

    private static SourceTransformer createJavaSourceTransformer(String className) throws SAXException {
        SourceTransformer result;
        Class<?> transformerClass;
        try {
            transformerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SAXException("Error  while initializing a source transformer : Could not load class " + className, e);
        }
        catch (ExceptionInInitializerError e) {
            log.error((Object)("Error  while initializing a source transformer : Could not initialize class " + className + " : " + e.getMessage()));
            throw e;
        }
        catch (LinkageError e) {
            log.error((Object)("Error  while initializing a source transformer : Could not link class " + className + " : " + e.getMessage()));
            throw e;
        }
        try {
            Constructor<?> constructor = transformerClass.getConstructor(new Class[0]);
            result = (SourceTransformer)constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new SAXException("Error  while instantiating a source transformer : The class " + className + " has no default constructor", e);
        }
        catch (ClassCastException e) {
            throw new SAXException("Error  while instantiating a source transformer : The class " + className + " is not an instance of " + SourceTransformer.class.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException("Error  while instantiating a source transformer : The constructor of class " + className + " could not be accessed", e);
        }
        catch (InvocationTargetException e) {
            throw new SAXException("Error  while instantiating a source transformer : The constructor of class " + className + " could not be called", e);
        }
        catch (InstantiationException e) {
            throw new SAXException("Error  while instantiating a source transformer : The class " + className + " represents an abstract class, " + "an interface, an array class, a primitive type, " + "or void, or the class has no parameterless constructor, " + "or the instantiation fails for some other reason.", e);
        }
        catch (SecurityException e) {
            throw new SAXException("Error  while instantiating a source transformer : The security manager denies instantiation of the class " + className, e);
        }
        return result;
    }
}

