/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.ClientException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;

public class RoutingRule {
    private Integer number;
    private Condition condition = new Condition();
    private Redirect redirect = new Redirect();

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public Redirect getRedirect() {
        return this.redirect;
    }

    public void setRedirect(Redirect redirect) {
        this.redirect = redirect;
    }

    public void ensureRoutingRuleValid() {
        if (this.number == null || this.number <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("RoutingRuleNumberInvalid", this.number));
        }
        this.redirect.ensureRedirectValid();
        this.condition.ensureConditionValid();
    }

    public static class Redirect {
        private RedirectType redirectType;
        private String hostName;
        private Protocol protocol;
        private String replaceKeyPrefixWith;
        private String replaceKeyWith;
        private Integer httpRedirectCode;
        private String mirrorURL;
        private String mirrorSecondaryURL;
        private String mirrorProbeURL;
        private Boolean passQueryString;
        private Boolean mirrorPassQueryString;
        private Boolean passOriginalSlashes;
        private Boolean mirrorFollowRedirect = true;
        private Boolean mirrorUserLastModified;
        private Boolean mirrorIsExpressTunnel;
        private String mirrorDstRegion;
        private String mirrorDstVpcId;
        private MirrorHeaders mirrorHeaders;
        private List<MirrorMultiAlternate> mirrorMultiAlternates;
        private String mirrorRole;
        private Boolean mirrorUsingRole;
        private Boolean enableReplacePrefix;
        private Boolean mirrorSwitchAllErrors;
        private Boolean mirrorCheckMd5;
        private String mirrorTunnelId;

        public RedirectType getRedirectType() {
            return this.redirectType;
        }

        public void setRedirectType(RedirectType redirectType) {
            this.redirectType = redirectType;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public void setProtocol(Protocol protocol) {
            this.protocol = protocol;
        }

        public String getReplaceKeyPrefixWith() {
            return this.replaceKeyPrefixWith;
        }

        public void setReplaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
        }

        public String getReplaceKeyWith() {
            return this.replaceKeyWith;
        }

        public void setReplaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
        }

        public Integer getHttpRedirectCode() {
            return this.httpRedirectCode;
        }

        public void setHttpRedirectCode(Integer httpRedirectCode) {
            if (httpRedirectCode == null) {
                return;
            }
            if (httpRedirectCode < 300 || httpRedirectCode > 399) {
                throw new IllegalArgumentException(MessageFormat.format("RedirectHttpRedirectCodeInvalid", "HttpRedirectCode must be a valid HTTP 3xx status code."));
            }
            this.httpRedirectCode = httpRedirectCode;
        }

        public String getMirrorURL() {
            return this.mirrorURL;
        }

        public void setMirrorURL(String mirrorURL) {
            this.mirrorURL = mirrorURL;
        }

        public List<MirrorMultiAlternate> getMirrorMultiAlternates() {
            return this.mirrorMultiAlternates;
        }

        public void setMirrorMultiAlternates(List<MirrorMultiAlternate> mirrorMultiAlternates) {
            this.mirrorMultiAlternates = mirrorMultiAlternates;
        }

        public String getMirrorSecondaryURL() {
            return this.mirrorSecondaryURL;
        }

        public void setMirrorSecondaryURL(String mirrorSecondaryURL) {
            this.mirrorSecondaryURL = mirrorSecondaryURL;
        }

        public String getMirrorProbeURL() {
            return this.mirrorProbeURL;
        }

        public void setMirrorProbeURL(String mirrorProbeURL) {
            this.mirrorProbeURL = mirrorProbeURL;
        }

        public Boolean isMirrorPassQueryString() {
            return this.mirrorPassQueryString;
        }

        public void setMirrorPassQueryString(Boolean mirrorPassQueryString) {
            this.mirrorPassQueryString = mirrorPassQueryString;
        }

        public Boolean isPassQueryString() {
            return this.passQueryString;
        }

        public void setPassQueryString(Boolean passQueryString) {
            this.passQueryString = passQueryString;
        }

        public Boolean isPassOriginalSlashes() {
            return this.passOriginalSlashes;
        }

        public void setPassOriginalSlashes(Boolean passOriginalSlashes) {
            this.passOriginalSlashes = passOriginalSlashes;
        }

        public Boolean isMirrorFollowRedirect() {
            return this.mirrorFollowRedirect;
        }

        public void setMirrorFollowRedirect(Boolean mirrorFollowRedirect) {
            this.mirrorFollowRedirect = mirrorFollowRedirect;
        }

        public Boolean isMirrorUserLastModified() {
            return this.mirrorUserLastModified;
        }

        public void setMirrorUserLastModified(Boolean mirrorUserLastModified) {
            this.mirrorUserLastModified = mirrorUserLastModified;
        }

        public Boolean isMirrorIsExpressTunnel() {
            return this.mirrorIsExpressTunnel;
        }

        public void setMirrorIsExpressTunnel(Boolean mirrorIsExpressTunnel) {
            this.mirrorIsExpressTunnel = mirrorIsExpressTunnel;
        }

        public String getMirrorDstRegion() {
            return this.mirrorDstRegion;
        }

        public void setMirrorDstRegion(String mirrorDstRegion) {
            this.mirrorDstRegion = mirrorDstRegion;
        }

        public String getMirrorDstVpcId() {
            return this.mirrorDstVpcId;
        }

        public void setMirrorDstVpcId(String mirrorDstVpcId) {
            this.mirrorDstVpcId = mirrorDstVpcId;
        }

        public MirrorHeaders getMirrorHeaders() {
            return this.mirrorHeaders;
        }

        public void setMirrorHeaders(MirrorHeaders mirrorHeaders) {
            this.mirrorHeaders = mirrorHeaders;
        }

        public Boolean getMirrorPassQueryString() {
            return this.mirrorPassQueryString;
        }

        public String getMirrorRole() {
            return this.mirrorRole;
        }

        public void setMirrorRole(String mirrorRole) {
            this.mirrorRole = mirrorRole;
        }

        public Boolean isMirrorUsingRole() {
            return this.mirrorUsingRole;
        }

        public void setMirrorUsingRole(Boolean mirrorUsingRole) {
            this.mirrorUsingRole = mirrorUsingRole;
        }

        public Boolean isEnableReplacePrefix() {
            return this.enableReplacePrefix;
        }

        public void setEnableReplacePrefix(Boolean enableReplacePrefix) {
            this.enableReplacePrefix = enableReplacePrefix;
        }

        public Boolean isMirrorSwitchAllErrors() {
            return this.mirrorSwitchAllErrors;
        }

        public void setMirrorSwitchAllErrors(Boolean mirrorSwitchAllErrors) {
            this.mirrorSwitchAllErrors = mirrorSwitchAllErrors;
        }

        public Boolean isMirrorCheckMd5() {
            return this.mirrorCheckMd5;
        }

        public void setMirrorCheckMd5(Boolean mirrorCheckMd5) {
            this.mirrorCheckMd5 = mirrorCheckMd5;
        }

        public void ensureRedirectValid() {
            if (this.hostName == null && this.protocol == null && this.replaceKeyPrefixWith == null && this.replaceKeyWith == null && this.httpRedirectCode == null && this.mirrorURL == null) {
                throw new IllegalArgumentException(MessageFormat.format("RoutingRuleRedirectInvalid", "Redirect element must contain at least one of the sibling elements"));
            }
            if (this.replaceKeyPrefixWith != null && this.replaceKeyWith != null) {
                throw new IllegalArgumentException(MessageFormat.format("RoutingRuleRedirectInvalid", "ReplaceKeyPrefixWith or ReplaceKeyWith only choose one"));
            }
            if (this.redirectType == RedirectType.Mirror && this.mirrorURL == null) {
                throw new IllegalArgumentException(MessageFormat.format("RoutingRuleRedirectInvalid", "MirrorURL must have a value"));
            }
            if (!(this.redirectType != RedirectType.Mirror || (this.mirrorURL.startsWith("http://") || this.mirrorURL.startsWith("https://")) && this.mirrorURL.endsWith("/"))) {
                throw new IllegalArgumentException(MessageFormat.format("RoutingRuleRedirectInvalid", "MirrorURL is invalid", this.mirrorURL));
            }
        }

        public String getMirrorTunnelId() {
            return this.mirrorTunnelId;
        }

        public void setMirrorTunnelId(String mirrorTunnelId) {
            this.mirrorTunnelId = mirrorTunnelId;
        }

        public static class MirrorMultiAlternate {
            private Integer prior;
            private String url;

            public Integer getPrior() {
                return this.prior;
            }

            public void setPrior(Integer prior) throws ClientException {
                if (prior < 1 || prior > 10000) {
                    throw new ClientException("The specified prior is not valid", "InvalidArgument", null);
                }
                this.prior = prior;
            }

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }
        }
    }

    public static class MirrorHeaders {
        private boolean passAll;
        private List<String> pass;
        private List<String> remove;
        private List<Map<String, String>> set;

        public boolean isPassAll() {
            return this.passAll;
        }

        public void setPassAll(boolean passAll) {
            this.passAll = passAll;
        }

        public List<String> getPass() {
            return this.pass;
        }

        public void setPass(List<String> pass) {
            this.pass = pass;
        }

        public List<String> getRemove() {
            return this.remove;
        }

        public void setRemove(List<String> remove) {
            this.remove = remove;
        }

        public List<Map<String, String>> getSet() {
            return this.set;
        }

        public void setSet(List<Map<String, String>> set) {
            this.set = set;
        }
    }

    public static enum Protocol {
        Http("http"),
        Https("https");

        private String protocolString;

        private Protocol(String protocolString) {
            this.protocolString = protocolString;
        }

        public String toString() {
            return this.protocolString;
        }

        public static Protocol parse(String protocolString) {
            for (Protocol protocol : Protocol.values()) {
                if (!protocol.toString().equals(protocolString)) continue;
                return protocol;
            }
            throw new IllegalArgumentException("Unable to parse " + protocolString);
        }
    }

    public static enum RedirectType {
        Internal("Internal"),
        External("External"),
        AliCDN("AliCDN"),
        Mirror("Mirror");

        private String redirectTypeString;

        private RedirectType(String redirectTypeString) {
            this.redirectTypeString = redirectTypeString;
        }

        public String toString() {
            return this.redirectTypeString;
        }

        public static RedirectType parse(String redirectTypeString) {
            for (RedirectType rt : RedirectType.values()) {
                if (!rt.toString().equals(redirectTypeString)) continue;
                return rt;
            }
            throw new IllegalArgumentException("Unable to parse " + redirectTypeString);
        }
    }

    public static class IncludeHeader {
        private String key;
        private String equals;
        private String startsWith;
        private String endsWith;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getEquals() {
            return this.equals;
        }

        public void setEquals(String equals) {
            this.equals = equals;
        }

        public String getStartsWith() {
            return this.startsWith;
        }

        public void setStartsWith(String startsWith) {
            this.startsWith = startsWith;
        }

        public String getEndsWith() {
            return this.endsWith;
        }

        public void setEndsWith(String endsWith) {
            this.endsWith = endsWith;
        }
    }

    public static class Condition {
        private String keyPrefixEquals;
        private String keySuffixEquals;
        private Integer httpErrorCodeReturnedEquals;
        private List<IncludeHeader> includeHeaders;

        public String getKeyPrefixEquals() {
            return this.keyPrefixEquals;
        }

        public void setKeyPrefixEquals(String keyPrefixEquals) {
            this.keyPrefixEquals = keyPrefixEquals;
        }

        public Integer getHttpErrorCodeReturnedEquals() {
            return this.httpErrorCodeReturnedEquals;
        }

        public void setHttpErrorCodeReturnedEquals(Integer httpErrorCodeReturnedEquals) {
            if (httpErrorCodeReturnedEquals == null) {
                return;
            }
            if (httpErrorCodeReturnedEquals <= 0) {
                throw new IllegalArgumentException(MessageFormat.format("HttpErrorCodeReturnedEqualsInvalid", "HttpErrorCodeReturnedEquals should be greater than 0"));
            }
            this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
        }

        public void ensureConditionValid() {
        }

        public String getKeySuffixEquals() {
            return this.keySuffixEquals;
        }

        public void setKeySuffixEquals(String keySuffixEquals) {
            this.keySuffixEquals = keySuffixEquals;
        }

        public List<IncludeHeader> getIncludeHeaders() {
            return this.includeHeaders;
        }

        public void setIncludeHeaders(List<IncludeHeader> includeHeaders) {
            this.includeHeaders = includeHeaders;
        }
    }
}

