/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.resource;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class ResourceContext {
    private final Map<String, ResourceItem> resourceItemMap = new HashMap<String, ResourceItem>();

    public void addResourceItem(ResourceItem resourceItem) {
        Preconditions.checkNotNull((Object)resourceItem);
        this.resourceItemMap.put(resourceItem.getResourceAbsolutePathInStorage(), resourceItem);
    }

    public ResourceItem getResourceItem(String resourceAbsolutePathInStorage) {
        ResourceItem resourceItem = this.resourceItemMap.get(resourceAbsolutePathInStorage);
        if (resourceItem == null) {
            throw new IllegalArgumentException("Cannot find the resourceItem: " + resourceAbsolutePathInStorage);
        }
        return resourceItem;
    }

    @Generated
    public String toString() {
        return "ResourceContext(resourceItemMap=" + this.resourceItemMap + ")";
    }

    public static class ResourceItem {
        private String resourceAbsolutePathInStorage;
        private String resourceAbsolutePathInLocal;

        @Generated
        public static ResourceItemBuilder builder() {
            return new ResourceItemBuilder();
        }

        @Generated
        public String getResourceAbsolutePathInStorage() {
            return this.resourceAbsolutePathInStorage;
        }

        @Generated
        public String getResourceAbsolutePathInLocal() {
            return this.resourceAbsolutePathInLocal;
        }

        @Generated
        public void setResourceAbsolutePathInStorage(String resourceAbsolutePathInStorage) {
            this.resourceAbsolutePathInStorage = resourceAbsolutePathInStorage;
        }

        @Generated
        public void setResourceAbsolutePathInLocal(String resourceAbsolutePathInLocal) {
            this.resourceAbsolutePathInLocal = resourceAbsolutePathInLocal;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceItem)) {
                return false;
            }
            ResourceItem other = (ResourceItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$resourceAbsolutePathInStorage = this.getResourceAbsolutePathInStorage();
            String other$resourceAbsolutePathInStorage = other.getResourceAbsolutePathInStorage();
            if (this$resourceAbsolutePathInStorage == null ? other$resourceAbsolutePathInStorage != null : !this$resourceAbsolutePathInStorage.equals(other$resourceAbsolutePathInStorage)) {
                return false;
            }
            String this$resourceAbsolutePathInLocal = this.getResourceAbsolutePathInLocal();
            String other$resourceAbsolutePathInLocal = other.getResourceAbsolutePathInLocal();
            return !(this$resourceAbsolutePathInLocal == null ? other$resourceAbsolutePathInLocal != null : !this$resourceAbsolutePathInLocal.equals(other$resourceAbsolutePathInLocal));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResourceItem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resourceAbsolutePathInStorage = this.getResourceAbsolutePathInStorage();
            result = result * 59 + ($resourceAbsolutePathInStorage == null ? 43 : $resourceAbsolutePathInStorage.hashCode());
            String $resourceAbsolutePathInLocal = this.getResourceAbsolutePathInLocal();
            result = result * 59 + ($resourceAbsolutePathInLocal == null ? 43 : $resourceAbsolutePathInLocal.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ResourceContext.ResourceItem(resourceAbsolutePathInStorage=" + this.getResourceAbsolutePathInStorage() + ", resourceAbsolutePathInLocal=" + this.getResourceAbsolutePathInLocal() + ")";
        }

        @Generated
        public ResourceItem(String resourceAbsolutePathInStorage, String resourceAbsolutePathInLocal) {
            this.resourceAbsolutePathInStorage = resourceAbsolutePathInStorage;
            this.resourceAbsolutePathInLocal = resourceAbsolutePathInLocal;
        }

        @Generated
        public ResourceItem() {
        }

        @Generated
        public static class ResourceItemBuilder {
            @Generated
            private String resourceAbsolutePathInStorage;
            @Generated
            private String resourceAbsolutePathInLocal;

            @Generated
            ResourceItemBuilder() {
            }

            @Generated
            public ResourceItemBuilder resourceAbsolutePathInStorage(String resourceAbsolutePathInStorage) {
                this.resourceAbsolutePathInStorage = resourceAbsolutePathInStorage;
                return this;
            }

            @Generated
            public ResourceItemBuilder resourceAbsolutePathInLocal(String resourceAbsolutePathInLocal) {
                this.resourceAbsolutePathInLocal = resourceAbsolutePathInLocal;
                return this;
            }

            @Generated
            public ResourceItem build() {
                return new ResourceItem(this.resourceAbsolutePathInStorage, this.resourceAbsolutePathInLocal);
            }

            @Generated
            public String toString() {
                return "ResourceContext.ResourceItem.ResourceItemBuilder(resourceAbsolutePathInStorage=" + this.resourceAbsolutePathInStorage + ", resourceAbsolutePathInLocal=" + this.resourceAbsolutePathInLocal + ")";
            }
        }
    }
}

