/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.P2SConnectionConfigurationProperties;
import com.azure.resourcemanager.network.fluent.models.VpnServerConfigurationPolicyGroupInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class P2SConnectionConfiguration
extends SubResource {
    @JsonProperty(value="properties")
    private P2SConnectionConfigurationProperties innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;

    private P2SConnectionConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public P2SConnectionConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public P2SConnectionConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    public AddressSpace vpnClientAddressPool() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnClientAddressPool();
    }

    public P2SConnectionConfiguration withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new P2SConnectionConfigurationProperties();
        }
        this.innerProperties().withVpnClientAddressPool(vpnClientAddressPool);
        return this;
    }

    public RoutingConfiguration routingConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().routingConfiguration();
    }

    public P2SConnectionConfiguration withRoutingConfiguration(RoutingConfiguration routingConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new P2SConnectionConfigurationProperties();
        }
        this.innerProperties().withRoutingConfiguration(routingConfiguration);
        return this;
    }

    public Boolean enableInternetSecurity() {
        return this.innerProperties() == null ? null : this.innerProperties().enableInternetSecurity();
    }

    public P2SConnectionConfiguration withEnableInternetSecurity(Boolean enableInternetSecurity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new P2SConnectionConfigurationProperties();
        }
        this.innerProperties().withEnableInternetSecurity(enableInternetSecurity);
        return this;
    }

    public List<SubResource> configurationPolicyGroupAssociations() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationPolicyGroupAssociations();
    }

    public List<VpnServerConfigurationPolicyGroupInner> previousConfigurationPolicyGroupAssociations() {
        return this.innerProperties() == null ? null : this.innerProperties().previousConfigurationPolicyGroupAssociations();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

