/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.util.CleanableReference;
import com.azure.core.util.ReferenceManager;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;

public final class ReferenceManagerImpl
implements ReferenceManager {
    private static final ClientLogger LOGGER = new ClientLogger(ReferenceManagerImpl.class);
    private static final String BASE_THREAD_NAME = "azure-sdk-referencemanager";
    private static final Object CLEANER;
    private static final MethodHandle CLEANER_REGISTER;
    private final CleanableReference<?> cleanableReferenceList;
    private final ReferenceQueue<Object> queue;

    public ReferenceManagerImpl() {
        if (CLEANER == null) {
            this.queue = new ReferenceQueue();
            this.cleanableReferenceList = new CleanableReference();
            Thread thread = new Thread(this::clearReferenceQueue, BASE_THREAD_NAME);
            new CleanableReference<ReferenceManagerImpl>(this, () -> {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    LOGGER.log(LogLevel.WARNING, () -> "Failed to shutdown ReferenceManager thread.", e);
                }
            }, this);
            thread.setDaemon(true);
            thread.start();
        } else {
            this.queue = null;
            this.cleanableReferenceList = null;
        }
    }

    @Override
    public void register(Object object, Runnable cleanupAction) {
        Objects.requireNonNull(object, "'object' cannot be null.");
        Objects.requireNonNull(cleanupAction, "'cleanupAction' cannot be null.");
        if (CLEANER == null) {
            new CleanableReference<Object>(object, cleanupAction, this);
        } else {
            try {
                CLEANER_REGISTER.invoke(CLEANER, object, cleanupAction);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw LOGGER.logExceptionAsError((RuntimeException)throwable);
                }
                throw LOGGER.logExceptionAsError(new RuntimeException(throwable));
            }
        }
    }

    void clearReferenceQueue() {
        while (this.cleanableReferenceList.hasRemaining()) {
            CleanableReference reference = null;
            try {
                reference = (CleanableReference)this.queue.remove(30000L);
            }
            catch (InterruptedException ex) {
                LOGGER.log(LogLevel.VERBOSE, () -> "ReferenceManager Thread interrupted while waiting for a reference to clean.", ex);
            }
            try {
                if (reference == null) continue;
                reference.clean();
            }
            catch (Exception ex) {
                LOGGER.log(LogLevel.INFORMATIONAL, () -> "Cleaning a reference threw an exception.", ex);
            }
        }
    }

    static boolean isCleanerUsed() {
        return CLEANER != null;
    }

    ReferenceQueue<Object> getQueue() {
        return this.queue;
    }

    CleanableReference<?> getCleanableReferenceList() {
        return this.cleanableReferenceList;
    }

    static {
        Object cleaner = null;
        MethodHandle cleanerRegister = null;
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> cleanerClass = Class.forName("java.lang.ref.Cleaner");
            cleaner = cleanerClass.getDeclaredMethod("create", ThreadFactory.class).invoke(null, r -> new Thread(r, BASE_THREAD_NAME));
            cleanerRegister = lookup.unreflect(cleanerClass.getMethod("register", Object.class, Runnable.class));
        }
        catch (ReflectiveOperationException ex) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Unable to use java.lang.ref.Cleaner to manage references.", ex);
        }
        CLEANER = cleaner;
        CLEANER_REGISTER = cleanerRegister;
    }
}

